/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.annotation.UiThread;
import com.serenegiant.common.R;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ViewUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = ViewUtils.class.getSimpleName();
    public static final float EPS = 0.1f;
    public static final float TO_DEGREE = 57.29578f;
    private static final Vector sPtInPoly_v1 = new Vector();
    private static final Vector sPtInPoly_v2 = new Vector();
    @IdRes
    private static final int[] ICON_IDS = new int[]{R.id.thumbnail, 16908294, R.id.icon, R.id.image};
    @IdRes
    private static final int[] TITLE_IDS = new int[]{R.id.title, R.id.content, 16908310, 16908308, 16908309};

    private ViewUtils() {
    }

    @UiThread
    public static void requestResize(@NonNull View view, int width, int height) {
        view.getLayoutParams().width = width;
        view.getLayoutParams().height = height;
        view.requestLayout();
    }

    public static void setBackgroundAll(ViewGroup vg, int color2) {
        int count = vg.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = vg.getChildAt(i);
            child.setBackgroundColor(color2);
            if (!(child instanceof ViewGroup)) continue;
            ViewUtils.setBackgroundAll((ViewGroup)child, color2);
        }
    }

    public static void setBackgroundAll(ViewGroup vg, Drawable dr) {
        int count = vg.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = vg.getChildAt(i);
            child.setBackground(dr);
            if (!(child instanceof ViewGroup)) continue;
            ViewUtils.setBackgroundAll((ViewGroup)child, dr);
        }
    }

    public static LayoutInflater createCustomLayoutInflater(@NonNull Context context, @StyleRes int themeRes) {
        return ViewUtils.createCustomLayoutInflater(context, LayoutInflater.from((Context)context), themeRes);
    }

    public static LayoutInflater createCustomLayoutInflater(@NonNull LayoutInflater inflater, @StyleRes int themeRes) {
        return ViewUtils.createCustomLayoutInflater(inflater.getContext(), inflater, themeRes);
    }

    @NonNull
    public static LayoutInflater createCustomLayoutInflater(@NonNull Context context, @NonNull LayoutInflater inflater, @StyleRes int themeRes) {
        ContextThemeWrapper wrappedContext = new ContextThemeWrapper(context, themeRes);
        return inflater.cloneInContext((Context)wrappedContext);
    }

    @SuppressLint(value={"NewApi"})
    public static int getRotation(@NonNull View view) {
        int rotation;
        if (BuildCheck.isAPI17()) {
            rotation = view.getDisplay().getRotation();
        } else {
            Display display = ContextUtils.requireSystemService(view.getContext(), WindowManager.class).getDefaultDisplay();
            rotation = display.getRotation();
        }
        return rotation;
    }

    @SuppressLint(value={"NewApi"})
    public static int getRotation(@NonNull Context context) {
        Display display = ContextUtils.requireSystemService(context, WindowManager.class).getDefaultDisplay();
        return display.getRotation();
    }

    public static int getRotationDegrees(@NonNull View view) {
        return ViewUtils.rotation2Degrees(ViewUtils.getRotation(view));
    }

    public static int getRotationDegrees(@NonNull Context context) {
        return ViewUtils.rotation2Degrees(ViewUtils.getRotation(context));
    }

    private static int rotation2Degrees(int rotation) {
        int degrees;
        switch (rotation) {
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
                break;
            }
            default: {
                degrees = 0;
            }
        }
        return degrees;
    }

    public static int getOrientation(@NonNull Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public static final float dotProduct(float x0, float y0, float x1, float y1) {
        return x0 * x1 + y0 * y1;
    }

    public static final float crossProduct(float x0, float y0, float x1, float y1) {
        return x0 * y1 - x1 * y0;
    }

    public static final float crossProduct(Vector v1, Vector v2) {
        return v1.x * v2.y - v2.x * v1.y;
    }

    public static synchronized boolean ptInPoly(float x, float y, float[] poly) {
        int n = poly.length & Integer.MAX_VALUE;
        if (n < 6) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < n; i += 2) {
            sPtInPoly_v1.set(x, y).dec(poly[i], poly[i + 1]);
            if (i + 2 < n) {
                sPtInPoly_v2.set(poly[i + 2], poly[i + 3]);
            } else {
                sPtInPoly_v2.set(poly[0], poly[1]);
            }
            sPtInPoly_v2.dec(poly[i], poly[i + 1]);
            if (!(ViewUtils.crossProduct(sPtInPoly_v1, sPtInPoly_v2) > 0.0f)) continue;
            result = false;
            break;
        }
        return result;
    }

    public static final boolean checkIntersect(LineSegment seg, LineSegment[] segs) {
        boolean result = false;
        int n = segs != null ? segs.length : 0;
        Vector a = seg.p2.sub(seg.p1);
        for (int i = 0; i < n; ++i) {
            Vector c = segs[i].p1.sub(seg.p1);
            Vector d = segs[i].p2.sub(seg.p1);
            boolean bl = result = ViewUtils.crossProduct(a, c) * ViewUtils.crossProduct(a, d) < 0.1f;
            if (!result) continue;
            Vector b = segs[i].p2.sub(segs[i].p1);
            c = seg.p1.sub(segs[i].p1);
            d = seg.p2.sub(segs[i].p1);
            boolean bl2 = result = ViewUtils.crossProduct(b, c) * ViewUtils.crossProduct(b, d) < 0.1f;
            if (result) break;
        }
        return result;
    }

    @Nullable
    public static ImageView findIconView(@NonNull View view) {
        return ViewUtils.findView(view, ICON_IDS, ImageView.class);
    }

    @Nullable
    public static ImageView findIconView(@NonNull View view, @NonNull @IdRes int[] ids) {
        return ViewUtils.findView(view, ids, ImageView.class);
    }

    @Nullable
    public static TextView findTitleView(@NonNull View view) {
        return ViewUtils.findView(view, TITLE_IDS, TextView.class);
    }

    @Nullable
    public static TextView findTitleView(@NonNull View view, @NonNull @IdRes int[] ids) {
        return ViewUtils.findView(view, ids, TextView.class);
    }

    @Nullable
    public static <T extends View> T findView(@NonNull View view, @NonNull @IdRes int[] ids, @NonNull Class<T> clazz) {
        View result = null;
        if (clazz.isInstance(view)) {
            result = view;
        } else {
            for (int id2 : ids) {
                View v = view.findViewById(id2);
                if (!clazz.isInstance(v)) continue;
                result = v;
                break;
            }
        }
        return (T)result;
    }

    @Nullable
    public static <T extends View> T findViewInParent(@NonNull View view, @NonNull @IdRes int[] ids, @NonNull Class<T> clazz) {
        View result = null;
        block0: for (int id2 : ids) {
            if (id2 == -1) continue;
            View v = view.findViewById(id2);
            if (clazz.isInstance(v)) {
                result = v;
                break;
            }
            if (result != null) continue;
            for (ViewParent parent = view.getParent(); parent != null && result == null; parent = parent.getParent()) {
                View vv;
                if (!(parent instanceof View) || !clazz.isInstance(vv = ((View)parent).findViewById(id2))) continue;
                result = vv;
                break block0;
            }
        }
        return (T)result;
    }

    public static final class LineSegment {
        public final Vector p1;
        public final Vector p2;

        public LineSegment(float x0, float y0, float x1, float y1) {
            this.p1 = new Vector(x0, y0);
            this.p2 = new Vector(x1, y1);
        }

        public LineSegment set(float x0, float y0, float x1, float y1) {
            this.p1.set(x0, y0);
            this.p2.set(x1, y1);
            return this;
        }
    }

    public static final class Vector {
        public float x;
        public float y;

        public Vector() {
        }

        public Vector(float x, float y) {
            this.set(x, y);
        }

        public Vector set(float x, float y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Vector sub(Vector other) {
            return new Vector(this.x - other.x, this.y - other.y);
        }

        public Vector dec(float x, float y) {
            this.x -= x;
            this.y -= y;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Rotation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Visibility {
    }
}

