/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.TargetApi;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;

public class HandlerUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = HandlerUtils.class.getSimpleName();

    private HandlerUtils() {
    }

    @TargetApi(value=18)
    public static void quitSafely(@Nullable Handler handler) throws IllegalStateException {
        Looper looper;
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null) {
            throw new IllegalStateException("has no looper");
        }
        looper.quitSafely();
    }

    @TargetApi(value=18)
    public static void NoThrowQuitSafely(@Nullable Handler handler) {
        try {
            HandlerUtils.quitSafely(handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void quit(@Nullable Handler handler) throws IllegalStateException {
        Looper looper;
        Looper looper2 = looper = handler != null ? handler.getLooper() : null;
        if (looper == null) {
            throw new IllegalStateException("has no looper");
        }
        looper.quit();
    }

    public static void NoThrowQuit(@Nullable Handler handler) {
        try {
            HandlerUtils.quit(handler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isActive(@Nullable Handler handler) {
        Thread thread = handler != null ? handler.getLooper().getThread() : null;
        return handler != null && thread != null && thread.isAlive() && handler.sendEmptyMessage(0);
    }

    public static boolean isTerminated(@Nullable Handler handler) {
        Thread thread = handler != null ? handler.getLooper().getThread() : null;
        return handler == null || thread == null || !thread.isAlive() || !handler.sendEmptyMessage(0);
    }
}

