/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public class HandlerThreadHandler
extends Handler {
    private static final String TAG = "HandlerThreadHandler";
    private final long mId;
    private final boolean mAsynchronous;

    @SuppressLint(value={"NewApi"})
    public static final HandlerThreadHandler createHandler() {
        return HandlerThreadHandler.createHandler(TAG, false);
    }

    @RequiresApi(api=22)
    public static final HandlerThreadHandler createHandler(boolean async) {
        return HandlerThreadHandler.createHandler(TAG, async);
    }

    @SuppressLint(value={"NewApi"})
    public static final HandlerThreadHandler createHandler(String name) {
        return HandlerThreadHandler.createHandler(name, false);
    }

    @RequiresApi(api=22)
    public static final HandlerThreadHandler createHandler(String name, boolean async) {
        HandlerThread thread = new HandlerThread(name);
        thread.start();
        return new HandlerThreadHandler(thread.getLooper(), async);
    }

    public static final HandlerThreadHandler createHandler(@Nullable Handler.Callback callback) {
        return HandlerThreadHandler.createHandler(TAG, callback);
    }

    @RequiresApi(api=22)
    public static final HandlerThreadHandler createHandler(@Nullable Handler.Callback callback, boolean async) {
        return HandlerThreadHandler.createHandler(TAG, callback, async);
    }

    public static final HandlerThreadHandler createHandler(String name, @Nullable Handler.Callback callback) {
        HandlerThread thread = new HandlerThread(name);
        thread.start();
        return new HandlerThreadHandler(thread.getLooper(), callback, false);
    }

    @RequiresApi(api=22)
    public static final HandlerThreadHandler createHandler(String name, @Nullable Handler.Callback callback, boolean async) {
        HandlerThread thread = new HandlerThread(name);
        thread.start();
        return new HandlerThreadHandler(thread.getLooper(), callback, async);
    }

    private HandlerThreadHandler(@NonNull Looper looper, boolean async) {
        super(looper);
        this.mId = looper.getThread().getId();
        this.mAsynchronous = async;
    }

    private HandlerThreadHandler(@NonNull Looper looper, @Nullable Handler.Callback callback, boolean async) {
        super(looper, callback);
        this.mId = looper.getThread().getId();
        this.mAsynchronous = async;
    }

    @SuppressLint(value={"NewApi"})
    public boolean sendMessageAtTime(@NonNull Message msg, long uptimeMillis) {
        if (this.mAsynchronous && Build.VERSION.SDK_INT >= 22) {
            msg.setAsynchronous(true);
        }
        return super.sendMessageAtTime(msg, uptimeMillis);
    }

    public long getId() {
        return this.mId;
    }

    @TargetApi(value=18)
    public void quitSafely() throws IllegalStateException {
        Looper looper = this.getLooper();
        if (looper == null) {
            throw new IllegalStateException("has no looper");
        }
        looper.quitSafely();
    }

    public void quit() throws IllegalStateException {
        Looper looper = this.getLooper();
        if (looper == null) {
            throw new IllegalStateException("has no looper");
        }
        looper.quit();
    }

    public boolean isCurrentThread() throws IllegalStateException {
        Looper looper = this.getLooper();
        if (looper != null) {
            return this.mId == Thread.currentThread().getId();
        }
        throw new IllegalStateException("has no looper");
    }
}

