/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.StatFs;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.StorageInfo;
import com.serenegiant.utils.FileUtils;
import com.serenegiant.utils.UriHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class StorageUtils {
    private StorageUtils() {
    }

    @Nullable
    public static String getExternalMounts() {
        String externalpath = null;
        String internalpath = "";
        Runtime runtime = Runtime.getRuntime();
        try {
            String line;
            Process proc = runtime.exec("mount");
            BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = br.readLine()) != null) {
                String[] columns;
                if (line.contains("secure") || line.contains("asec")) continue;
                if (line.contains("fat")) {
                    columns = line.split(" ");
                    if (columns == null || columns.length <= 1 || TextUtils.isEmpty((CharSequence)columns[1]) || (externalpath = columns[1]).endsWith("/")) continue;
                    externalpath = externalpath + "/";
                    continue;
                }
                if (!line.contains("fuse") || (columns = line.split(" ")) == null || columns.length <= 1) continue;
                internalpath = internalpath.concat("[" + columns[1] + "]");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return externalpath;
    }

    @Deprecated
    @SuppressLint(value={"UsableSpace"})
    @NonNull
    public static StorageInfo getStorageInfo(@NonNull Context context, @NonNull String type, int saveTreeId) throws IOException {
        try {
            File dir = FileUtils.getCaptureDir(context, type, saveTreeId);
            if (dir != null) {
                long freeSpace = dir.canWrite() ? dir.getUsableSpace() : 0L;
                return new StorageInfo(dir.getTotalSpace(), freeSpace);
            }
        }
        catch (Exception e) {
            Log.w((String)"getStorageInfo:", (Throwable)e);
        }
        throw new IOException();
    }

    @SuppressLint(value={"UsableSpace"})
    @NonNull
    public static StorageInfo getStorageInfo(@NonNull Context context, @NonNull String type) throws IOException {
        try {
            File dir = FileUtils.getCaptureDir(context, type);
            if (dir != null) {
                long freeSpace = dir.canWrite() ? dir.getUsableSpace() : 0L;
                return new StorageInfo(dir.getTotalSpace(), freeSpace);
            }
        }
        catch (Exception e) {
            Log.w((String)"getStorageInfo:", (Throwable)e);
        }
        throw new IOException();
    }

    @SuppressLint(value={"NewApi", "UsableSpace"})
    @NonNull
    public static StorageInfo getStorageInfo(@NonNull Context context, @NonNull DocumentFile dir) throws IOException {
        String path2;
        try {
            File file;
            path2 = UriHelper.getPath(context, dir.getUri());
            if (path2 != null && (file = new File(path2)).isDirectory() && file.canRead()) {
                long total = file.getTotalSpace();
                long free = file.getFreeSpace();
                if (free < file.getUsableSpace()) {
                    free = file.getUsableSpace();
                }
                return new StorageInfo(total, free);
            }
        }
        catch (Exception path2) {
            // empty catch block
        }
        if (BuildCheck.isJellyBeanMR2()) {
            try {
                path2 = UriHelper.getPath(context, dir.getUri());
                StatFs fs = new StatFs(path2);
                return new StorageInfo(fs.getTotalBytes(), fs.getAvailableBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException();
    }
}

