/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.UriPermission;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SAFUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = SAFUtils.class.getSimpleName();
    private static final String KEY_PREFIX = "SDUtils-";

    private SAFUtils() {
    }

    @RequiresApi(api=19)
    public static boolean hasPermission(@NonNull Context context, int treeId) {
        if (BuildCheck.isKitKat()) {
            Uri uri = SAFUtils.loadUri(context, SAFUtils.getKey(treeId));
            if (uri != null) {
                List list = context.getContentResolver().getPersistedUriPermissions();
                return SAFUtils.hasPermission(list, uri);
            }
        } else {
            throw new UnsupportedOperationException("should be API>=19");
        }
        return false;
    }

    @RequiresApi(api=19)
    public static boolean hasPermission(@NonNull List<UriPermission> persistedUriPermissions, @NonNull Uri uri) {
        for (UriPermission item : persistedUriPermissions) {
            if (!item.getUri().equals((Object)uri)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static Uri takePersistableUriPermission(@NonNull Context context, int treeId, @NonNull Uri treeUri) {
        return SAFUtils.takePersistableUriPermission(context, treeId, treeUri, 3);
    }

    @TargetApi(value=19)
    @NonNull
    public static Uri takePersistableUriPermission(@NonNull Context context, int treeId, @NonNull Uri treeUri, int flags) {
        if (BuildCheck.isLollipop()) {
            context.getContentResolver().takePersistableUriPermission(treeUri, flags);
            SAFUtils.saveUri(context, SAFUtils.getKey(treeId), treeUri);
            return treeUri;
        }
        throw new UnsupportedOperationException("should be API>=19");
    }

    @TargetApi(value=19)
    public static void releasePersistableUriPermission(@NonNull Context context, int treeId) {
        if (BuildCheck.isKitKat()) {
            String key = SAFUtils.getKey(treeId);
            Uri uri = SAFUtils.loadUri(context, key);
            if (uri != null) {
                try {
                    context.getContentResolver().releasePersistableUriPermission(uri, 3);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                SAFUtils.clearUri(context, key);
            }
        } else {
            throw new UnsupportedOperationException("should be API>=19");
        }
    }

    @RequiresApi(api=19)
    @NonNull
    public static DocumentFile getDir(@NonNull Context context, int treeId, @Nullable String dirs) throws IOException {
        if (BuildCheck.isLollipop()) {
            Uri treeUri = SAFUtils.getStorageUri(context, treeId);
            if (treeUri != null) {
                return SAFUtils.getDir(DocumentFile.fromTreeUri((Context)context, (Uri)treeUri), dirs);
            }
            throw new FileNotFoundException("specific dir not found");
        }
        throw new UnsupportedOperationException("should be API>=21");
    }

    @NonNull
    public static DocumentFile getDir(@NonNull DocumentFile parent, @Nullable String dirs) throws IOException {
        DocumentFile tree = parent;
        if (!TextUtils.isEmpty((CharSequence)dirs)) {
            String[] dir;
            for (String d : dir = dirs.split("/")) {
                if (TextUtils.isEmpty((CharSequence)d)) continue;
                if ("..".equals(d)) {
                    if ((tree = tree.getParentFile()) != null) continue;
                    throw new IOException("failed to get parent directory");
                }
                if (".".equals(d)) continue;
                DocumentFile t = tree.findFile(d);
                if (t != null && t.isDirectory()) {
                    tree = t;
                    continue;
                }
                if (t == null) {
                    if (tree.canWrite()) {
                        tree = tree.createDirectory(d);
                        continue;
                    }
                    throw new IOException("can't create directory");
                }
                throw new IOException("can't create directory, file with same name already exists");
            }
        }
        return tree;
    }

    @NonNull
    public static List<DocumentFile> listFiles(@NonNull DocumentFile dir, @Nullable FileFilter filter) {
        ArrayList<DocumentFile> result = new ArrayList<DocumentFile>();
        if (dir.isDirectory()) {
            DocumentFile[] files;
            for (DocumentFile file : files = dir.listFiles()) {
                if (filter != null && !filter.accept(file)) continue;
                result.add(file);
            }
        }
        return result;
    }

    @RequiresApi(api=19)
    @NonNull
    public static DocumentFile getFile(@NonNull Context context, int treeId, @Nullable String dirs, @NonNull String mime, @NonNull String name) throws IOException {
        if (BuildCheck.isLollipop()) {
            DocumentFile tree = SAFUtils.getDir(context, treeId, dirs);
            if (tree != null) {
                return SAFUtils.getFile(tree, null, mime, name);
            }
            throw new IOException("specific dir not found");
        }
        throw new UnsupportedOperationException("should be API>=21");
    }

    @NonNull
    public static DocumentFile getFile(@NonNull DocumentFile parent, @Nullable String dirs, @NonNull String mime, @NonNull String name) throws IOException {
        DocumentFile tree = SAFUtils.getDir(parent, dirs);
        DocumentFile file = tree.findFile(name);
        if (file != null) {
            if (file.isFile()) {
                return file;
            }
            throw new IOException("directory with same name already exists");
        }
        return SAFUtils.createFile(tree, mime, name);
    }

    @RequiresApi(api=19)
    @NonNull
    public static OutputStream getOutputStream(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        if (BuildCheck.isLollipop()) {
            DocumentFile tree = SAFUtils.getDir(context, treeId, dirs);
            if (tree != null) {
                return SAFUtils.getOutputStream(context, tree, null, mime, name);
            }
            throw new FileNotFoundException("specific dir not found");
        }
        throw new UnsupportedOperationException("should be API>=21");
    }

    @NonNull
    public static OutputStream getOutputStream(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree = SAFUtils.getDir(parent, dirs);
        DocumentFile file = tree.findFile(name);
        if (file != null) {
            if (file.isFile()) {
                return context.getContentResolver().openOutputStream(file.getUri());
            }
            throw new IOException("directory with same name already exists");
        }
        return context.getContentResolver().openOutputStream(SAFUtils.createFile(tree, mime, name).getUri());
    }

    @RequiresApi(api=19)
    @NonNull
    public static InputStream getInputStream(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        if (BuildCheck.isLollipop()) {
            DocumentFile tree = SAFUtils.getDir(context, treeId, dirs);
            if (tree != null) {
                return SAFUtils.getInputStream(context, tree, null, mime, name);
            }
            throw new FileNotFoundException("specifc dir not found");
        }
        throw new UnsupportedOperationException("should be API>=21");
    }

    @NonNull
    public static InputStream getInputStream(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree = SAFUtils.getDir(parent, dirs);
        DocumentFile file = tree.findFile(name);
        if (file != null) {
            if (file.isFile()) {
                return context.getContentResolver().openInputStream(file.getUri());
            }
            throw new IOException("directory with same name already exists");
        }
        throw new FileNotFoundException("specific file not found");
    }

    @RequiresApi(api=19)
    @NonNull
    public static ParcelFileDescriptor getFd(@NonNull Context context, int treeId, @Nullable String dirs, String mime, String name) throws IOException {
        if (BuildCheck.isLollipop()) {
            DocumentFile tree = SAFUtils.getDir(context, treeId, dirs);
            if (tree != null) {
                DocumentFile file = tree.findFile(name);
                if (file != null) {
                    if (file.isFile()) {
                        return context.getContentResolver().openFileDescriptor(file.getUri(), "rw");
                    }
                    throw new IOException("directory with same name already exists");
                }
                return context.getContentResolver().openFileDescriptor(SAFUtils.createFile(tree, mime, name).getUri(), "rw");
            }
            throw new FileNotFoundException("specific dir not found");
        }
        throw new UnsupportedOperationException("should be API>=21");
    }

    @NonNull
    public static ParcelFileDescriptor getFd(@NonNull Context context, @NonNull DocumentFile parent, @Nullable String dirs, String mime, String name) throws IOException {
        DocumentFile tree = SAFUtils.getDir(parent, dirs);
        DocumentFile file = tree.findFile(name);
        if (file != null) {
            if (file.isFile()) {
                return context.getContentResolver().openFileDescriptor(file.getUri(), "rw");
            }
            throw new IOException("directory with same name already exists");
        }
        return context.getContentResolver().openFileDescriptor(SAFUtils.createFile(tree, mime, name).getUri(), "rw");
    }

    @TargetApi(value=19)
    @NonNull
    public static Map<Integer, Uri> getStorageUriAll(@NonNull Context context) {
        HashMap<Integer, Uri> result = new HashMap<Integer, Uri>();
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        Map values = pref.getAll();
        ArrayList<String> removes = new ArrayList<String>();
        List list = context.getContentResolver().getPersistedUriPermissions();
        for (String key : values.keySet()) {
            if (!key.startsWith(KEY_PREFIX)) continue;
            Object value = values.get(key);
            if (value instanceof String) {
                try {
                    int treeId = Integer.parseInt(key.substring(KEY_PREFIX.length()));
                    Uri uri = Uri.parse((String)((String)value));
                    if (SAFUtils.hasPermission(list, uri)) {
                        result.put(treeId, uri);
                        continue;
                    }
                    removes.add(key);
                }
                catch (NumberFormatException e) {
                    Log.d((String)TAG, (String)("getStorageUriAll:unexpected key format," + key + ",value=" + value));
                }
                continue;
            }
            Log.d((String)TAG, (String)("getStorageUriAll:unexpected key-value pair,key=" + key + ",value=" + value));
        }
        if (!removes.isEmpty()) {
            for (String key : removes) {
                SAFUtils.clearUri(context, key);
            }
        }
        return result;
    }

    @NonNull
    private static String getKey(int treeId) {
        return String.format(Locale.US, "SDUtils-%d", treeId);
    }

    private static void saveUri(@NonNull Context context, @NonNull String key, @NonNull Uri uri) {
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null) {
            pref.edit().putString(key, uri.toString()).apply();
        }
    }

    @Nullable
    private static Uri loadUri(@NonNull Context context, @NonNull String key) {
        Uri result = null;
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null && pref.contains(key)) {
            try {
                result = Uri.parse((String)pref.getString(key, null));
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return result;
    }

    private static void clearUri(@NonNull Context context, @Nullable String key) {
        SharedPreferences pref = context.getSharedPreferences(context.getPackageName(), 0);
        if (pref != null && pref.contains(key)) {
            try {
                pref.edit().remove(key).apply();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @RequiresApi(api=19)
    @Nullable
    static Uri getStorageUri(@NonNull Context context, int treeId) throws UnsupportedOperationException {
        if (BuildCheck.isKitKat()) {
            Uri uri = SAFUtils.loadUri(context, SAFUtils.getKey(treeId));
            if (uri != null) {
                boolean found = false;
                List list = context.getContentResolver().getPersistedUriPermissions();
                for (UriPermission item : list) {
                    if (!item.getUri().equals((Object)uri)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return uri;
                }
            }
        } else {
            throw new UnsupportedOperationException("should be API>=21");
        }
        return null;
    }

    @RequiresApi(api=21)
    private static Intent prepareStorageAccessPermission() {
        return new Intent("android.intent.action.OPEN_DOCUMENT_TREE");
    }

    private static DocumentFile createFile(@NonNull DocumentFile tree, @NonNull String mime, @NonNull String name) {
        String ext = FileUtils.getExt(name);
        if (TextUtils.isEmpty((CharSequence)ext)) {
            return tree.createFile(mime, name);
        }
        String[] types = mime.split("/");
        return tree.createFile(types[0] + "/" + ext, FileUtils.removeFileExtension(name));
    }

    public static interface FileFilter {
        public boolean accept(@NonNull DocumentFile var1);
    }
}

