/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import java.lang.ref.WeakReference;

public abstract class ContextHolder<T extends Context> {
    @NonNull
    private final WeakReference<T> mWeakContext;
    private volatile boolean mReleased;

    public ContextHolder(@NonNull T context) {
        this.mWeakContext = new WeakReference<T>(context);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
            this.mWeakContext.clear();
        }
    }

    protected abstract void internalRelease();

    @Nullable
    public T getContext() {
        return (T)((Context)this.mWeakContext.get());
    }

    @NonNull
    public T requireContext() throws IllegalStateException {
        T context = this.getContext();
        if (context == null) {
            throw new IllegalStateException();
        }
        return context;
    }

    @Nullable
    public AssetManager getAssets() {
        T context = this.getContext();
        return context != null ? context.getAssets() : null;
    }

    @NonNull
    public AssetManager requireAssets() throws IllegalStateException {
        AssetManager result = this.requireContext().getAssets();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    public ContentResolver getContentResolver() {
        T context = this.getContext();
        return context != null ? context.getContentResolver() : null;
    }

    @NonNull
    public ContentResolver requireContentResolver() throws IllegalStateException {
        ContentResolver result = this.requireContext().getContentResolver();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    @NonNull
    public LocalBroadcastManager requireLocalBroadcastManager() throws IllegalStateException {
        return LocalBroadcastManager.getInstance(this.requireContext());
    }

    @Nullable
    public Looper getMainLooper() {
        T context = this.getContext();
        return context != null ? context.getMainLooper() : null;
    }

    @NonNull
    public Looper requireMainLooper() throws IllegalStateException {
        Looper result = this.requireContext().getMainLooper();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    @NonNull
    public PackageManager getPackageManager() {
        T context = this.getContext();
        return context != null ? context.getPackageManager() : null;
    }

    @NonNull
    public PackageManager requirePackageManager() {
        PackageManager result = this.requireContext().getPackageManager();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    public String getPackageName() {
        T context = this.getContext();
        return context != null ? context.getPackageName() : null;
    }

    @NonNull
    public String requirePackageName() throws IllegalStateException {
        String result = this.requireContext().getPackageName();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    @Nullable
    public Resources getResources() {
        T context = this.getContext();
        return context != null ? context.getResources() : null;
    }

    @NonNull
    public Resources requireResources() throws IllegalStateException {
        Resources result = this.requireContext().getResources();
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    @Nullable
    public SharedPreferences getSharedPreferences(String name, int mode) {
        T context = this.getContext();
        return context != null ? context.getSharedPreferences(name, mode) : null;
    }

    @NonNull
    public SharedPreferences requireSharedPreferences(String name, int mode) throws IllegalStateException {
        SharedPreferences result = this.requireContext().getSharedPreferences(name, mode);
        if (result == null) {
            throw new IllegalStateException();
        }
        return result;
    }

    @NonNull
    public String getString(int resId) throws IllegalStateException {
        return this.requireContext().getString(resId);
    }

    @NonNull
    public String getString(int resId, Object ... formatArgs) throws IllegalStateException {
        return this.requireContext().getString(resId, formatArgs);
    }

    @NonNull
    public CharSequence getText(int resId) throws IllegalStateException {
        return this.requireContext().getText(resId);
    }

    public void sendLocalBroadcast(@NonNull Intent intent) throws IllegalStateException {
        this.requireLocalBroadcastManager().sendBroadcast(intent);
    }
}

