/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.preference;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.NumberPicker;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.preference.PreferenceDialogFragmentCompat;
import com.serenegiant.preference.NumberPickerPreferenceV7;

public class NumberPickerPreferenceFragmentCompat
extends PreferenceDialogFragmentCompat {
    private static final boolean DEBUG = false;
    private static final String TAG = NumberPickerPreferenceFragmentCompat.class.getSimpleName();
    private static final String SAVE_STATE_MIN_VALUE = "NumberPickerPreferenceFragment.minValue";
    private static final String SAVE_STATE_MAX_VALUE = "NumberPickerPreferenceFragment.maxValue";
    private static final String SAVE_STATE_VALUE = "NumberPickerPreferenceFragment.value";
    private int mMinValue;
    private int mMaxValue;
    private int mValue;
    private boolean changed;
    private final NumberPicker.OnValueChangeListener mOnValueChangeListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
            if (oldVal != newVal) {
                NumberPickerPreferenceFragmentCompat.this.changed = true;
            }
            NumberPickerPreferenceFragmentCompat.this.mValue = newVal;
        }
    };

    public static NumberPickerPreferenceFragmentCompat newInstance(String key) {
        NumberPickerPreferenceFragmentCompat fragment = new NumberPickerPreferenceFragmentCompat();
        Bundle args = new Bundle(1);
        args.putString("key", key);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            NumberPickerPreferenceV7 preference = this.getNumberPickerPreference();
            this.mMinValue = preference.getMinValue();
            this.mMaxValue = preference.getMaxValue();
            this.mValue = preference.getValue();
        } else {
            this.mMinValue = savedInstanceState.getInt(SAVE_STATE_MIN_VALUE, 0);
            this.mMaxValue = savedInstanceState.getInt(SAVE_STATE_MAX_VALUE, 100);
            this.mValue = savedInstanceState.getInt(SAVE_STATE_VALUE, 0);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt(SAVE_STATE_MIN_VALUE, this.mMinValue);
        outState.putInt(SAVE_STATE_MAX_VALUE, this.mMaxValue);
        outState.putInt(SAVE_STATE_VALUE, this.mValue);
    }

    public void onDialogClosed(boolean positiveResult) {
        NumberPickerPreferenceV7 preference = this.getNumberPickerPreference();
        if ((positiveResult || this.changed) && preference.callChangeListener(this.mValue)) {
            preference.setValue(this.mValue);
        }
    }

    protected View onCreateDialogView(Context context) {
        NumberPicker picker = new NumberPicker(context);
        picker.setOnValueChangedListener(this.mOnValueChangeListener);
        picker.setMinValue(this.mMinValue);
        picker.setMaxValue(this.mMaxValue);
        picker.setValue(this.mValue);
        this.changed = false;
        return picker;
    }

    protected void onPrepareDialogBuilder(AlertDialog.Builder builder) {
        super.onPrepareDialogBuilder(builder);
        builder.setPositiveButton(null, null);
    }

    protected NumberPickerPreferenceV7 getNumberPickerPreference() {
        return (NumberPickerPreferenceV7)this.getPreference();
    }
}

