/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.net.UdpSocket;
import com.serenegiant.utils.HandlerThreadHandler;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;

public class UdpBeacon {
    private static final String TAG = "UdpBeacon";
    private static final int BEACON_UDP_PORT = 9999;
    private static final byte BEACON_VERSION = 1;
    public static final int BEACON_SIZE = 23;
    private static final long DEFAULT_BEACON_SEND_INTERVALS_MS = 3000L;
    private static final int SO_TIMEOUT_MS = 2000;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final CopyOnWriteArraySet<UdpBeaconCallback> mCallbacks = new CopyOnWriteArraySet();
    private Handler mAsyncHandler;
    @NonNull
    private final UUID uuid;
    @NonNull
    private final byte[] beaconBytes;
    private final long mBeaconIntervalsMs;
    private final long mRcvMinIntervalsMs;
    private Thread mBeaconThread;
    private boolean mReceiveOnly;
    private volatile boolean mIsRunning;
    private volatile boolean mReleased;
    private final Runnable mBeaconTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(256);
            try {
                UdpSocket socket = new UdpSocket(9999);
                socket.setReceiveBufferSize(256);
                socket.setReuseAddress(true);
                socket.setSoTimeout(2000);
                Thread rcvThread = new Thread(new ReceiverTask(socket));
                rcvThread.start();
                long next_send = SystemClock.elapsedRealtime();
                try {
                    while (UdpBeacon.this.mIsRunning && !UdpBeacon.this.mReleased) {
                        if (!UdpBeacon.this.mReceiveOnly) {
                            long t = next_send - SystemClock.elapsedRealtime();
                            if (!UdpBeacon.this.mReceiveOnly && t <= 0L) {
                                next_send = SystemClock.elapsedRealtime() + UdpBeacon.this.mBeaconIntervalsMs;
                                UdpBeacon.this.sendBeacon(socket);
                                continue;
                            }
                            if (!UdpBeacon.this.waitWithoutException(this, t)) continue;
                        } else if (!UdpBeacon.this.waitWithoutException(this, 2000L)) continue;
                        break;
                    }
                }
                finally {
                    UdpBeacon.this.mIsRunning = false;
                    socket.release();
                    try {
                        rcvThread.interrupt();
                    }
                    catch (Exception e) {
                        Log.w((String)UdpBeacon.TAG, (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                UdpBeacon.this.callOnError(e);
            }
            UdpBeacon.this.mIsRunning = false;
            Object object = UdpBeacon.this.mSync;
            synchronized (object) {
                UdpBeacon.this.mBeaconThread = null;
            }
        }
    };

    public UdpBeacon(@Nullable UdpBeaconCallback callback) {
        this(callback, 9999, 3000L, false, 0L);
    }

    public UdpBeacon(@Nullable UdpBeaconCallback callback, long beacon_intervals_ms) {
        this(callback, 9999, beacon_intervals_ms, false, 0L);
    }

    public UdpBeacon(@Nullable UdpBeaconCallback callback, boolean receiveOnly) {
        this(callback, 9999, 3000L, false, 0L);
    }

    public UdpBeacon(@Nullable UdpBeaconCallback callback, boolean receiveOnly, long rcv_min_intervals_ms) {
        this(callback, 9999, 3000L, false, rcv_min_intervals_ms);
    }

    public UdpBeacon(@Nullable UdpBeaconCallback callback, long beacon_intervals_ms, boolean receiveOnly) {
        this(callback, 9999, beacon_intervals_ms, receiveOnly, 0L);
    }

    public UdpBeacon(@Nullable UdpBeaconCallback callback, long beacon_intervals_ms, boolean receiveOnly, long rcv_min_intervals_ms) {
        this(callback, 9999, beacon_intervals_ms, receiveOnly, rcv_min_intervals_ms);
    }

    public UdpBeacon(@Nullable UdpBeaconCallback callback, int port, long beacon_intervals_ms, boolean receiveOnly, long rcv_min_intervals_ms) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
        this.mAsyncHandler = HandlerThreadHandler.createHandler("UdpBeaconAsync");
        this.uuid = UUID.randomUUID();
        Beacon beacon = new Beacon(this.uuid, port);
        this.beaconBytes = beacon.asBytes();
        this.mBeaconIntervalsMs = beacon_intervals_ms;
        this.mReceiveOnly = receiveOnly;
        this.mRcvMinIntervalsMs = rcv_min_intervals_ms;
    }

    public void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.stop();
            this.mCallbacks.clear();
            Object object = this.mSync;
            synchronized (object) {
                if (this.mAsyncHandler != null) {
                    try {
                        this.mAsyncHandler.getLooper().quit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mAsyncHandler = null;
                }
            }
        }
    }

    public void addCallback(UdpBeaconCallback callback) {
        if (callback != null) {
            this.mCallbacks.add(callback);
        }
    }

    public void removeCallback(UdpBeaconCallback callback) {
        this.mCallbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.checkReleased();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mBeaconThread == null) {
                this.mIsRunning = true;
                this.mBeaconThread = new Thread(this.mBeaconTask, "UdpBeaconTask");
                this.mBeaconThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread;
        this.mIsRunning = false;
        Object object = this.mSync;
        synchronized (object) {
            thread = this.mBeaconThread;
            this.mBeaconThread = null;
            this.mSync.notifyAll();
        }
        if (thread != null && thread.isAlive()) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)e.getMessage());
            }
        }
    }

    public void shot() throws IllegalStateException {
        this.shot(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shot(int n) throws IllegalStateException {
        this.checkReleased();
        Object object = this.mSync;
        synchronized (object) {
            new Thread((Runnable)new BeaconShotTask(n), "UdpOneShotBeaconTask").start();
        }
    }

    public boolean isActive() {
        return this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveOnly(boolean receiveOnly) throws IllegalStateException {
        this.checkReleased();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mIsRunning) {
                throw new IllegalStateException("beacon is already active");
            }
            this.mReceiveOnly = receiveOnly;
        }
    }

    public boolean isReceiveOnly() {
        return this.mReceiveOnly;
    }

    private void checkReleased() throws IllegalStateException {
        if (this.mReleased) {
            throw new IllegalStateException("already released");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callOnError(final Exception e) {
        if (this.mReleased) {
            Log.w((String)TAG, (Throwable)e);
            return;
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (UdpBeaconCallback callback : UdpBeacon.this.mCallbacks) {
                            try {
                                callback.onError(e);
                            }
                            catch (Exception e2) {
                                UdpBeacon.this.mCallbacks.remove(callback);
                                Log.w((String)UdpBeacon.TAG, (Throwable)e2);
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitWithoutException(Object sync, long wait_time_ms) {
        boolean result = false;
        Object object = sync;
        synchronized (object) {
            try {
                sync.wait(wait_time_ms);
            }
            catch (InterruptedException e) {
                result = true;
            }
        }
        return result;
    }

    private void sendBeacon(@NonNull UdpSocket socket) {
        try {
            socket.broadcast(this.beaconBytes);
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    private class ReceiverTask
    implements Runnable {
        private final UdpSocket mUdpSocket;

        private ReceiverTask(UdpSocket udpSocket) {
            this.mUdpSocket = udpSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(256);
            UdpSocket socket = this.mUdpSocket;
            long next_rcv = SystemClock.elapsedRealtime();
            while (UdpBeacon.this.mIsRunning && !UdpBeacon.this.mReleased) {
                if (UdpBeacon.this.mRcvMinIntervalsMs > 0L) {
                    long t = next_rcv - SystemClock.elapsedRealtime();
                    if (t > 0L && UdpBeacon.this.waitWithoutException(this, t)) break;
                    next_rcv = SystemClock.elapsedRealtime() + UdpBeacon.this.mRcvMinIntervalsMs;
                }
                try {
                    buffer.clear();
                    int length = socket.receive(buffer);
                    if (!UdpBeacon.this.mIsRunning) break;
                    buffer.rewind();
                    if (length != 23 || buffer.get() != 83 || buffer.get() != 65 || buffer.get() != 75 || buffer.get() != 73 || buffer.get() != 1) continue;
                    final Beacon remoteBeacon = new Beacon(buffer);
                    if (UdpBeacon.this.uuid.equals(remoteBeacon.uuid)) continue;
                    final String remoteAddr = socket.remote();
                    final int remotePort = socket.remotePort();
                    Object object = UdpBeacon.this.mSync;
                    synchronized (object) {
                        if (UdpBeacon.this.mAsyncHandler == null) {
                            break;
                        }
                        UdpBeacon.this.mAsyncHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                for (UdpBeaconCallback callback : UdpBeacon.this.mCallbacks) {
                                    try {
                                        callback.onReceiveBeacon(remoteBeacon.uuid, remoteAddr, remotePort);
                                    }
                                    catch (Exception e) {
                                        UdpBeacon.this.mCallbacks.remove(callback);
                                        Log.w((String)UdpBeacon.TAG, (Throwable)e);
                                    }
                                }
                            }
                        });
                    }
                }
                catch (ClosedChannelException e) {
                    break;
                }
                catch (IOException e) {
                }
                catch (IllegalStateException e) {
                    break;
                }
                catch (Exception e) {
                    Log.w((String)UdpBeacon.TAG, (Throwable)e);
                    break;
                }
            }
        }
    }

    private final class BeaconShotTask
    implements Runnable {
        private final int shotNums;

        public BeaconShotTask(int shotNums) {
            this.shotNums = shotNums;
        }

        @Override
        public void run() {
            try {
                UdpSocket socket = new UdpSocket(9999);
                socket.setReuseAddress(true);
                socket.setSoTimeout(2000);
                try {
                    for (int i = 0; i < this.shotNums; ++i) {
                        if (UdpBeacon.this.mReleased) {
                        } else {
                            UdpBeacon.this.sendBeacon(socket);
                            if (!UdpBeacon.this.waitWithoutException(this, UdpBeacon.this.mBeaconIntervalsMs)) continue;
                        }
                        break;
                    }
                }
                finally {
                    socket.release();
                }
            }
            catch (SocketException e) {
                UdpBeacon.this.callOnError(e);
            }
        }
    }

    private static class Beacon {
        public static final String BEACON_IDENTITY = "SAKI";
        @NonNull
        private final UUID uuid;
        private final int listenPort;
        private final int extraBytes;
        @Nullable
        private final ByteBuffer extras;

        public Beacon(@NonNull ByteBuffer buffer) {
            this.uuid = new UUID(buffer.getLong(), buffer.getLong());
            int port = buffer.getShort();
            this.listenPort = port < 0 ? 0xFFFF & port : port;
            if (buffer.remaining() > 1) {
                this.extraBytes = buffer.get() & 0xFF;
                if (this.extraBytes > 0) {
                    this.extras = ByteBuffer.allocateDirect(this.extraBytes);
                    this.extras.put(buffer);
                    this.extras.flip();
                } else {
                    this.extras = null;
                }
            } else {
                this.extraBytes = 0;
                this.extras = null;
            }
        }

        public Beacon(@NonNull UUID uuid, int port) {
            this(uuid, port, 0);
        }

        public Beacon(@NonNull UUID uuid, int port, int extras) {
            this.uuid = uuid;
            this.listenPort = port;
            this.extraBytes = extras & 0xFF;
            this.extras = this.extraBytes > 0 ? ByteBuffer.allocateDirect(this.extraBytes) : null;
        }

        @NonNull
        public byte[] asBytes() {
            byte[] bytes = new byte[23 + (this.extraBytes > 0 ? this.extraBytes + 1 : 0)];
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.put(BEACON_IDENTITY.getBytes());
            buffer.put((byte)1);
            buffer.putLong(this.uuid.getMostSignificantBits());
            buffer.putLong(this.uuid.getLeastSignificantBits());
            buffer.putShort((short)this.listenPort);
            if (this.extraBytes > 0) {
                buffer.put((byte)this.extraBytes);
                this.extras.clear();
                this.extras.flip();
                buffer.put(this.extras);
            }
            buffer.flip();
            return bytes;
        }

        @Nullable
        public ByteBuffer extra() {
            return this.extras;
        }

        public void extra(@NonNull byte[] extra) {
            this.extra(ByteBuffer.wrap(extra));
        }

        public void extra(@NonNull ByteBuffer extra) {
            int n = extra.remaining();
            if (this.extraBytes > 0 && this.extraBytes <= n) {
                this.extras.clear();
                this.extras.put(extra);
                this.extras.flip();
            }
        }

        @NonNull
        public String toString() {
            return String.format(Locale.US, "Beacon(%s,port=%d,extra=%d)", this.uuid.toString(), this.listenPort, this.extraBytes);
        }
    }

    public static interface UdpBeaconCallback {
        public void onReceiveBeacon(UUID var1, String var2, int var3);

        public void onError(Exception var1);
    }
}

