/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.mediastore.LoaderDrawable;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.utils.ThreadPool;
import java.util.concurrent.FutureTask;

public abstract class ImageLoader
implements Runnable {
    @NonNull
    protected final LoaderDrawable mParent;
    @NonNull
    private final FutureTask<Bitmap> mTask;
    private final MediaInfo mInfo = new MediaInfo();
    private Bitmap mBitmap;

    public ImageLoader(@NonNull LoaderDrawable parent) {
        this.mParent = parent;
        this.mTask = new FutureTask<Object>(this, null);
    }

    public long id() {
        return this.mInfo.id;
    }

    public synchronized void startLoad(@NonNull MediaInfo info) {
        this.mInfo.set(info);
        this.mBitmap = null;
        ThreadPool.queueEvent(this.mTask);
    }

    public void cancelLoad() {
        this.mTask.cancel(true);
    }

    protected abstract Bitmap loadBitmap(@NonNull Context var1, @NonNull MediaInfo var2, int var3, int var4);

    @NonNull
    protected Bitmap loadDefaultBitmap(@NonNull Context context, @DrawableRes int drawableRes) {
        return BitmapHelper.fromDrawable(context, drawableRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MediaInfo info;
        ImageLoader imageLoader = this;
        synchronized (imageLoader) {
            info = new MediaInfo(this.mInfo);
        }
        if (!this.mTask.isCancelled()) {
            this.mBitmap = this.loadBitmap(this.mParent.getContext(), info, this.mParent.getIntrinsicWidth(), this.mParent.getIntrinsicHeight());
        }
        if (this.mTask.isCancelled() || !info.equals(this.mInfo) || this.mBitmap == null) {
            return;
        }
        this.mParent.scheduleSelf(this.mParent, 0L);
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }
}

