/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.media.AbstractAudioEncoder;
import com.serenegiant.media.AudioSampler;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IAudioSampler;
import com.serenegiant.media.IRecorder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class AudioSamplerEncoder
extends AbstractAudioEncoder {
    private final boolean mOwnSampler;
    @NonNull
    private final IAudioSampler mSampler;
    private int frame_count = 0;
    private final IAudioSampler.SoundSamplerCallback mSoundSamplerCallback = new IAudioSampler.SoundSamplerCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onData(@NonNull ByteBuffer buffer, int size, long presentationTimeUs) {
            Object object = AudioSamplerEncoder.this.mSync;
            synchronized (object) {
                if (!AudioSamplerEncoder.this.mIsCapturing || AudioSamplerEncoder.this.mRequestStop) {
                    return;
                }
            }
            if (size > 0) {
                AudioSamplerEncoder.this.frameAvailableSoon();
                AudioSamplerEncoder.this.encode(buffer, size, presentationTimeUs);
                AudioSamplerEncoder.this.frame_count++;
            }
        }

        @Override
        public void onError(Exception e) {
        }
    };
    private final Runnable mAudioTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = AudioSamplerEncoder.this.mSync;
                synchronized (object) {
                    if (!AudioSamplerEncoder.this.mIsCapturing || AudioSamplerEncoder.this.mRequestStop) {
                        break;
                    }
                    try {
                        AudioSamplerEncoder.this.mSync.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
            if (AudioSamplerEncoder.this.frame_count == 0) {
                ByteBuffer buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.nativeOrder());
                for (int i = 0; AudioSamplerEncoder.this.mIsCapturing && i < 5; ++i) {
                    buf.clear();
                    buf.position(1024);
                    buf.flip();
                    AudioSamplerEncoder.this.encode(buf, 1024, AudioSamplerEncoder.this.getInputPTSUs());
                    AudioSamplerEncoder.this.frameAvailableSoon();
                    2 var3_5 = this;
                    synchronized (var3_5) {
                        try {
                            this.wait(50L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        }
    };

    public AudioSamplerEncoder(@NonNull IRecorder recorder, @NonNull EncoderListener listener, int audio_source, @Nullable IAudioSampler sampler) {
        super(recorder, listener, audio_source, sampler != null ? sampler.getChannels() : 1, sampler != null ? sampler.getSamplingFrequency() : 44100, 64000);
        if (sampler == null) {
            if (audio_source < 0 || audio_source > 7) {
                throw new IllegalArgumentException("invalid audio source:" + audio_source);
            }
            sampler = new AudioSampler(audio_source, 1, 44100, 1024, 25);
            this.mOwnSampler = true;
        } else {
            this.mOwnSampler = false;
        }
        this.mSampler = sampler;
    }

    @Override
    public void start() {
        super.start();
        this.mSampler.addCallback(this.mSoundSamplerCallback);
        if (this.mOwnSampler) {
            this.mSampler.start();
        }
        new Thread(this.mAudioTask, "AudioTask").start();
    }

    @Override
    public void stop() {
        this.mSampler.removeCallback(this.mSoundSamplerCallback);
        if (this.mOwnSampler) {
            this.mSampler.stop();
        }
        super.stop();
    }

    @Override
    public void release() {
        if (this.mOwnSampler) {
            this.mSampler.release();
        }
        super.release();
    }
}

