/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.io;

import androidx.annotation.NonNull;
import com.serenegiant.io.IReadable;
import com.serenegiant.io.IWritable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class ByteChannelWrapper
implements IReadable,
IWritable {
    @NonNull
    private final ByteChannel mChannel;

    public ByteChannelWrapper(@NonNull ByteChannel channel) {
        this.mChannel = channel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.mChannel.read(dst);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        return this.mChannel.read(buf);
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        this.mChannel.write(src);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(b, off, len);
        this.mChannel.write(buf);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.mChannel.close();
    }
}

