/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.graphics;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.exifinterface.media.ExifInterface;
import com.serenegiant.utils.BitsHelper;
import com.serenegiant.utils.UriHelper;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;

public final class BitmapHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = BitmapHelper.class.getSimpleName();
    private static final int OPTIONS_SCALE_UP = 1;
    public static final int OPTIONS_RECYCLE_INPUT = 2;
    private static final float[] COLOR_MATRIX_INVERT_ALPHA = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 255.0f};

    private BitmapHelper() {
    }

    public static byte[] BitmapToByteArray(@NonNull Bitmap bitmap) {
        return BitmapHelper.BitmapToByteArray(bitmap, Bitmap.CompressFormat.PNG, 100);
    }

    public static byte[] BitmapToByteArray(@NonNull Bitmap bitmap, Bitmap.CompressFormat format, int quality) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] bytes = null;
        if (bitmap.compress(format, quality, (OutputStream)byteArrayOutputStream)) {
            bytes = byteArrayOutputStream.toByteArray();
        }
        return bytes;
    }

    @Nullable
    public static Bitmap asBitmap(@Nullable byte[] bytes) {
        Bitmap bitmap = null;
        if (bytes != null) {
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(@Nullable byte[] bytes, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (bytes != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmapStrictSize(@Nullable byte[] bytes, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (bytes != null) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length, (BitmapFactory.Options)options);
            if (inSampleSize != calcedSampleSize || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleBitmap(bitmap, requestWidth, requestHeight);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(String filePath) {
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            bitmap = BitmapFactory.decodeFile((String)filePath);
            int orientation = BitmapHelper.getOrientation(filePath);
            if (orientation != 0) {
                Bitmap newBitmap = BitmapHelper.rotateBitmap(bitmap, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(String filePath, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int orientation = BitmapHelper.getOrientation(filePath);
            if (orientation != 0) {
                Bitmap newBitmap = BitmapHelper.rotateBitmap(bitmap, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmapStrictSize(String filePath, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (!TextUtils.isEmpty((CharSequence)filePath)) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            int orientation = BitmapHelper.getOrientation(filePath);
            if (inSampleSize != calcedSampleSize || orientation != 0 || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleRotateBitmap(bitmap, requestWidth, requestHeight, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(FileDescriptor fd) {
        Bitmap bitmap = null;
        if (fd != null && fd.valid()) {
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd);
            int orientation = BitmapHelper.getOrientation(fd);
            if (orientation != 0) {
                Bitmap newBitmap = BitmapHelper.rotateBitmap(bitmap, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(FileDescriptor fd, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (fd != null && fd.valid()) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            int orientation = BitmapHelper.getOrientation(fd);
            if (orientation != 0) {
                Bitmap newBitmap = BitmapHelper.rotateBitmap(bitmap, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    public static Bitmap asBitmapStrictSize(FileDescriptor fd, int requestWidth, int requestHeight) {
        Bitmap bitmap = null;
        if (fd != null && fd.valid()) {
            int inSampleSize;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            int calcedSampleSize = BitmapHelper.calcSampleSize(options, requestWidth, requestHeight);
            options.inSampleSize = inSampleSize = 1 << BitsHelper.MSB(calcedSampleSize);
            options.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fd, null, (BitmapFactory.Options)options);
            int orientation = BitmapHelper.getOrientation(fd);
            if (inSampleSize != calcedSampleSize || orientation != 0 || bitmap.getWidth() != requestWidth || bitmap.getHeight() != requestHeight) {
                Bitmap newBitmap = BitmapHelper.scaleRotateBitmap(bitmap, requestWidth, requestHeight, orientation);
                bitmap.recycle();
                bitmap = newBitmap;
            }
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(@NonNull ContentResolver cr, long id2) throws IOException {
        Bitmap result = null;
        Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2);
        ParcelFileDescriptor pfd = cr.openFileDescriptor(uri, "r");
        if (pfd != null) {
            result = BitmapHelper.asBitmap(pfd.getFileDescriptor());
        }
        return result;
    }

    @Nullable
    public static Bitmap asBitmap(@NonNull ContentResolver cr, long id2, int requestWidth, int requestHeight) throws IOException {
        Bitmap result = null;
        Uri uri = ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2);
        ParcelFileDescriptor pfd = cr.openFileDescriptor(uri, "r");
        if (pfd != null) {
            result = BitmapHelper.asBitmap(pfd.getFileDescriptor(), requestWidth, requestHeight);
        }
        return result;
    }

    @Nullable
    public static Bitmap asBitmap(@NonNull ContentResolver cr, Uri uri) throws IOException {
        ParcelFileDescriptor pfd;
        Bitmap bitmap = null;
        if (uri != null && (pfd = cr.openFileDescriptor(uri, "r")) != null) {
            bitmap = BitmapHelper.asBitmap(pfd.getFileDescriptor());
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmap(@NonNull ContentResolver cr, Uri uri, int requestWidth, int requestHeight) throws IOException {
        ParcelFileDescriptor pfd;
        Bitmap bitmap = null;
        if (uri != null && (pfd = cr.openFileDescriptor(uri, "r")) != null) {
            bitmap = BitmapHelper.asBitmap(pfd.getFileDescriptor(), requestWidth, requestHeight);
        }
        return bitmap;
    }

    @Nullable
    public static Bitmap asBitmapStrictSize(@NonNull ContentResolver cr, Uri uri, int requestWidth, int requestHeight) throws IOException {
        ParcelFileDescriptor pfd;
        Bitmap bitmap = null;
        if (uri != null && (pfd = cr.openFileDescriptor(uri, "r")) != null) {
            bitmap = BitmapHelper.asBitmapStrictSize(pfd.getFileDescriptor(), requestWidth, requestHeight);
        }
        return bitmap;
    }

    @NonNull
    public static Bitmap fromDrawable(@NonNull Drawable drawable2, int width, int height) {
        Drawable _drawable = drawable2;
        if (Build.VERSION.SDK_INT < 21) {
            _drawable = DrawableCompat.wrap((Drawable)_drawable).mutate();
        }
        _drawable.setBounds(0, 0, width, height);
        Bitmap result = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(result);
        _drawable.draw(canvas);
        return result;
    }

    @NonNull
    public static Bitmap fromDrawable(@NonNull Context context, @DrawableRes int drawableRes) {
        Bitmap result = null;
        if (drawableRes != 0) {
            Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)drawableRes);
            if (drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0) {
                drawable2.setBounds(0, 0, 72, 72);
            }
            result = BitmapHelper.fromDrawable(drawable2, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        }
        if (result == null) {
            throw new IllegalArgumentException("failed to load from resource " + drawableRes);
        }
        return result;
    }

    @Nullable
    public static Bitmap scaleBitmap(@Nullable Bitmap bitmap, int requestWidth, int requestHeight) {
        Bitmap newBitmap = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale((float)width / (float)requestWidth, (float)height / (float)requestHeight);
            newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newBitmap;
    }

    @Nullable
    public static Bitmap rotateBitmap(@Nullable Bitmap bitmap, int rotation) {
        Bitmap newBitmap = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotation);
            newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newBitmap;
    }

    @Nullable
    public static Bitmap scaleRotateBitmap(@Nullable Bitmap bitmap, int requestWidth, int requestHeight, int rotation) {
        Bitmap newBitmap = null;
        if (bitmap != null) {
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            Matrix matrix = new Matrix();
            matrix.postScale((float)width / (float)requestWidth, (float)height / (float)requestHeight);
            matrix.postRotate((float)rotation);
            newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        }
        return newBitmap;
    }

    @Nullable
    public static Bitmap extractBitmap(@Nullable Bitmap source, int width, int height) {
        Bitmap newBitmap = null;
        if (source != null) {
            float scale = source.getWidth() < source.getHeight() ? (float)width / (float)source.getWidth() : (float)height / (float)source.getHeight();
            Matrix matrix = new Matrix();
            matrix.setScale(scale, scale);
            newBitmap = BitmapHelper.transform(matrix, source, width, height, 3);
        }
        return newBitmap;
    }

    @NonNull
    private static Bitmap transform(Matrix scaler, @NonNull Bitmap source, int targetWidth, int targetHeight, int options) {
        int dy1;
        int dx1;
        Bitmap b2;
        float viewAspect;
        float bitmapHeightF;
        boolean scaleUp = (options & 1) != 0;
        boolean recycle = (options & 2) != 0;
        int deltaX = source.getWidth() - targetWidth;
        int deltaY = source.getHeight() - targetHeight;
        if (!(scaleUp || deltaX >= 0 && deltaY >= 0)) {
            Bitmap b22 = Bitmap.createBitmap((int)targetWidth, (int)targetHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b22);
            int deltaXHalf = Math.max(0, deltaX / 2);
            int deltaYHalf = Math.max(0, deltaY / 2);
            Rect src = new Rect(deltaXHalf, deltaYHalf, deltaXHalf + Math.min(targetWidth, source.getWidth()), deltaYHalf + Math.min(targetHeight, source.getHeight()));
            int dstX = (targetWidth - src.width()) / 2;
            int dstY = (targetHeight - src.height()) / 2;
            Rect dst = new Rect(dstX, dstY, targetWidth - dstX, targetHeight - dstY);
            c.drawBitmap(source, src, dst, null);
            if (recycle) {
                source.recycle();
            }
            c.setBitmap(null);
            return b22;
        }
        float bitmapWidthF = source.getWidth();
        float bitmapAspect = bitmapWidthF / (bitmapHeightF = (float)source.getHeight());
        float scale = bitmapAspect > (viewAspect = (float)targetWidth / (float)targetHeight) ? (float)targetHeight / bitmapHeightF : (float)targetWidth / bitmapWidthF;
        if (scale < 0.9f || scale > 1.0f) {
            scaler.setScale(scale, scale);
        } else {
            scaler = null;
        }
        Bitmap b1 = scaler != null ? Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)scaler, (boolean)true) : source;
        if (recycle && b1 != source) {
            source.recycle();
        }
        if ((b2 = Bitmap.createBitmap((Bitmap)b1, (int)((dx1 = Math.max(0, b1.getWidth() - targetWidth)) / 2), (int)((dy1 = Math.max(0, b1.getHeight() - targetHeight)) / 2), (int)targetWidth, (int)targetHeight)) != b1 && (recycle || b1 != source)) {
            b1.recycle();
        }
        return b2;
    }

    public static int calcSampleSize(@NonNull BitmapFactory.Options options, int requestWidth, int requestHeight) {
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        int reqWidth = requestWidth;
        int reqHeight = requestHeight;
        if (requestWidth <= 0) {
            reqWidth = requestHeight > 0 ? (int)((float)(imageWidth * requestHeight) / (float)imageHeight) : imageWidth;
        }
        if (requestHeight <= 0) {
            reqHeight = requestWidth > 0 ? (int)((float)(imageHeight * requestWidth) / (float)imageHeight) : imageHeight;
        }
        int inSampleSize = 1;
        if (imageHeight > reqHeight || imageWidth > reqWidth) {
            inSampleSize = imageWidth > imageHeight ? Math.round((float)imageHeight / (float)reqHeight) : Math.round((float)imageWidth / (float)reqWidth);
        }
        return inSampleSize;
    }

    @NonNull
    public static Bitmap copyBitmap(@NonNull Bitmap src, Bitmap dest) {
        if (dest == null) {
            dest = Bitmap.createBitmap((Bitmap)src);
        } else if (!src.equals(dest)) {
            Canvas canvas = new Canvas(dest);
            canvas.setBitmap(src);
        }
        return dest;
    }

    public static Bitmap applyMirror(@NonNull Bitmap bitmap, int mirror) {
        int _mirror = mirror % 4;
        if (_mirror == 0) {
            return bitmap;
        }
        Matrix m = new Matrix();
        switch (_mirror) {
            case 1: {
                m.preScale(-1.0f, 1.0f);
                break;
            }
            case 2: {
                m.preScale(1.0f, -1.0f);
                break;
            }
            case 3: {
                m.preScale(-1.0f, -1.0f);
                break;
            }
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
    }

    @NonNull
    public static Bitmap makeCheckBitmap() {
        Bitmap bm = Bitmap.createBitmap((int)40, (int)40, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bm);
        c.drawColor(-1);
        Paint p = new Paint();
        p.setColor(-3355444);
        c.drawRect(0.0f, 0.0f, 20.0f, 20.0f, p);
        c.drawRect(20.0f, 20.0f, 40.0f, 40.0f, p);
        return bm;
    }

    @NonNull
    public static Bitmap makeCheckBitmap(int width, int height, int step_width, int step_height, @NonNull Bitmap.Config config) {
        Bitmap bm = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        Canvas c = new Canvas(bm);
        c.drawColor(-1);
        Paint p = new Paint();
        p.setColor(-3355444);
        for (int x = 0; x < width; x += step_width * 2) {
            for (int y = 0; y < height; y += step_height * 2) {
                c.drawRect((float)x, (float)y, (float)step_width, (float)step_height, p);
                c.drawRect((float)(x + step_width), (float)(y + step_height), (float)step_width, (float)step_height, p);
            }
        }
        return bm;
    }

    @Nullable
    public static Bitmap genMaskImage(@IntRange(from=0L, to=0L) int type, int width, int height, @IntRange(from=0L, to=100L) int size, int color, @IntRange(from=0L, to=255L) int alpha0, @IntRange(from=0L, to=255L) int alphaMax) {
        return BitmapHelper.getMaskImage0(width, height, size, color, alpha0, alphaMax);
    }

    @Nullable
    public static Bitmap getMaskImage0(int width, int height, @IntRange(from=0L, to=100L) int size, int color, @IntRange(from=0L, to=255L) int alpha0, @IntRange(from=0L, to=255L) int alphaMax) {
        float r = (float)(Math.min(width, height) * size) / 200.0f;
        int cx = width / 2;
        int cy = height / 2;
        Paint paint = new Paint();
        paint.setDither(true);
        int rr = Color.red((int)color);
        int bb = Color.blue((int)color);
        int gg = Color.green((int)color);
        RadialGradient gradient = new RadialGradient((float)cx, (float)cy, r, new int[]{Color.argb((int)alphaMax, (int)rr, (int)gg, (int)bb), Color.argb((int)alphaMax, (int)rr, (int)gg, (int)bb), Color.argb((int)((int)((float)alphaMax * 0.6f)), (int)rr, (int)gg, (int)bb), Color.argb((int)alpha0, (int)rr, (int)gg, (int)bb)}, new float[]{0.0f, 0.6f, 0.8f, 1.0f}, Shader.TileMode.CLAMP);
        paint.setShader((Shader)gradient);
        Bitmap offscreen = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(offscreen);
        canvas.drawCircle((float)cx, (float)cy, r, paint);
        return offscreen;
    }

    public static Bitmap invertAlpha(@NonNull Bitmap src) {
        Bitmap offscreen = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)src.getConfig());
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(COLOR_MATRIX_INVERT_ALPHA));
        Canvas canvas = new Canvas(offscreen);
        canvas.drawBitmap(src, 0.0f, 0.0f, paint);
        return offscreen;
    }

    public static int getOrientation(String path) {
        ExifInterface exif;
        try {
            exif = new ExifInterface(path);
        }
        catch (Exception e) {
            return 0;
        }
        return BitmapHelper.getOrientation(exif);
    }

    public static int getOrientation(FileDescriptor fd) {
        ExifInterface exif;
        try {
            exif = new ExifInterface(fd);
        }
        catch (Exception e) {
            return 0;
        }
        return BitmapHelper.getOrientation(exif);
    }

    private static int getOrientation(@NonNull ExifInterface exif) {
        int result;
        int rotation = exif.getAttributeInt("Orientation", 0);
        switch (rotation) {
            case 6: {
                result = 90;
                break;
            }
            case 3: {
                result = 180;
                break;
            }
            case 8: {
                result = 270;
                break;
            }
            default: {
                result = 0;
            }
        }
        return result;
    }

    public static int getOrientation(@NonNull ContentResolver cr, long id2) {
        return BitmapHelper.getOrientation(cr, ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2));
    }

    public static int getOrientation(@NonNull ContentResolver cr, @NonNull Uri imageUri) {
        ExifInterface exif;
        try {
            exif = new ExifInterface(UriHelper.getAbsolutePath(cr, imageUri));
        }
        catch (Exception e) {
            return BitmapHelper.getOrientationFromMediaStore(cr, imageUri);
        }
        int rotation = exif.getAttributeInt("Orientation", 0);
        if (rotation == 0) {
            return BitmapHelper.getOrientationFromMediaStore(cr, imageUri);
        }
        return BitmapHelper.getOrientation(exif);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOrientationFromMediaStore(@NonNull ContentResolver cr, @NonNull Uri imageUri) {
        String[] columns = new String[]{"_data", "orientation"};
        int result = 0;
        try (Cursor cursor = cr.query(imageUri, columns, null, null, null);){
            if (cursor != null) {
                cursor.moveToFirst();
                int orientationColumnIndex = cursor.getColumnIndex(columns[1]);
                result = cursor.getInt(orientationColumnIndex);
            }
        }
        return result;
    }

    public static int getPixelBytes(@NonNull Bitmap.Config config) {
        switch (config) {
            case ALPHA_8: {
                return 1;
            }
            case RGB_565: 
            case ARGB_4444: {
                return 2;
            }
            case ARGB_8888: {
                return 4;
            }
            case RGBA_F16: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unexpected config type" + config);
    }

    private static int sat(int v, int min, int max) {
        return v < min ? min : Math.min(v, max);
    }

    private static int sat(float v, float min, float max) {
        return (int)(v < min ? min : Math.min(v, max));
    }
}

