/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.opengl.Matrix;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.egl.EglTask;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.ISurface;
import com.serenegiant.glutils.AbstractDistributeTask;
import com.serenegiant.glutils.IRendererHolder;
import com.serenegiant.math.Fraction;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.MessageTask;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class AbstractRendererHolder
implements IRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractRendererHolder.class.getSimpleName();
    private static final String RENDERER_THREAD_NAME = "RendererHolder";
    private static final String CAPTURE_THREAD_NAME = "CaptureTask";
    @NonNull
    private final Object mSync = new Object();
    @Nullable
    private final IRendererHolder.RenderHolderCallback mCallback;
    private volatile boolean isRunning;
    @Nullable
    private OutputStream mCaptureStream;
    private int mCaptureFormat;
    @IntRange(from=1L, to=99L)
    private int mCaptureCompression = 80;
    private IRendererHolder.OnCapturedListener mOnCapturedListener;
    @NonNull
    protected final BaseRendererTask mRendererTask;
    private final Runnable mCaptureTask = new Runnable(){
        private GLContext mContext;
        private ISurface captureSurface;
        private GLDrawer2D drawer;
        @Size(min=16L)
        @NonNull
        private final float[] mMvpMatrix = new float[16];

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AbstractRendererHolder.this.mSync;
            synchronized (object) {
                while (!AbstractRendererHolder.this.isRunning && !AbstractRendererHolder.this.mRendererTask.isFinished()) {
                    try {
                        AbstractRendererHolder.this.mSync.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            if (AbstractRendererHolder.this.isRunning) {
                this.init();
                try {
                    if (this.mContext.isOES3Supported()) {
                        this.captureLoopGLES3();
                    } else {
                        this.captureLoopGLES2();
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                finally {
                    this.release();
                }
            }
        }

        private final void init() {
            this.mContext = new GLContext(AbstractRendererHolder.this.mRendererTask.getGLContext());
            this.mContext.initialize();
            this.captureSurface = this.mContext.getEgl().createOffscreen(AbstractRendererHolder.this.mRendererTask.width(), AbstractRendererHolder.this.mRendererTask.height());
            Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
            this.drawer = GLDrawer2D.create(this.mContext.isOES3Supported(), true);
            AbstractRendererHolder.this.setupCaptureDrawer(this.drawer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureLoopGLES2() {
            Object object;
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            int captureCompression = 80;
            while (AbstractRendererHolder.this.isRunning) {
                object = AbstractRendererHolder.this.mSync;
                synchronized (object) {
                    if (AbstractRendererHolder.this.mCaptureStream == null) {
                        try {
                            AbstractRendererHolder.this.mSync.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (AbstractRendererHolder.this.mCaptureStream != null) {
                            captureCompression = AbstractRendererHolder.this.mCaptureCompression;
                            if (captureCompression <= 0 || captureCompression >= 100) {
                                captureCompression = 90;
                            }
                        } else {
                            continue;
                        }
                    }
                    boolean success = false;
                    if (buf == null || width != AbstractRendererHolder.this.mRendererTask.width() || height != AbstractRendererHolder.this.mRendererTask.height()) {
                        width = AbstractRendererHolder.this.mRendererTask.width();
                        height = AbstractRendererHolder.this.mRendererTask.height();
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.mContext.getEgl().createOffscreen(width, height);
                    }
                    if (AbstractRendererHolder.this.isRunning && width > 0 && height > 0) {
                        GLUtils.setMirror(this.mMvpMatrix, AbstractRendererHolder.this.mRendererTask.getMirror());
                        this.mMvpMatrix[5] = this.mMvpMatrix[5] * -1.0f;
                        this.drawer.setMvpMatrix(this.mMvpMatrix, 0);
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(33984, AbstractRendererHolder.this.mRendererTask.mTexId, AbstractRendererHolder.this.mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = AbstractRendererHolder.getCaptureFormat(AbstractRendererHolder.this.mCaptureFormat);
                        try {
                            try {
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, captureCompression, AbstractRendererHolder.this.mCaptureStream);
                                bmp.recycle();
                                AbstractRendererHolder.this.mCaptureStream.flush();
                                success = true;
                            }
                            finally {
                                AbstractRendererHolder.this.mCaptureStream.close();
                            }
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    } else if (AbstractRendererHolder.this.isRunning) {
                        Log.w((String)TAG, (String)"#captureLoopGLES3:unexpectedly width/height is zero");
                    }
                    AbstractRendererHolder.this.mCaptureStream = null;
                    if (AbstractRendererHolder.this.mOnCapturedListener != null) {
                        try {
                            AbstractRendererHolder.this.mOnCapturedListener.onCaptured(AbstractRendererHolder.this, success);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AbstractRendererHolder.this.mOnCapturedListener = null;
                    AbstractRendererHolder.this.mSync.notifyAll();
                }
            }
            object = AbstractRendererHolder.this.mSync;
            synchronized (object) {
                AbstractRendererHolder.this.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=18)
        private final void captureLoopGLES3() {
            Object object;
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            int captureCompression = 90;
            while (AbstractRendererHolder.this.isRunning) {
                object = AbstractRendererHolder.this.mSync;
                synchronized (object) {
                    if (AbstractRendererHolder.this.mCaptureStream == null) {
                        try {
                            AbstractRendererHolder.this.mSync.wait();
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                        if (AbstractRendererHolder.this.mCaptureStream != null) {
                            captureCompression = AbstractRendererHolder.this.mCaptureCompression;
                            if (captureCompression <= 0 || captureCompression >= 100) {
                                captureCompression = 90;
                            }
                        } else {
                            continue;
                        }
                    }
                    boolean success = false;
                    if (buf == null || width != AbstractRendererHolder.this.mRendererTask.width() || height != AbstractRendererHolder.this.mRendererTask.height()) {
                        width = AbstractRendererHolder.this.mRendererTask.width();
                        height = AbstractRendererHolder.this.mRendererTask.height();
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.mContext.getEgl().createOffscreen(width, height);
                    }
                    if (AbstractRendererHolder.this.isRunning && width > 0 && height > 0) {
                        GLUtils.setMirror(this.mMvpMatrix, AbstractRendererHolder.this.mRendererTask.getMirror());
                        this.mMvpMatrix[5] = this.mMvpMatrix[5] * -1.0f;
                        this.drawer.setMvpMatrix(this.mMvpMatrix, 0);
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(33984, AbstractRendererHolder.this.mRendererTask.mTexId, AbstractRendererHolder.this.mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES30.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = AbstractRendererHolder.getCaptureFormat(AbstractRendererHolder.this.mCaptureFormat);
                        try {
                            try {
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, captureCompression, AbstractRendererHolder.this.mCaptureStream);
                                bmp.recycle();
                                AbstractRendererHolder.this.mCaptureStream.flush();
                                success = true;
                            }
                            finally {
                                AbstractRendererHolder.this.mCaptureStream.close();
                            }
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    } else if (AbstractRendererHolder.this.isRunning) {
                        Log.w((String)TAG, (String)"#captureLoopGLES3:unexpectedly width/height is zero");
                    }
                    AbstractRendererHolder.this.mCaptureStream = null;
                    if (AbstractRendererHolder.this.mOnCapturedListener != null) {
                        try {
                            AbstractRendererHolder.this.mOnCapturedListener.onCaptured(AbstractRendererHolder.this, success);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AbstractRendererHolder.this.mOnCapturedListener = null;
                    AbstractRendererHolder.this.mSync.notifyAll();
                }
            }
            object = AbstractRendererHolder.this.mSync;
            synchronized (object) {
                AbstractRendererHolder.this.mSync.notifyAll();
            }
        }

        private final void release() {
            if (this.captureSurface != null) {
                this.captureSurface.makeCurrent();
                this.captureSurface.release();
                this.captureSurface = null;
            }
            if (this.drawer != null) {
                this.drawer.release();
                this.drawer = null;
            }
            if (this.mContext != null) {
                this.mContext.release();
                this.mContext = null;
            }
        }
    };

    protected AbstractRendererHolder(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable IRendererHolder.RenderHolderCallback callback) {
        this.mCallback = callback;
        this.mRendererTask = this.createRendererTask(width, height, maxClientVersion, sharedContext, flags);
        this.mRendererTask.start(RENDERER_THREAD_NAME);
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
        this.startCaptureTask();
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.mRendererTask.release();
        Object object = this.mSync;
        synchronized (object) {
            this.isRunning = false;
            this.mSync.notifyAll();
        }
    }

    @Override
    @Nullable
    public EGLBase.IContext<?> getContext() {
        return this.mRendererTask.getContext();
    }

    public int getGlVersion() {
        return this.mRendererTask.getGlVersion();
    }

    @Override
    public Surface getSurface() {
        return this.mRendererTask.getSurface();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mRendererTask.getSurfaceTexture();
    }

    @Override
    public void reset() {
        this.mRendererTask.checkMasterSurface();
    }

    @Override
    public void resize(int width, int height) throws IllegalStateException {
        this.mRendererTask.resize(width, height);
    }

    @Override
    public void setMirror(int mirror) {
        this.mRendererTask.setMirror(mirror % 4);
    }

    @Override
    public int getMirror() {
        return this.mRendererTask.getMirror();
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable) throws IllegalStateException, IllegalArgumentException {
        this.mRendererTask.addSurface(id2, surface);
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable, @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        this.mRendererTask.addSurface(id2, surface, maxFps);
    }

    @Override
    public void removeSurface(int id2) {
        this.mRendererTask.removeSurface(id2);
    }

    @Override
    public void removeSurfaceAll() {
        this.mRendererTask.removeSurfaceAll();
    }

    @Override
    public void clearSurface(int id2, int color) {
        this.mRendererTask.clearSurface(id2, color);
    }

    @Override
    public void clearSurfaceAll(int color) {
        this.mRendererTask.clearSurfaceAll(color);
    }

    @Override
    public void setMvpMatrix(int id2, int offset, @NonNull @Size(min=16L) float[] matrix) {
        this.mRendererTask.setMvpMatrix(id2, offset, matrix);
    }

    @Override
    public boolean isEnabled(int id2) {
        return this.mRendererTask.isEnabled(id2);
    }

    @Override
    public void setEnabled(int id2, boolean enable) {
        this.mRendererTask.setEnabled(id2, enable);
    }

    @Override
    public void requestFrame() {
        this.mRendererTask.requestFrame(true, this.mRendererTask.mTexId, this.mRendererTask.mTexMatrix);
    }

    @Override
    public int getCount() {
        return this.mRendererTask.getCount();
    }

    @Override
    public void captureStill(@NonNull String path, @Nullable IRendererHolder.OnCapturedListener listener) throws FileNotFoundException, IllegalStateException {
        this.captureStill(new BufferedOutputStream(new FileOutputStream(path)), AbstractRendererHolder.getCaptureFormat(path), 80, listener);
    }

    @Override
    public void captureStill(@NonNull String path, @IntRange(from=1L, to=99L) int captureCompression, @Nullable IRendererHolder.OnCapturedListener listener) throws FileNotFoundException, IllegalStateException {
        this.captureStill(new BufferedOutputStream(new FileOutputStream(path)), AbstractRendererHolder.getCaptureFormat(path), captureCompression, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureStill(@NonNull OutputStream out, int captureFormat, @IntRange(from=1L, to=99L) int captureCompression, @Nullable IRendererHolder.OnCapturedListener listener) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning) {
                throw new IllegalStateException("already released?");
            }
            if (this.mCaptureStream != null) {
                throw new IllegalStateException("already run still capturing now");
            }
            this.mCaptureStream = out;
            this.mCaptureFormat = captureFormat;
            this.mCaptureCompression = captureCompression;
            this.mOnCapturedListener = listener;
            this.mSync.notifyAll();
        }
    }

    @Override
    public void queueEvent(@NonNull Runnable task) {
        this.mRendererTask.queueEvent(task);
    }

    private static int getCaptureFormat(@NonNull String path) throws IllegalArgumentException {
        int result;
        String _path = path.toLowerCase();
        if (path.endsWith(".jpg") || path.endsWith(".jpeg")) {
            result = 0;
        } else if (path.endsWith(".png")) {
            result = 1;
        } else if (path.endsWith(".webp")) {
            result = 2;
        } else {
            throw new IllegalArgumentException("unknown compress format(extension)");
        }
        return result;
    }

    private static Bitmap.CompressFormat getCaptureFormat(int captureFormat) {
        Bitmap.CompressFormat result;
        switch (captureFormat) {
            case 1: {
                result = Bitmap.CompressFormat.PNG;
                break;
            }
            case 2: {
                result = Bitmap.CompressFormat.WEBP;
                break;
            }
            default: {
                result = Bitmap.CompressFormat.JPEG;
            }
        }
        return result;
    }

    @NonNull
    protected abstract BaseRendererTask createRendererTask(int var1, int var2, int var3, @Nullable EGLBase.IContext<?> var4, int var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startCaptureTask() {
        new Thread(this.mCaptureTask, CAPTURE_THREAD_NAME).start();
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCapture() {
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notify();
        }
    }

    protected void callOnCreate(Surface surface) {
        if (this.mCallback != null) {
            try {
                this.mCallback.onCreate(surface);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void callOnFrameAvailable() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onFrameAvailable();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void callOnDestroy() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onDestroy();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void setupCaptureDrawer(GLDrawer2D drawer) {
    }

    protected static class BaseRendererTask
    extends AbstractDistributeTask
    implements SurfaceTexture.OnFrameAvailableListener {
        @NonNull
        private final AbstractRendererHolder mParent;
        @NonNull
        private final EglTask mEglTask;
        @Size(min=16L)
        @NonNull
        final float[] mTexMatrix = new float[16];
        private int mTexId;
        private SurfaceTexture mInputTexture;
        private Surface mInputSurface;

        public BaseRendererTask(@NonNull AbstractRendererHolder parent, int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable GLDrawer2D.DrawerFactory factory) {
            super(width, height, factory);
            this.mParent = parent;
            this.mEglTask = new EglTask(maxClientVersion, sharedContext, flags){

                @Override
                protected void onStart() {
                    this.handleOnStart();
                }

                @Override
                protected void onStop() {
                    this.handleOnStop();
                }

                @Override
                protected Object processRequest(int request, int arg1, int arg2, Object obj) throws MessageTask.TaskBreak {
                    return this.handleRequest(request, arg1, arg2, obj);
                }
            };
        }

        @Override
        public void release() {
            this.mEglTask.release();
            super.release();
        }

        @Override
        public void start(String tag) {
            new Thread((Runnable)this.mEglTask, tag).start();
        }

        @Override
        public boolean waitReady() {
            return this.mEglTask.waitReady();
        }

        @Override
        public boolean isRunning() {
            return this.mEglTask.isRunning();
        }

        @Override
        public boolean isFinished() {
            return this.mEglTask.isFinished();
        }

        @Override
        public boolean offer(int request) {
            return this.mEglTask.offer(request);
        }

        @Override
        public boolean offer(int request, Object obj) {
            return this.mEglTask.offer(request, obj);
        }

        @Override
        public boolean offer(int request, int arg1) {
            return this.mEglTask.offer(request, arg1);
        }

        @Override
        public boolean offer(int request, int arg1, int arg2) {
            return this.mEglTask.offer(request, arg1, arg2);
        }

        @Override
        public boolean offer(int request, int arg1, int arg2, Object obj) {
            return this.mEglTask.offer(request, arg1, arg2, obj);
        }

        @Override
        public void removeRequest(int request) {
            this.mEglTask.removeRequest(request);
        }

        @Override
        @NonNull
        public EGLBase getEgl() {
            return this.mEglTask.getEgl();
        }

        @Override
        @NonNull
        public GLContext getGLContext() {
            return this.mEglTask.getGLContext();
        }

        @Override
        @NonNull
        public EGLBase.IContext<?> getContext() {
            return this.mEglTask.getContext();
        }

        @Override
        public int getGlVersion() {
            return this.mEglTask.getGlVersion();
        }

        @Override
        public void makeCurrent() {
            this.mEglTask.makeCurrent();
        }

        @Override
        public boolean isGLES3() {
            return this.mEglTask.isGLES3();
        }

        @Override
        public boolean isOES3Supported() {
            return this.mEglTask.isOES3Supported();
        }

        @Override
        public boolean isMasterSurfaceValid() {
            return this.mInputSurface != null && this.mInputSurface.isValid();
        }

        public int getTexId() {
            return this.mTexId;
        }

        public float[] getTexMatrix() {
            return this.mTexMatrix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyParent(boolean isRunning) {
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = isRunning;
                this.mParent.mSync.notifyAll();
            }
        }

        @Override
        public void callOnFrameAvailable() {
            this.mParent.callOnFrameAvailable();
        }

        @Override
        protected void handleDrawTargets(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
            super.handleDrawTargets(isOES, texId, texMatrix);
            this.mParent.notifyCapture();
        }

        @Override
        @SuppressLint(value={"NewApi"})
        @WorkerThread
        protected void handleReCreateInputSurface() {
            this.makeCurrent();
            this.handleReleaseInputSurface();
            this.makeCurrent();
            this.mTexId = GLUtils.initTex(36197, 33984, 9728);
            this.mInputTexture = new SurfaceTexture(this.mTexId);
            this.mInputSurface = new Surface(this.mInputTexture);
            if (BuildCheck.isAndroid4_1()) {
                this.mInputTexture.setDefaultBufferSize(this.width(), this.height());
            }
            this.mInputTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
            this.mParent.callOnCreate(this.mInputSurface);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        @WorkerThread
        protected void handleReleaseInputSurface() {
            if (this.mInputSurface != null) {
                try {
                    this.mInputSurface.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mInputSurface = null;
                this.mParent.callOnDestroy();
            }
            if (this.mInputTexture != null) {
                try {
                    this.mInputTexture.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mInputTexture = null;
            }
            if (this.mTexId != 0) {
                GLUtils.deleteTex(this.mTexId);
                this.mTexId = 0;
            }
        }

        @Override
        protected void handleUpdateTexture() {
            this.mInputTexture.updateTexImage();
            this.mInputTexture.getTransformMatrix(this.mTexMatrix);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        @WorkerThread
        protected void handleResize(int width, int height) {
            super.handleResize(width, height);
            if (BuildCheck.isAndroid4_1()) {
                this.mInputTexture.setDefaultBufferSize(width, height);
            }
        }

        @NonNull
        public AbstractRendererHolder getParent() {
            return this.mParent;
        }

        public Surface getSurface() {
            this.checkMasterSurface();
            return this.mInputSurface;
        }

        public SurfaceTexture getSurfaceTexture() {
            this.checkMasterSurface();
            return this.mInputTexture;
        }

        public void reset() {
            this.checkMasterSurface();
        }

        public void checkMasterSurface() {
            this.checkFinished();
            if (this.mInputSurface == null || !this.mInputSurface.isValid()) {
                Log.d((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.requestRecreateMasterSurface();
            }
        }

        public void queueEvent(@NonNull Runnable task) {
            this.mEglTask.queueEvent(task);
        }

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            this.requestFrame(true, this.mTexId, this.mTexMatrix);
        }
    }
}

