/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.egl;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.egl.EGLBase10;
import com.serenegiant.egl.EGLBase14;
import com.serenegiant.egl.EGLConst;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.ISurface;
import com.serenegiant.system.BuildCheck;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;

public abstract class EGLBase
implements EGLConst {
    public static final int EGL_CONFIG_RGBA = 0;
    public static final int EGL_CONFIG_RGB565 = 1;

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static IContext<?> wrapCurrentContext() {
        if (EGLBase.isEGL14Supported()) {
            return EGLBase14.wrapCurrentContextImpl();
        }
        return EGLBase10.wrapCurrentContextImpl();
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static IContext<?> wrapContext(@Nullable Object context) {
        if (context instanceof IContext) {
            return (IContext)context;
        }
        if (Build.VERSION.SDK_INT >= 17 && context instanceof android.opengl.EGLContext) {
            return EGLBase14.wrap((android.opengl.EGLContext)context);
        }
        if (context instanceof EGLContext) {
            return EGLBase10.wrap((EGLContext)context);
        }
        if (context == null) {
            return null;
        }
        throw new IllegalArgumentException("Unexpected shared context," + context);
    }

    @SuppressLint(value={"NewApi"})
    public static IConfig<?> wrapConfig(@NonNull Object eglConfig) {
        if (Build.VERSION.SDK_INT >= 17 && eglConfig instanceof android.opengl.EGLConfig) {
            return EGLBase14.wrap((android.opengl.EGLConfig)eglConfig);
        }
        if (eglConfig instanceof EGLConfig) {
            return EGLBase10.wrap((EGLConfig)eglConfig);
        }
        throw new IllegalArgumentException("Unexpected egl config," + eglConfig);
    }

    public static EGLBase createFrom(@Nullable IContext<?> sharedContext, boolean withDepthBuffer, boolean isRecordable) {
        return EGLBase.createFrom(GLUtils.getSupportedGLVersion(), sharedContext, withDepthBuffer, 0, isRecordable);
    }

    public static EGLBase createFrom(@Nullable IContext<?> sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        return EGLBase.createFrom(GLUtils.getSupportedGLVersion(), sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    @SuppressLint(value={"NewApi"})
    public static EGLBase createFrom(int maxClientVersion, @Nullable IContext<?> sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        if (EGLBase.isEGL14Supported() && (sharedContext == null || sharedContext instanceof EGLBase14.Context)) {
            return new EGLBase14(maxClientVersion, (EGLBase14.Context)sharedContext, withDepthBuffer, stencilBits, isRecordable);
        }
        return new EGLBase10(maxClientVersion, (EGLBase10.Context)sharedContext, withDepthBuffer, stencilBits, isRecordable);
    }

    @SuppressLint(value={"NewApi"})
    public static EGLBase createFrom(int maxClientVersion, @Nullable Object sharedContext, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        return EGLBase.createFrom(maxClientVersion, EGLBase.wrapContext(sharedContext), withDepthBuffer, stencilBits, isRecordable);
    }

    @SuppressLint(value={"NewApi"})
    public static EGLBase createFromCurrent(int maxClientVersion, boolean withDepthBuffer, int stencilBits, boolean isRecordable) {
        if (EGLBase.isEGL14Supported()) {
            return EGLBase14.createFromCurrentImpl(maxClientVersion, withDepthBuffer, stencilBits, isRecordable);
        }
        return EGLBase10.createFromCurrentImpl(maxClientVersion, withDepthBuffer, stencilBits, isRecordable);
    }

    @SuppressLint(value={"NewApi"})
    public static boolean hasGLThread() {
        if (EGLBase.isEGL14Supported()) {
            return EGLBase14.hasGLThreadImpl();
        }
        return EGLBase10.hasGLThreadImpl();
    }

    public static boolean isEGL14Supported() {
        return BuildCheck.isAPI21();
    }

    protected EGLBase() {
    }

    public abstract void release();

    public abstract String queryString(int var1);

    public abstract int getGlVersion();

    public abstract boolean isValidContext();

    @NonNull
    public abstract IContext<?> getContext() throws IllegalStateException;

    @NonNull
    public abstract IConfig<?> getConfig();

    public abstract IEglSurface createFromSurface(Object var1);

    public abstract IEglSurface createOffscreen(int var1, int var2);

    public abstract IEglSurface wrapCurrent();

    public abstract void makeDefault();

    public abstract void sync();

    public abstract void waitGL();

    public abstract void waitNative();

    public boolean isGLES3() {
        return this.getGlVersion() >= 3;
    }

    public boolean isGLES2() {
        return this.getGlVersion() >= 2;
    }

    public static interface IEglSurface
    extends ISurface {
        @TargetApi(value=18)
        public void swap(long var1);
    }

    public static abstract class IConfig<T> {
        @NonNull
        public final T eglConfig;

        protected IConfig(@NonNull T eglConfig) {
            this.eglConfig = eglConfig;
        }

        @NonNull
        public T getEGLConfig() {
            return this.eglConfig;
        }

        @NonNull
        public String toString() {
            return "Config{eglConfig=" + this.eglConfig + '}';
        }
    }

    public static abstract class IContext<T> {
        @NonNull
        public final T eglContext;

        protected IContext(@NonNull T eglContext) {
            this.eglContext = eglContext;
        }

        public T getEGLContext() {
            return this.eglContext;
        }

        public abstract long getNativeHandle();

        @NonNull
        public String toString() {
            return "Context{eglContext=" + this.eglContext + '}';
        }
    }
}

