/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.dialog;

import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.serenegiant.system.BuildCheck;

public abstract class DialogFragmentEx
extends DialogFragment {
    private static final String TAG = DialogFragmentEx.class.getSimpleName();
    protected static final String ARGS_KEY_REQUEST_CODE = "requestCode";
    protected static final String ARGS_KEY_ID_TITLE = "title";
    protected static final String ARGS_KEY_ID_MESSAGE = "message";
    protected static final String ARGS_KEY_TAG = "tag";

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Bundle args = this.getArguments();
        if (args != null) {
            outState.putAll(args);
        }
    }

    public final void onStart() {
        super.onStart();
        if (BuildCheck.isAndroid7()) {
            this.internalOnResume();
        }
    }

    public final void onResume() {
        super.onResume();
        if (!BuildCheck.isAndroid7()) {
            this.internalOnResume();
        }
    }

    public final void onPause() {
        if (!BuildCheck.isAndroid7()) {
            this.internalOnPause();
        }
        super.onPause();
    }

    public final void onStop() {
        if (BuildCheck.isAndroid7()) {
            this.internalOnPause();
        }
        super.onStop();
    }

    protected void internalOnResume() {
    }

    protected void internalOnPause() {
    }

    protected void popBackStack() {
        FragmentActivity activity = this.getActivity();
        if (activity == null || activity.isFinishing()) {
            return;
        }
        try {
            this.getParentFragmentManager().popBackStack();
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }
}

