/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.db;

import android.database.AbstractCursor;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;

public class MergeCursor
extends AbstractCursor {
    private static final boolean DEBUG = false;
    private static final String TAG = MergeCursor.class.getSimpleName();
    @NonNull
    private final ArrayList<Cursor> mCursors;
    private Cursor mCursor;
    private int mIndex;
    private DataSetObserver mObserver;
    private final DataSetObserver mDefaultObserver = new DataSetObserver(){

        public void onChanged() {
            MergeCursor.this.mPos = -1;
        }

        public void onInvalidated() {
            MergeCursor.this.mPos = -1;
        }
    };

    public MergeCursor(@Nullable ArrayList<Cursor> cursors) {
        this.mCursors = cursors != null ? cursors : new ArrayList();
        this.mCursor = !this.mCursors.isEmpty() ? this.mCursors.get(0) : null;
        this.mObserver = this.mDefaultObserver;
        this.registerDataSetObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        int count = 0;
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                count += cursor.getCount();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onMove(int oldPosition, int newPosition) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            this.mCursor = null;
            this.mIndex = -1;
            int cursorStartPos = 0;
            int index = -1;
            for (Cursor cursor : this.mCursors) {
                ++index;
                if (cursor == null) continue;
                if (newPosition < cursorStartPos + cursor.getCount()) {
                    this.mCursor = cursor;
                    this.mIndex = index;
                    break;
                }
                cursorStartPos += cursor.getCount();
            }
            if (this.mCursor != null) {
                boolean ret = this.mCursor.moveToPosition(newPosition - cursorStartPos);
                return ret;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getString(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getShort(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getInt(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getLong(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getFloat(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getDouble(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getType(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getType(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.isNull(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(int column) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor.getBlob(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnNames() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            if (this.mCursor != null) {
                return this.mCursor.getColumnNames();
            }
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                cursor.deactivate();
            }
        }
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null || cursor.isClosed()) continue;
                cursor.close();
            }
            this.mCursors.clear();
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContentObserver(ContentObserver observer) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                cursor.registerContentObserver(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterContentObserver(ContentObserver observer) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                cursor.unregisterContentObserver(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDataSetObserver(DataSetObserver observer) {
        this.mObserver = observer;
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                cursor.registerDataSetObserver(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mObserver = this.mDefaultObserver;
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                cursor.unregisterDataSetObserver(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requery() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null || cursor.requery()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentIndex() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cursor getCurrentCursor() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCursorCount() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return this.mCursors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cursor getCursor(int index) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            return index >= 0 && index < this.mCursors.size() ? this.mCursors.get(index) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NonNull Cursor cursor) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            this.mCursors.add(cursor);
            cursor.registerDataSetObserver(this.mObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cursor add(int index, @NonNull Cursor cursor) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            if (this.mCursors.size() <= index) {
                this.mCursors.ensureCapacity(index + 1);
                for (int i = this.mCursors.size(); i <= index; ++i) {
                    this.mCursors.add(null);
                }
            }
            Cursor oldCursor = this.getCursor(index);
            this.mCursors.add(index, cursor);
            cursor.registerDataSetObserver(this.mObserver);
            if (oldCursor != null) {
                oldCursor.unregisterDataSetObserver(this.mObserver);
            }
            return oldCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull Cursor cursor) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            cursor.unregisterDataSetObserver(this.mObserver);
            this.mCursors.remove(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cursor remove(int index) {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            Cursor cursor = this.mCursors.remove(index);
            if (cursor != null) {
                cursor.unregisterDataSetObserver(this.mObserver);
            }
            return cursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDataSetObserver() {
        ArrayList<Cursor> arrayList = this.mCursors;
        synchronized (arrayList) {
            for (Cursor cursor : this.mCursors) {
                if (cursor == null) continue;
                cursor.registerDataSetObserver(this.mObserver);
            }
        }
    }
}

