/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.media.MediaReaper;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.usb.uvc.IPipeline;
import com.serenegiant.usb.uvc.IPipelineSource;
import com.serenegiant.usb.uvc.PipelineSource;
import com.serenegiant.utils.BufferHelper;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class TranscodeH264
implements IPipelineSource {
    private static final boolean DEBUG = false;
    private static final String TAG = TranscodeH264.class.getSimpleName();
    public static final int STATE_UNINITIALIZED = -1;
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_PREPARING = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_ENCODING = 3;
    public static final int PREFIX_NON = 0;
    public static final int PREFIX_CSD_KEY_FRAME = 1;
    public static final int PREFIX_CSD_ALL_FRAME = 2;
    public static final int PREFIX_ANNEXB_MARKER = 4;
    protected final Object mSync = new Object();
    private final int mPrefixOpts;
    private final TranscodeH264Listener mListener;
    @NonNull
    private final VideoConfig mVideoConfig;
    private int mState = -1;
    private PipelineSource mPipelineSource;
    private MediaFormat mVideoFormat;
    private MediaCodec mVideoEncoder;
    private MediaReaper.VideoReaper mVideoReaper;
    private int mWidth;
    private int mHeight;
    private final AtomicBoolean mRequestCodecConfig = new AtomicBoolean();
    @SuppressLint(value={"InlinedApi"})
    private static final int BUFFER_FLAG_KEY_FRAME = BuildCheck.isLollipop() ? 1 : 1;
    private static final byte[] START_MARKER = new byte[]{0, 0, 0, 1};
    private static final byte[] START_MARKER_NALU_HEADER_I = new byte[]{0, 0, 0, 1};
    private static final byte[] START_MARKER_NALU_HEADER_P = new byte[]{0, 0, 0, 1};
    private ByteBuffer mSPS;
    private ByteBuffer mPPS;
    private boolean isSendPPS_SPS;
    private ByteBuffer mAnnexBFrame;
    private int mSpsPpsSz;
    private byte[] work;
    private final MediaReaper.ReaperListener mReaperListener = new MediaReaper.ReaperListener(){

        public void writeSampleData(@NonNull MediaReaper reaper, @NonNull ByteBuffer byteBuf, @NonNull MediaCodec.BufferInfo bufferInfo) {
            if (TranscodeH264.this.isRunning() && reaper.reaperType() == 0) {
                if (TranscodeH264.this.mSpsPpsSz > 0 && TranscodeH264.this.mRequestCodecConfig.getAndSet(false)) {
                    ByteBuffer temp = ByteBuffer.allocateDirect(TranscodeH264.this.mSpsPpsSz).order(ByteOrder.nativeOrder());
                    if (TranscodeH264.this.mSPS != null) {
                        TranscodeH264.this.mSPS.clear();
                        temp.put(TranscodeH264.this.mSPS);
                    }
                    if (TranscodeH264.this.mPPS != null) {
                        TranscodeH264.this.mPPS.clear();
                        temp.put(TranscodeH264.this.mPPS);
                    }
                    temp.flip();
                    try {
                        TranscodeH264.this.queueFrame(temp, temp.limit(), TranscodeH264.this.mWidth, TranscodeH264.this.mHeight, bufferInfo.presentationTimeUs, 2);
                    }
                    catch (Exception e) {
                        TranscodeH264.this.stopAsync();
                        Log.w((String)TAG, (Throwable)e);
                        return;
                    }
                }
                try {
                    TranscodeH264.this.queueFrame(byteBuf, bufferInfo.size, TranscodeH264.this.mWidth, TranscodeH264.this.mHeight, bufferInfo.presentationTimeUs, bufferInfo.flags);
                }
                catch (Exception e) {
                    TranscodeH264.this.stopAsync();
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }

        public void onOutputFormatChanged(@NonNull MediaReaper reaper, @NonNull MediaFormat outputFormat) {
            TranscodeH264.this.mVideoFormat = outputFormat;
            TranscodeH264.this.mWidth = outputFormat.getInteger("width");
            TranscodeH264.this.mHeight = outputFormat.getInteger("height");
            TranscodeH264.this.setCSD(outputFormat);
            if (TranscodeH264.this.mListener != null) {
                try {
                    TranscodeH264.this.mListener.onOutputFormatChanged(TranscodeH264.this, outputFormat);
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"onOutputFormatChanged:", (Throwable)e);
                }
            }
        }

        public void onStop(@NonNull MediaReaper reaper) {
            TranscodeH264.this.releaseEncoder();
            if (TranscodeH264.this.mListener != null) {
                try {
                    TranscodeH264.this.mListener.onStop(TranscodeH264.this);
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)"onStop:", (Throwable)e);
                }
            }
        }

        public void onError(@NonNull MediaReaper reaper, Throwable t) {
            TranscodeH264.this.stopAsync();
            Log.w((String)TAG, (Throwable)t);
        }
    };

    protected TranscodeH264(int prefixOptions, TranscodeH264Listener listener, @Nullable VideoConfig config) {
        this.mPipelineSource = new PipelineSource();
        this.mPrefixOpts = prefixOptions;
        this.mListener = listener;
        this.mVideoConfig = config != null ? config : new VideoConfig();
        this.setState(0);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        PipelineSource source;
        Object object = this.mSync;
        synchronized (object) {
            this.stop();
            this.mState = -1;
            source = this.mPipelineSource;
            this.mPipelineSource = null;
        }
        if (source != null) {
            try {
                source.release();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        this.releaseEncoder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 2) {
                throw new IllegalStateException();
            }
        }
        this.setState(3);
        if (this.mListener != null) {
            try {
                this.mListener.onStart(this);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"start:", (Throwable)e);
            }
        }
    }

    @Override
    public void stop() {
        this.internalStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalStop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 3) {
                return;
            }
            this.setState(2);
            this.requestReleaseEncoder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mPipelineSource != null && this.mPipelineSource.isRunning() && (this.mState == 2 || this.mState == 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPipeline(IPipeline next_pipeline) throws IllegalStateException {
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning()) {
                throw new IllegalStateException("already released");
            }
            this.mPipelineSource.setPipeline(next_pipeline);
        }
    }

    @NonNull
    public VideoConfig getConfig() {
        return this.mVideoConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(int newState) {
        Object object = this.mSync;
        synchronized (object) {
            this.mState = newState;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mState;
        }
    }

    public void prepare(int width, int height, int frameRate, float bpp, int iFrameIntervals) throws IllegalStateException, IOException {
        this.prepare(width, height, frameRate, bpp, iFrameIntervals, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(int width, int height, int frameRate, float bpp, int iFrameIntervals, long repeatIntervalsUs) throws IllegalStateException, IOException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 0) {
                throw new IllegalStateException();
            }
            this.setState(1);
            try {
                this.mVideoEncoder = this.createEncoder(this.getConfig(), width, height, frameRate, bpp, iFrameIntervals, repeatIntervalsUs);
                this.onCreateEncoder(this.mVideoEncoder);
                this.mVideoEncoder.start();
                this.mVideoReaper = new MediaReaper.VideoReaper(this.mVideoEncoder, this.mReaperListener, width, height);
                this.setState(2);
            }
            catch (IOException | IllegalStateException e) {
                this.releaseEncoder();
                this.setState(0);
                throw e;
            }
        }
    }

    protected abstract void onCreateEncoder(@NonNull MediaCodec var1);

    @SuppressLint(value={"InlinedApi"})
    protected abstract MediaCodec createEncoder(@NonNull VideoConfig var1, int var2, int var3, int var4, float var5, int var6, long var7) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    private void requestReleaseEncoder() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mVideoEncoder != null) {
                try {
                    this.mVideoEncoder.signalEndOfInputStream();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseEncoder() {
        MediaReaper.VideoReaper reaper;
        MediaCodec encoder;
        Object object = this.mSync;
        synchronized (object) {
            encoder = this.mVideoEncoder;
            this.mVideoEncoder = null;
            reaper = this.mVideoReaper;
            this.mVideoReaper = null;
        }
        if (reaper != null) {
            reaper.release();
        }
        if (encoder != null) {
            try {
                encoder.release();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void stopAsync() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TranscodeH264.this.stop();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MediaFormat getMediaFormat() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState == 3) {
                return this.mVideoFormat;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameAvailableSoon() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mVideoReaper != null) {
                this.mVideoReaper.frameAvailableSoon();
            }
            this.mSync.notifyAll();
        }
    }

    public void requestCodecConfig() {
        this.mRequestCodecConfig.set(true);
    }

    private void setCSD(MediaFormat outputFormat) {
        ByteBuffer sps = null;
        ByteBuffer pps = null;
        if (outputFormat.containsKey("csd-0")) {
            sps = outputFormat.getByteBuffer("csd-0");
        }
        if (outputFormat.containsKey("csd-1")) {
            pps = outputFormat.getByteBuffer("csd-1");
        }
        if (sps != null || pps != null) {
            this.setCSD(sps, pps);
        }
    }

    private void setCSD(ByteBuffer sps, ByteBuffer pps) {
        if (sps == null) {
            sps = pps;
            pps = null;
        }
        this.mSPS = sps != null ? sps.duplicate() : null;
        this.mPPS = pps != null ? pps.duplicate() : null;
        this.mSpsPpsSz = (this.mSPS != null ? this.mSPS.capacity() : 0) + (this.mPPS != null ? this.mPPS.capacity() : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueFrame(ByteBuffer frame, int size, int width, int height, long presentationTimeUs, int flags) throws IllegalStateException {
        this.resetByteBuffer(frame, size);
        ByteBuffer buffer = frame;
        int bufferSz = size;
        if (this.mPrefixOpts != 0) {
            boolean isKeyFrame;
            boolean bl = isKeyFrame = (flags & BUFFER_FLAG_KEY_FRAME) != 0;
            if (isKeyFrame || (this.mPrefixOpts & 2) == 2) {
                if (this.mSpsPpsSz <= 0) {
                    return;
                }
                bufferSz = size + this.mSpsPpsSz + 4;
                if (this.mAnnexBFrame == null || this.mAnnexBFrame.capacity() < bufferSz) {
                    this.mAnnexBFrame = ByteBuffer.allocateDirect(bufferSz).order(ByteOrder.nativeOrder());
                }
                buffer = this.mAnnexBFrame;
                buffer.clear();
                if (this.mSPS != null) {
                    this.mSPS.clear();
                    buffer.put(this.mSPS);
                }
                if (this.mPPS != null) {
                    this.mPPS.clear();
                    buffer.put(this.mPPS);
                }
                buffer.put(START_MARKER);
                buffer.put(frame);
                buffer.flip();
            } else if ((this.mPrefixOpts & 4) == 4) {
                bufferSz = size + 4;
                if (this.mAnnexBFrame == null || this.mAnnexBFrame.capacity() < bufferSz) {
                    this.mAnnexBFrame = ByteBuffer.allocateDirect(bufferSz).order(ByteOrder.nativeOrder());
                }
                buffer = this.mAnnexBFrame;
                buffer.clear();
                buffer.put(START_MARKER);
                buffer.put(frame);
                buffer.flip();
            }
        }
        Object object = this.mSync;
        synchronized (object) {
            if (this.isRunning()) {
                this.mPipelineSource.queueFrame(buffer, bufferSz, width, height, presentationTimeUs, RawFrameType.RAW_FRAME_H264, flags);
            }
        }
    }

    private int findAnnexB(ByteBuffer frame, int size) {
        if (this.work == null || this.work.length < size) {
            this.work = new byte[size + size / 2];
        }
        this.resetByteBuffer(frame, size);
        frame.get(this.work, 0, size);
        this.resetByteBuffer(frame, size);
        return BufferHelper.findAnnexB((byte[])this.work, (int)0);
    }

    private ByteBuffer forceAnnexB(ByteBuffer frame, int size, boolean isKeyFrame, boolean forceAddCSD) {
        int bufferSz = size + (isKeyFrame || forceAddCSD ? this.mSpsPpsSz : 0) + (isKeyFrame ? START_MARKER_NALU_HEADER_I.length : START_MARKER_NALU_HEADER_P.length);
        if (this.mAnnexBFrame == null || this.mAnnexBFrame.capacity() < bufferSz) {
            this.mAnnexBFrame = ByteBuffer.allocateDirect(bufferSz).order(ByteOrder.nativeOrder());
        }
        ByteBuffer buffer = this.mAnnexBFrame;
        buffer.clear();
        if (isKeyFrame || forceAddCSD) {
            if (this.mSPS != null) {
                this.mSPS.clear();
                buffer.put(this.mSPS);
            }
            if (this.mPPS != null) {
                this.mPPS.clear();
                buffer.put(this.mPPS);
            }
        }
        if (isKeyFrame) {
            buffer.put(START_MARKER_NALU_HEADER_I);
        } else {
            buffer.put(START_MARKER_NALU_HEADER_P);
        }
        buffer.put(frame);
        buffer.flip();
        return buffer;
    }

    private void resetByteBuffer(@NonNull ByteBuffer frame, int size) {
        frame.clear();
        frame.position(size);
        frame.flip();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrefixOptions {
    }

    public static interface TranscodeH264Listener {
        public void onOutputFormatChanged(TranscodeH264 var1, MediaFormat var2);

        public void onStart(TranscodeH264 var1);

        public void onStop(TranscodeH264 var1);
    }
}

