/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.ISurfacePreview;
import com.serenegiant.media.PreviewDecoder;
import com.serenegiant.usb.uvc.IPipeline;
import com.serenegiant.usb.uvc.PreviewMode;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

@Deprecated
@Keep
public class PreviewPipeline
extends IPipeline
implements ISurfacePreview {
    private static final boolean DEBUG = false;
    private static final String TAG = PreviewPipeline.class.getSimpleName();
    private final WeakReference<Context> mWeakContext;
    protected final AssetManager mAssetManager;
    private Surface mSurface;
    private final Object mDecoderSync = new Object();
    private PreviewDecoder mDecoder;
    private static final int OFFSET = 0;

    public PreviewPipeline(@NonNull Context context) {
        super(500);
        this.mAssetManager = context.getAssets();
        this.mWeakContext = new WeakReference<Context>(context);
        this.mNativePtr = this.nativeCreate(this.mAssetManager);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline nextPipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, nextPipeline);
    }

    @Override
    public synchronized void start() {
        int result;
        if (this.mSurface != null) {
            this.createDecoder(this.mSurface);
        }
        if ((result = PreviewPipeline.nativeStart(this.mNativePtr)) != 0) {
            throw new IllegalStateException(Integer.toString(result));
        }
    }

    @Override
    public synchronized void stop() {
        this.stopDecoder();
        int result = PreviewPipeline.nativeStop(this.mNativePtr);
        this.releaseDecoder();
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
        this.releaseDecoder();
    }

    public void setPreviewSurface(@Nullable SurfaceHolder holder) {
        Surface surface = holder != null ? holder.getSurface() : null;
        this.setPreviewSurface(surface);
    }

    public void setPreviewSurface(@Nullable SurfaceTexture texture) {
        Surface surface = texture != null ? new Surface(texture) : null;
        this.setPreviewSurface(surface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreviewSurface(Surface surface) {
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (surface != this.mSurface) {
                this.releaseDecoder();
            }
            this.mSurface = surface;
        }
        PreviewPipeline.nativeSetPreviewSurface(this.mNativePtr, surface, 0);
    }

    public void setVideoSize(PreviewMode previewMode, int width, int height) {
        PreviewPipeline.nativeSetVideoSize(this.mNativePtr, previewMode.getValue(), width, height);
    }

    public void setMaxFps(int maxFps) {
        if (this.mNativePtr != 0L) {
            this.nativeSetMaxFps(this.mNativePtr, maxFps);
        }
    }

    protected Context getContext() {
        return (Context)this.mWeakContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onFrame(ByteBuffer frame, int width, int height, long presentationTimeUs, int frame_format, int flags) {
        if (this.mDecoder == null && this.mSurface != null) {
            this.createDecoder(this.mSurface);
        }
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.onFrame(frame, width, height, presentationTimeUs, frame_format, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDecoder(Surface surface) {
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder == null) {
                this.mDecoder = PreviewDecoder.createDecoder(surface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDecoder() {
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.stop();
            }
            this.mDecoderSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDecoder() {
        this.stopDecoder();
        Object object = this.mDecoderSync;
        synchronized (object) {
            if (this.mDecoder != null) {
                this.mDecoder.release();
            }
            this.mDecoder = null;
            this.mSurface = null;
        }
    }

    private final native long nativeCreate(AssetManager var1);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);

    private static final native int nativeSetPreviewSurface(long var0, Surface var2, int var3);

    private static final native int nativeSetVideoSize(long var0, int var2, int var3, int var4);

    protected final native int nativeSetMaxFps(long var1, int var3);
}

