/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.Nullable;
import com.serenegiant.usb.uvc.IPipeline;

@Keep
public class BufferedPipeline
extends IPipeline {
    private static final String TAG = BufferedPipeline.class.getSimpleName();
    private static final int DEFAULT_INIT_FRAME_POOL_SZ = 2;
    private static final int DEFAULT_MAX_FRAME_NUM = 8;
    private static final int DEFAULT_FRAME_SZ = 1024;

    public BufferedPipeline() {
        super(0);
        this.mNativePtr = this.nativeCreate(2, 8, 1024, true);
    }

    @Override
    public int getState() {
        return this.nativeGetState(this.mNativePtr);
    }

    @Override
    public void setPipeline(@Nullable IPipeline next_pipeline) {
        if (this.getState() < 20) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, next_pipeline);
    }

    @Override
    public void start() {
        int result = BufferedPipeline.nativeStart(this.mNativePtr);
        if (result != 0) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void stop() {
        int result = BufferedPipeline.nativeStop(this.mNativePtr);
        if (result != 0) {
            Log.w((String)TAG, (String)("nativeStop returned " + result));
        }
    }

    @Override
    public void release() {
        this.nativeDestroy(this.mNativePtr);
        this.mNativePtr = 0L;
    }

    private final native long nativeCreate(int var1, int var2, int var3, boolean var4);

    private final native void nativeDestroy(long var1);

    private final native int nativeGetState(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeStart(long var0);

    private static final native int nativeStop(long var0);
}

