/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.usb.UsbDevice;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.serenegiant.libaandusb.R;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.usb.IDeviceSelectDialogListener;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UsbUtils;
import java.util.ArrayList;
import java.util.List;

public final class DeviceSelectDialogV4
extends DialogFragment {
    private static final String TAG = "DeviceSelectDialog";
    protected USBMonitor mUSBMonitor;
    private Spinner mSpinner;
    private DeviceListAdapter mDeviceListAdapter;
    private final DialogInterface.OnClickListener mOnDialogClickListener = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialog, int which) {
            switch (which) {
                case -1: {
                    Object item = DeviceSelectDialogV4.this.mSpinner.getSelectedItem();
                    if (!(item instanceof UsbDevice)) break;
                    DeviceSelectDialogV4.this.mUSBMonitor.requestPermission((UsbDevice)item);
                    dialog.dismiss();
                    break;
                }
                case -2: {
                    dialog.cancel();
                }
            }
        }
    };
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            DeviceSelectDialogV4.this.updateDevices();
        }
    };

    @Nullable
    public static DeviceSelectDialogV4 findDialog(FragmentActivity parent) {
        Fragment fragment = parent.getSupportFragmentManager().findFragmentByTag(TAG);
        if (fragment instanceof DeviceSelectDialogV4) {
            return (DeviceSelectDialogV4)fragment;
        }
        return null;
    }

    @Nullable
    public static DeviceSelectDialogV4 findDialog(Fragment parent) {
        Fragment fragment = parent.getParentFragmentManager().findFragmentByTag(TAG);
        if (fragment instanceof DeviceSelectDialogV4) {
            return (DeviceSelectDialogV4)fragment;
        }
        return null;
    }

    public static DeviceSelectDialogV4 showDialog(FragmentActivity parent) {
        DeviceSelectDialogV4 dialog = DeviceSelectDialogV4.newInstance();
        try {
            dialog.show(parent.getSupportFragmentManager(), TAG);
        }
        catch (IllegalStateException e) {
            dialog = null;
        }
        return dialog;
    }

    public static DeviceSelectDialogV4 showDialog(Fragment parent) {
        return DeviceSelectDialogV4.showDialog(parent, 1);
    }

    public static DeviceSelectDialogV4 showDialog(Fragment parent, int requestCode) {
        DeviceSelectDialogV4 dialog = DeviceSelectDialogV4.newInstance();
        dialog.setTargetFragment(parent, requestCode);
        try {
            dialog.show(parent.getParentFragmentManager(), TAG);
        }
        catch (IllegalStateException e) {
            dialog = null;
        }
        return dialog;
    }

    public static DeviceSelectDialogV4 newInstance() {
        DeviceSelectDialogV4 dialog = new DeviceSelectDialogV4();
        Bundle args = new Bundle();
        dialog.setArguments(args);
        return dialog;
    }

    @SuppressLint(value={"NewApi"})
    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        try {
            this.mUSBMonitor = ((IDeviceSelectDialogListener)this.getTargetFragment()).getUSBMonitor();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.mUSBMonitor == null && BuildCheck.isAndroid4_2()) {
            try {
                this.mUSBMonitor = ((IDeviceSelectDialogListener)this.getParentFragment()).getUSBMonitor();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.mUSBMonitor == null) {
            try {
                this.mUSBMonitor = ((IDeviceSelectDialogListener)context).getUSBMonitor();
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.mUSBMonitor == null) {
            Log.w((String)TAG, (String)"must implement IDeviceSelectDialogListener");
            throw new ClassCastException(context.toString() + " must implement IDeviceSelectDialogListener");
        }
    }

    public void onSaveInstanceState(@NonNull Bundle saveInstanceState) {
        Bundle args = this.getArguments();
        if (args != null) {
            saveInstanceState.putAll(args);
        }
        super.onSaveInstanceState(saveInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setView(this.initView());
        builder.setTitle(R.string.select);
        builder.setPositiveButton(17039370, this.mOnDialogClickListener);
        builder.setNegativeButton(0x1040000, this.mOnDialogClickListener);
        builder.setNeutralButton(R.string.refresh, null);
        AlertDialog dialog = builder.create();
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    @SuppressLint(value={"InflateParams"})
    private View initView() {
        View rootView = this.getActivity().getLayoutInflater().inflate(R.layout.dialog_device_selector, null, false);
        this.mSpinner = (Spinner)rootView.findViewById(R.id.spinner1);
        return rootView;
    }

    public void onResume() {
        super.onResume();
        this.updateDevices();
        Button button = (Button)this.getDialog().findViewById(16908315);
        button.setOnClickListener(this.mOnClickListener);
    }

    public void onCancel(@NonNull DialogInterface dialog) {
        super.onCancel(dialog);
        this.mUSBMonitor.requestPermission(null);
    }

    public void updateDevices() {
        FragmentActivity activity;
        if (this.mUSBMonitor != null) {
            this.mDeviceListAdapter = new DeviceListAdapter((Context)this.getActivity(), this.mUSBMonitor.getDeviceList());
        }
        if ((activity = this.getActivity()) != null && !activity.isFinishing()) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DeviceSelectDialogV4.this.mSpinner.setAdapter((SpinnerAdapter)DeviceSelectDialogV4.this.mDeviceListAdapter);
                }
            });
        }
    }

    private static final class DeviceListAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;
        private final List<UsbDevice> mList;

        public DeviceListAdapter(Context context, List<UsbDevice> list) {
            this.mInflater = LayoutInflater.from((Context)context);
            this.mList = list != null ? list : new ArrayList();
        }

        public int getCount() {
            return this.mList.size();
        }

        public UsbDevice getItem(int position) {
            if (position >= 0 && position < this.mList.size()) {
                return this.mList.get(position);
            }
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        @SuppressLint(value={"NewApi"})
        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.listitem_device, parent, false);
            }
            if (convertView instanceof CheckedTextView) {
                String name;
                UsbDevice device = this.getItem(position);
                String string2 = name = BuildCheck.isAndroid5() ? device.getProductName() : null;
                if (TextUtils.isEmpty((CharSequence)name)) {
                    name = device.getDeviceName();
                }
                if (TextUtils.isEmpty((CharSequence)name)) {
                    name = String.format("%08x", UsbUtils.getDeviceKey((UsbDevice)device, (boolean)true));
                }
                ((CheckedTextView)convertView).setText((CharSequence)String.format("UVC Camera:(%x:%x:%s)", device.getVendorId(), device.getProductId(), name));
            }
            return convertView;
        }
    }
}

