/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.RawFrameType;
import java.util.Locale;

public class Size
implements Parcelable {
    private static final boolean DEBUG = false;
    private static final String TAG = Size.class.getSimpleName();
    public RawFrameType frameType;
    public int index;
    public int width;
    public int height;
    public int frameIntervalType;
    public int frameIntervalIndex;
    public int[] intervals;
    public RawFrameType stillCaptureFrameType;
    public float[] fps;
    private String frameRates;
    public static final Size EMPTY = new Size(){

        @Override
        public Size set(Size other) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCurrentFrameRate(float frameRate) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    };
    public static final Parcelable.Creator<Size> CREATOR = new Parcelable.Creator<Size>(){

        public Size createFromParcel(Parcel source) {
            return new Size(source);
        }

        public Size[] newArray(int size) {
            return new Size[size];
        }
    };

    public Size() {
        this.frameIntervalType = -1;
        this.frameType = this.stillCaptureFrameType = RawFrameType.RAW_FRAME_UNKNOWN;
        this.updateFrameRate();
    }

    public Size(int _index, int _width, int _height) {
        this.frameType = this.stillCaptureFrameType = RawFrameType.RAW_FRAME_STILL;
        this.index = _index;
        this.width = _width;
        this.height = _height;
    }

    public Size(RawFrameType _frameType, int _index, int _width, int _height) {
        this.frameType = _frameType;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        this.frameIntervalType = -1;
        this.frameIntervalIndex = 0;
        this.intervals = null;
        this.stillCaptureFrameType = RawFrameType.RAW_FRAME_UNKNOWN;
        this.updateFrameRate();
    }

    public Size(RawFrameType _frameType, int _index, int _width, int _height, int _minIntervals, int _maxIntervals, int _step) {
        this.frameType = _frameType;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        this.frameIntervalType = 0;
        this.frameIntervalIndex = 0;
        this.intervals = new int[3];
        this.intervals[0] = _minIntervals;
        this.intervals[1] = _maxIntervals;
        this.intervals[2] = _step;
        this.stillCaptureFrameType = RawFrameType.RAW_FRAME_UNKNOWN;
        this.updateFrameRate();
    }

    public Size(RawFrameType _frameType, int _index, int _width, int _height, int[] _intervals) {
        int n;
        this.frameType = _frameType;
        this.index = _index;
        this.width = _width;
        this.height = _height;
        int n2 = n = _intervals != null ? _intervals.length : -1;
        if (n > 0) {
            this.frameIntervalType = n;
            this.intervals = new int[n];
            System.arraycopy(_intervals, 0, this.intervals, 0, n);
        } else {
            this.frameIntervalType = -1;
            this.intervals = null;
        }
        this.frameIntervalIndex = 0;
        this.stillCaptureFrameType = RawFrameType.RAW_FRAME_UNKNOWN;
        this.updateFrameRate();
    }

    public Size(@NonNull Size other) {
        int n;
        this.frameType = other.frameType;
        this.index = other.index;
        this.width = other.width;
        this.height = other.height;
        this.frameIntervalType = other.frameIntervalType;
        this.frameIntervalIndex = other.frameIntervalIndex;
        this.stillCaptureFrameType = other.stillCaptureFrameType;
        int n2 = n = other.intervals != null ? other.intervals.length : -1;
        if (n > 0) {
            this.intervals = new int[n];
            System.arraycopy(other.intervals, 0, this.intervals, 0, n);
        } else {
            this.intervals = null;
        }
        this.updateFrameRate();
    }

    private Size(@NonNull Parcel source) {
        this.frameType = RawFrameType.from(source.readInt());
        this.index = source.readInt();
        this.width = source.readInt();
        this.height = source.readInt();
        this.frameIntervalType = source.readInt();
        this.frameIntervalIndex = source.readInt();
        this.stillCaptureFrameType = RawFrameType.from(source.readInt());
        if (this.frameIntervalType >= 0) {
            this.intervals = this.frameIntervalType > 0 ? new int[this.frameIntervalType] : new int[3];
            source.readIntArray(this.intervals);
        } else {
            this.intervals = null;
        }
        this.updateFrameRate();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Size) {
            Size other = (Size)obj;
            if (this.frameType == other.frameType && this.index == other.index && this.width == other.width && this.height == other.height && this.frameIntervalType == other.frameIntervalType && this.stillCaptureFrameType == other.stillCaptureFrameType && this.intervals != other.intervals) {
                int n0;
                int n = n0 = this.intervals != null ? this.intervals.length : 0;
                if (n0 > 0) {
                    int m0;
                    int n2 = m0 = other.intervals != null ? other.intervals.length : 0;
                    if (n0 == m0) {
                        boolean result = true;
                        int[] other_intervals = other.intervals;
                        for (int i = 0; i < n0; ++i) {
                            if (this.intervals[i] == other_intervals[i]) continue;
                            result = false;
                            break;
                        }
                        return result;
                    }
                }
            }
            return false;
        }
        return super.equals(obj);
    }

    public Size set(Size other) {
        if (other != null) {
            int n;
            this.frameType = other.frameType;
            this.index = other.index;
            this.width = other.width;
            this.height = other.height;
            this.frameIntervalType = other.frameIntervalType;
            this.frameIntervalIndex = other.frameIntervalIndex;
            this.stillCaptureFrameType = other.stillCaptureFrameType;
            int n2 = n = other.intervals != null ? other.intervals.length : -1;
            if (n > 0) {
                this.intervals = new int[n];
                System.arraycopy(other.intervals, 0, this.intervals, 0, n);
            } else {
                this.frameIntervalType = -1;
                this.intervals = null;
            }
            this.updateFrameRate();
        } else {
            this.clear();
        }
        return this;
    }

    @NonNull
    public String toString() {
        float frameRate = 0.0f;
        try {
            frameRate = this.getCurrentFrameRate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.format(Locale.US, "Size(%dx%d@%4.1f,frameType:%d,index:%d,%s)", this.width, this.height, Float.valueOf(frameRate), this.frameType.getValue(), this.index, this.frameRates);
    }

    @NonNull
    public String toShortString() {
        return String.format(Locale.US, "%dx%d@%s", this.width, this.height, this.frameType.getLabel());
    }

    public void clear() {
        this.set(EMPTY);
    }

    @Nullable
    public float[] getSupportedFrameRate() {
        if (this.fps != null && this.fps.length > 0) {
            return this.copySupportedFrameRate();
        }
        this.updateFrameRate();
        if (this.fps != null && this.fps.length > 0) {
            return this.copySupportedFrameRate();
        }
        return null;
    }

    @Nullable
    private float[] copySupportedFrameRate() {
        int n;
        int n2 = n = this.fps != null ? this.fps.length : 0;
        if (n > 0) {
            float[] copy = new float[n];
            System.arraycopy(this.fps, 0, copy, 0, n);
            return copy;
        }
        return null;
    }

    public String getSupportedFrameRateString() {
        this.updateFrameRate();
        return this.frameRates;
    }

    public float getCurrentFrameRate() throws IllegalStateException {
        int n;
        int n2 = n = this.fps != null ? this.fps.length : 0;
        if (this.frameIntervalIndex >= 0 && this.frameIntervalIndex < n) {
            return this.fps[this.frameIntervalIndex];
        }
        throw new IllegalStateException("unknown frame rate or not ready");
    }

    public void setCurrentFrameRate(float frameRate) {
        int index = -1;
        int n = this.fps != null ? this.fps.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!(this.fps[i] <= frameRate)) continue;
            index = i;
            break;
        }
        this.frameIntervalIndex = index;
    }

    private void updateFrameRate() {
        int n = this.frameIntervalType;
        if (n > 0) {
            this.fps = new float[n];
            for (int i = 0; i < n; ++i) {
                this.fps[i] = 1.0E7f / (float)this.intervals[i];
            }
        } else if (n == 0) {
            try {
                float fps;
                int min = Math.min(this.intervals[0], this.intervals[1]);
                int max = Math.max(this.intervals[0], this.intervals[1]);
                int step = this.intervals[2];
                if (step > 0) {
                    int i;
                    int m = 0;
                    for (i = min; i <= max; i += step) {
                        ++m;
                    }
                    this.fps = new float[m];
                    m = 0;
                    for (i = min; i <= max; i += step) {
                        int n2 = m++;
                        float f = 1.0E7f / (float)i;
                        this.fps[n2] = f;
                        float f2 = f;
                    }
                }
                float max_fps = 1.0E7f / (float)min;
                int m = 0;
                for (fps = 1.0E7f / (float)min; fps <= max_fps; fps += 1.0f) {
                    ++m;
                }
                this.fps = new float[m];
                m = 0;
                for (fps = 1.0E7f / (float)min; fps <= max_fps; fps += 1.0f) {
                    this.fps[m++] = fps;
                }
            }
            catch (Exception e) {
                this.fps = null;
            }
        }
        int m = this.fps != null ? this.fps.length : 0;
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < m; ++i) {
            sb.append(String.format(Locale.US, "%4.1f", Float.valueOf(this.fps[i])));
            if (i >= m - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        this.frameRates = sb.toString();
        if (this.frameIntervalIndex > m) {
            this.frameIntervalIndex = 0;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.frameType.getValue());
        dest.writeInt(this.index);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.frameIntervalType);
        dest.writeInt(this.frameIntervalIndex);
        dest.writeInt(this.stillCaptureFrameType.getValue());
        if (this.intervals != null) {
            dest.writeIntArray(this.intervals);
        }
    }
}

