/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.Log;
import android.util.SparseBooleanArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.AbstractBuiltInCamera;
import com.serenegiant.camera.CameraUtils;
import com.serenegiant.camera.FuncMaxMinDef;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.camera.Size;
import com.serenegiant.view.ViewUtils;
import java.io.IOException;
import java.util.List;

public class BuiltInCamera
extends AbstractBuiltInCamera<Camera> {
    private static final boolean DEBUG = false;
    private static final String TAG = BuiltInCamera.class.getSimpleName();
    private Camera.Parameters mParams;
    private final Camera.CameraInfo mCameraInfo = new Camera.CameraInfo();
    private int mRotation;
    private int mPreviewFormat;
    private final boolean mRecordingHint;
    protected int mBrightnessMin;
    protected int mBrightnessMax;
    protected int mBrightnessStep;
    protected int mBrightnessDef;
    protected int mContrastMin;
    protected int mContrastMax;
    protected int mContrastStep;
    protected int mContrastDef;
    protected int mSharpnessMin;
    protected int mSharpnessMax;
    protected int mSharpnessStep;
    protected int mSharpnessDef;
    protected int mSaturationMin;
    protected int mSaturationMax;
    protected int mSaturationStep;
    protected int mSaturationDef;
    protected int mExposureCompensationMin;
    protected int mExposureCompensationMax;
    protected int mExposureCompensationDef;
    protected int mExposureTimeMin;
    protected int mExposureTimeMax;
    protected int mExposureTimeStep;
    protected int mExposureTimeDef;

    protected BuiltInCamera(@NonNull Context context, int face) {
        this(context, face, 17, true);
    }

    protected BuiltInCamera(@NonNull Context context, int face, int previewFormat, boolean recordingHint) {
        super(context, face);
        this.mPreviewFormat = previewFormat;
        this.mRecordingHint = recordingHint;
        this.setState(16);
    }

    @Override
    @Nullable
    protected Size getVideoSizeSetting() {
        return null;
    }

    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps) {
        this.setVideoSize(width, height, minFps, maxFps, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVideoSize(int width, int height, float minFps, float maxFps, float bandwidthFactor) {
        Camera camera;
        if (this.mInfo.width == width && this.mInfo.height == height) {
            return;
        }
        final boolean isPreviewing = this.isStreaming();
        if (isPreviewing) {
            this.internalStopStream();
        }
        if ((camera = (Camera)this.getCamera()) != null) {
            camera.setErrorCallback(new Camera.ErrorCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onError(int error, Camera camera) {
                    Log.w((String)TAG, (String)("setVideoSize:error=" + error));
                    if (error == 100) {
                        boolean preview = isPreviewing || BuiltInCamera.this.isStreaming();
                        try {
                            BuiltInCamera.this.internalReOpen();
                        }
                        catch (Exception e) {
                            preview = false;
                            Log.w((String)TAG, (Throwable)e);
                        }
                        finally {
                            if (preview) {
                                BuiltInCamera.this.startStream();
                            }
                        }
                    }
                    camera.setErrorCallback(null);
                }
            });
            try {
                this.setupCamera(camera, width, height, minFps, maxFps, this.mRotation);
                this.updateCurrentSize();
            }
            finally {
                if (isPreviewing) {
                    this.internalStartStream();
                }
            }
        } else {
            this.mInfo.width = width;
            this.mInfo.height = height;
            this.currentMinFps = minFps;
            this.currentMaxFps = maxFps;
        }
    }

    @Override
    public void toggleFacing() {
        int face = CameraUtils.findCamera((int)(this.mCameraInfo.facing == 0 ? 1 : 0));
        if (face != this.mInfo.face) {
            this.release();
            Camera camera = this.openCamera(face);
            this.mInfo.set(face);
            this.swap(camera);
            this.updateResolutions();
            this.setupCamera(camera, this.mInfo.width, this.mInfo.height, this.currentMinFps, this.currentMaxFps, this.mRotation);
            this.updateCurrentSize();
        }
    }

    @Override
    protected void internalOpenCamera() {
        int face = CameraUtils.findCamera((int)this.mInfo.face);
        Camera camera = this.openCamera(face);
        this.swap(camera);
        this.mInfo.set(face);
        this.updateResolutions();
        int degrees = ViewUtils.getRotationDegrees((Context)this.requireContext());
        int width = 640;
        int height = 480;
        Size sz = this.getVideoSizeSetting();
        if (sz != null) {
            width = sz.width;
            height = sz.height;
        }
        this.setupCamera(camera, width, height, this.currentMinFps, this.currentMaxFps, degrees);
        this.mRotation = degrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalReOpen() {
        this.internalDisconnect();
        this.writeLock();
        try {
            this.setState(256, -257);
            int face = CameraUtils.findCamera((int)this.mInfo.face);
            Camera camera = this.openCamera(face);
            this.swap(camera);
            this.mInfo.set(face);
            this.updateResolutions();
            int degrees = ViewUtils.getRotationDegrees((Context)this.requireContext());
            Log.i((String)TAG, (String)String.format("internalReOpen:frameSize(%d,%d):", this.mInfo.width, this.mInfo.height));
            this.setupCamera(camera, this.mInfo.width, this.mInfo.height, this.currentMinFps, this.currentMaxFps, degrees);
            this.mRotation = degrees;
            this.setState(512, -513);
        }
        finally {
            this.setState(0, -257);
            this.writeUnlock();
        }
        this.updateCurrentSize();
        this.internalUpdateRotation();
    }

    @Override
    protected boolean internalDisconnect() {
        this.setState(0, -769);
        this.clearCameraParams();
        Camera camera = this.swap(null);
        if (camera != null) {
            camera.release();
            return true;
        }
        return false;
    }

    protected Camera openCamera(int cameraId) {
        Camera camera = null;
        if (cameraId >= 0) {
            camera = Camera.open((int)cameraId);
        }
        if (camera == null) {
            throw new RuntimeException("Unable to open camera:cameraId=" + cameraId);
        }
        this.mParams = camera.getParameters();
        if (this.mPreviewFormat != 0) {
            this.mParams.setPreviewFormat(this.mPreviewFormat);
        }
        this.mParams.setRecordingHint(this.mRecordingHint);
        return camera;
    }

    protected void setupCamera(@NonNull Camera camera, int width, int height, float minFps, float maxFps, int degrees) {
        BuiltInCamera.setupFocusMode(this.mParams);
        CameraUtils.chooseVideoSize((Camera.Parameters)this.mParams, (int)width, (int)height);
        int[] fps = CameraUtils.chooseFps((Camera.Parameters)this.mParams, (float)minFps, (float)maxFps);
        if (fps != null && fps.length > 1) {
            this.currentMinFps = fps[0];
            this.currentMaxFps = fps[1];
        }
        this.setRotation(camera, degrees);
        try {
            camera.setParameters(this.mParams);
        }
        catch (Exception e) {
            this.mPreviewFormat = 17;
            this.mParams.setPreviewFormat(17);
            try {
                ((Camera)this.getCamera()).setParameters(this.mParams);
            }
            catch (Exception e1) {
                Log.e((String)TAG, (String)"setupCamera:exception on #setParameters", (Throwable)e1);
            }
        }
    }

    protected static void setupFocusMode(@NonNull Camera.Parameters params) {
        List focusModes = params.getSupportedFocusModes();
        if (focusModes.contains("continuous-video")) {
            params.setFocusMode("continuous-video");
        } else if (focusModes.contains("auto")) {
            params.setFocusMode("auto");
        }
    }

    protected void updateResolutions() {
        List previewSizes = this.mParams.getSupportedPreviewSizes();
        SparseBooleanArray intervals = new SparseBooleanArray();
        this.mSupportedResolutions.clear();
        int index = 0;
        for (Camera.Size size : previewSizes) {
            intervals.clear();
            try {
                Size sz;
                this.mParams.setPreviewSize(size.width, size.height);
                List fpsRanges = this.mParams.getSupportedPreviewFpsRange();
                for (int x = fpsRanges.size() - 1; x >= 0; --x) {
                    int[] range = (int[])fpsRanges.get(x);
                    intervals.append(range[1], true);
                }
                int n = intervals.size();
                if (n > 0) {
                    int[] _intervals = new int[n];
                    for (int i = 0; i < n; ++i) {
                        _intervals[i] = (int)(1.0E7f / ((float)intervals.keyAt(i) / 1000.0f));
                    }
                    sz = new Size(RawFrameType.RAW_FRAME_INTERNAL_CAMERA, index++, size.width, size.height, _intervals);
                } else {
                    sz = new Size(RawFrameType.RAW_FRAME_INTERNAL_CAMERA, index++, size.width, size.height);
                }
                this.mSupportedResolutions.add(sz);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    @Override
    protected void updateCurrentSize() {
        Camera.Size size = this.mParams.getPreviewSize();
        for (Size sz : this.mSupportedResolutions) {
            if (sz.width != size.width || sz.height != size.height) continue;
            this.mInfo.set(this.mInfo.id, this.mInfo.face, this.mInfo.orientation, sz.width, sz.height);
            break;
        }
        Camera.getCameraInfo((int)this.mInfo.face, (Camera.CameraInfo)this.mCameraInfo);
    }

    @Override
    public boolean startStream() {
        this.writeLock();
        try {
            Camera camera = (Camera)this.getCamera();
            if (camera != null) {
                try {
                    camera.setPreviewTexture(this.getInputSurfaceTexture());
                    this.internalStartStream();
                    this.setState(1024, -1025);
                }
                catch (IOException e) {
                    this.setState(0, -1793);
                    camera.release();
                    this.swap(null);
                }
            } else {
                Log.w((String)TAG, (String)"startStream:mCamera is unexpectedly null");
            }
            boolean bl = camera != null;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected void internalStartStream() {
        this.readLock();
        try {
            Camera camera = (Camera)this.getCamera();
            if (camera != null) {
                camera.startPreview();
            } else {
                Log.w((String)TAG, (String)"internalStartStream:camera is unexpectedly null");
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    protected void internalStopStream() {
        this.readLock();
        try {
            Camera camera = (Camera)this.getCamera();
            if (camera != null) {
                camera.stopPreview();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public int getRotation() {
        boolean isFrontFace = this.mCameraInfo.facing == 1;
        int degrees = this.mRotation;
        if (isFrontFace) {
            degrees = (this.mCameraInfo.orientation + degrees) % 360;
            degrees = (360 - degrees) % 360;
        } else {
            degrees = (this.mCameraInfo.orientation - degrees + 360) % 360;
        }
        return degrees;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRotation() {
        block8: {
            this.readLock();
            try {
                int degrees;
                Camera camera = (Camera)this.getCamera();
                if (camera == null || this.mRotation == (degrees = ViewUtils.getRotationDegrees((Context)this.requireContext()))) break block8;
                this.mRotation = degrees;
                boolean isPreviewing = this.isStreaming();
                if (isPreviewing) {
                    this.internalStopStream();
                }
                try {
                    this.setRotation(camera, degrees);
                }
                finally {
                    if (isPreviewing) {
                        this.internalStartStream();
                    }
                }
            }
            finally {
                this.readUnlock();
            }
        }
    }

    private void setRotation(@NonNull Camera camera, int degrees) {
        boolean isFrontFace;
        Camera.getCameraInfo((int)this.mInfo.face, (Camera.CameraInfo)this.mCameraInfo);
        boolean bl = isFrontFace = this.mCameraInfo.facing == 1;
        if (isFrontFace) {
            degrees = (this.mCameraInfo.orientation + degrees) % 360;
            degrees = (360 - degrees) % 360;
        } else {
            degrees = (this.mCameraInfo.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(degrees);
    }

    @Nullable
    protected Camera.Parameters getParameters() {
        this.readLock();
        try {
            Camera.Parameters parameters = this.mParams;
            return parameters;
        }
        finally {
            this.readUnlock();
        }
    }

    protected void setParameters(@Nullable Camera.Parameters parameters) throws RuntimeException {
        this.writeLock();
        try {
            if (parameters != null && this.mParams != null) {
                this.mParams.unflatten(parameters.flatten());
                Camera camera = (Camera)this.getCamera();
                if (camera != null) {
                    camera.setParameters(this.mParams);
                }
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private static int as(Object value, int defaultValue) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (Exception exception) {
                try {
                    return Integer.parseInt((String)value, 16);
                }
                catch (Exception exception2) {
                    try {
                        return (int)Long.parseLong((String)value);
                    }
                    catch (Exception exception3) {
                        try {
                            return (int)Long.parseLong((String)value, 16);
                        }
                        catch (Exception exception4) {
                            try {
                                return (int)Double.parseDouble((String)value);
                            }
                            catch (Exception exception5) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return defaultValue;
    }

    private static float as(Object value, float defaultValue) {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof String) {
            try {
                return (float)Double.parseDouble((String)value);
            }
            catch (Exception exception) {
                try {
                    return Integer.parseInt((String)value);
                }
                catch (Exception exception2) {
                    try {
                        return Integer.parseInt((String)value, 16);
                    }
                    catch (Exception exception3) {
                        try {
                            return (int)Long.parseLong((String)value);
                        }
                        catch (Exception exception4) {
                            try {
                                return (int)Long.parseLong((String)value, 16);
                            }
                            catch (Exception exception5) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }
        return defaultValue;
    }

    @Override
    protected void clearCameraParams() {
        super.clearCameraParams();
        this.mBrightnessDef = 0;
        this.mBrightnessStep = 0;
        this.mBrightnessMax = 0;
        this.mBrightnessMin = 0;
        this.mContrastDef = 0;
        this.mContrastStep = 0;
        this.mContrastMax = 0;
        this.mContrastMin = 0;
        this.mSharpnessDef = 0;
        this.mSharpnessStep = 0;
        this.mSharpnessMax = 0;
        this.mSharpnessMin = 0;
        this.mSaturationDef = 0;
        this.mSaturationStep = 0;
        this.mSaturationMax = 0;
        this.mSaturationMin = 0;
        this.mExposureCompensationDef = 0;
        this.mExposureCompensationMax = 0;
        this.mExposureCompensationMin = 0;
        this.mExposureTimeDef = 0;
        this.mExposureTimeStep = 0;
        this.mExposureTimeMax = 0;
        this.mExposureTimeMin = 0;
    }

    @Override
    protected void updateCameraParamsLocked() {
        super.updateCameraParamsLocked();
        Camera camera = (Camera)this.getCamera();
        if (camera != null && this.mParams != null) {
            int center;
            if (this.mExposureCompensationMin == this.mExposureCompensationMax) {
                this.mExposureCompensationMin = this.mParams.getMinExposureCompensation();
                this.mExposureCompensationMax = this.mParams.getMaxExposureCompensation();
                this.mExposureCompensationDef = this.mParams.getExposureCompensation();
            }
            this.mControlSupports |= this.mExposureCompensationMin != this.mExposureCompensationMax ? 16L : 0L;
            if (this.mExposureTimeMin == this.mExposureTimeMax) {
                this.mExposureTimeMin = BuiltInCamera.as((Object)this.mParams.get("min-exposure-time"), 0);
                this.mExposureTimeMax = BuiltInCamera.as((Object)this.mParams.get("max-exposure-time"), this.mBrightnessMin);
                this.mExposureTimeStep = BuiltInCamera.as((Object)this.mParams.get("exposure-time-step"), 1);
                center = (this.mExposureTimeMax - this.mExposureTimeMin) / 2 + this.mExposureTimeMin;
                this.mExposureTimeDef = BuiltInCamera.as((Object)this.mParams.get("exposure-time"), center);
            }
            this.mControlSupports |= this.mExposureTimeMin != this.mExposureTimeMax ? 8L : 0L;
            if (this.mBrightnessMin == this.mBrightnessMax) {
                this.mBrightnessMin = BuiltInCamera.as((Object)this.mParams.get("min-brightness"), 0);
                this.mBrightnessMax = BuiltInCamera.as((Object)this.mParams.get("max-brightness"), this.mBrightnessMin);
                this.mBrightnessStep = BuiltInCamera.as((Object)this.mParams.get("brightness-step"), 1);
                center = (this.mBrightnessMax - this.mBrightnessMin) / 2 + this.mBrightnessMin;
                this.mBrightnessDef = BuiltInCamera.as((Object)this.mParams.get("brightness"), center);
            }
            this.mProcSupports |= this.mBrightnessMin != this.mBrightnessMax ? -2147483647L : 0L;
            if (this.mContrastMin == this.mContrastMax) {
                this.mContrastMin = BuiltInCamera.as((Object)this.mParams.get("min-contrast"), 0);
                this.mContrastMax = BuiltInCamera.as((Object)this.mParams.get("max-contrast"), this.mContrastMin);
                this.mContrastStep = BuiltInCamera.as((Object)this.mParams.get("contrast-step"), 1);
                center = (this.mContrastMax - this.mContrastMin) / 2 + this.mContrastMin;
                this.mBrightnessDef = BuiltInCamera.as((Object)this.mParams.get("contrast"), center);
            }
            this.mProcSupports |= this.mContrastMin != this.mContrastMax ? -2147483646L : 0L;
            if (this.mSharpnessMin == this.mSharpnessMax) {
                this.mSharpnessMin = BuiltInCamera.as((Object)this.mParams.get("min-sharpness"), 0);
                this.mSharpnessMax = BuiltInCamera.as((Object)this.mParams.get("max-sharpness"), this.mSharpnessMin);
                this.mSharpnessStep = BuiltInCamera.as((Object)this.mParams.get("sharpness-step"), 1);
                center = (this.mSharpnessMax - this.mSharpnessMin) / 2 + this.mSharpnessMin;
                this.mSharpnessDef = BuiltInCamera.as((Object)this.mParams.get("sharpness"), center);
            }
            this.mProcSupports |= this.mSharpnessMin != this.mSharpnessMax ? -2147483632L : 0L;
            if (this.mSaturationMin == this.mSaturationMax) {
                this.mSaturationMin = BuiltInCamera.as((Object)this.mParams.get("min-saturation"), 0);
                this.mSaturationMax = BuiltInCamera.as((Object)this.mParams.get("max-saturation"), this.mSaturationMin);
                this.mSaturationStep = BuiltInCamera.as((Object)this.mParams.get("saturation-step"), 1);
                center = (this.mSaturationMax - this.mSaturationMin) / 2 + this.mSaturationMin;
                this.mSaturationDef = BuiltInCamera.as((Object)this.mParams.get("saturation"), center);
            }
            this.mProcSupports |= this.mSaturationMin != this.mSharpnessMax ? -2147483640L : 0L;
            this.mProcSupports &= Integer.MAX_VALUE;
        }
    }

    @Override
    public int setExposurePriority(int i) {
        return 0;
    }

    @Override
    public int getExposurePriority() {
        return 0;
    }

    @Override
    public int getExposurePriorityDef() {
        return 0;
    }

    @Override
    public FuncMaxMinDef getExposurePriorityInfo() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExposure(int value) {
        block10: {
            if (this.isConnected() && this.checkSupportFlag(8L)) {
                this.readLock();
                try {
                    float range = this.mExposureTimeMax - this.mExposureTimeMin;
                    if (!(range > 0.0f)) break block10;
                    int exposure = (int)((float)value / 100.0f * range + (float)this.mExposureTimeMin);
                    if (exposure < this.mExposureTimeMin) {
                        exposure = this.mExposureTimeMin;
                    } else if (exposure > this.mExposureTimeMax) {
                        exposure = this.mExposureTimeMax;
                    }
                    this.mParams.set("exposure-time", exposure);
                    try {
                        Camera camera = (Camera)this.getCamera();
                        if (camera != null) {
                            camera.setParameters(this.mParams);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        return this.getExposure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExposure(int exposure) {
        if (this.isConnected() && this.checkSupportFlag(8L)) {
            this.readLock();
            try {
                float range = this.mExposureTimeMax - this.mExposureTimeMin;
                if (range > 0.0f) {
                    int n = (int)((float)(exposure - this.mExposureTimeMin) * 100.0f / range);
                    return n;
                }
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getExposure() {
        if (this.isConnected() && this.checkSupportFlag(8L)) {
            this.readLock();
            try {
                int n = this.getExposure(BuiltInCamera.as((Object)this.mParams.get("exposure-time"), this.mExposureTimeDef));
                return n;
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getExposureDef() {
        this.readLock();
        try {
            int n = this.getExposure(this.mExposureTimeDef);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public FuncMaxMinDef getExposureInfo() {
        return new FuncMaxMinDef(0, 100, this.getExposureDef(), this.getExposure());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setExposureRel(int value) {
        block10: {
            if (this.isConnected() && this.checkSupportFlag(16L)) {
                this.readLock();
                try {
                    float range = this.mExposureCompensationMax - this.mExposureCompensationMin;
                    if (!(range > 0.0f)) break block10;
                    int exposureRel = (int)((float)value / 100.0f * range + (float)this.mExposureCompensationMin);
                    if (exposureRel < this.mExposureCompensationMin) {
                        exposureRel = this.mExposureCompensationMin;
                    } else if (exposureRel > this.mExposureCompensationMax) {
                        exposureRel = this.mExposureCompensationMax;
                    }
                    this.mParams.setExposureCompensation(exposureRel);
                    try {
                        Camera camera = (Camera)this.getCamera();
                        if (camera != null) {
                            camera.setParameters(this.mParams);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        return this.getExposureRel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExposureRel(int exposureRel) {
        if (this.isConnected() && this.checkSupportFlag(16L)) {
            this.readLock();
            try {
                float range = this.mExposureCompensationMax - this.mExposureCompensationMin;
                if (range > 0.0f) {
                    int n = (int)((float)(exposureRel - this.mExposureCompensationMin) * 100.0f / range);
                    return n;
                }
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getExposureRel() {
        if (this.isConnected() && this.checkSupportFlag(16L)) {
            this.readLock();
            try {
                int n = this.getBrightness(this.mParams != null ? this.mParams.getExposureCompensation() : this.mExposureCompensationDef);
                return n;
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getExposureRelDef() {
        this.readLock();
        try {
            int n = this.getBrightness(this.mExposureCompensationDef);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public FuncMaxMinDef getExposureRelInfo() {
        return new FuncMaxMinDef(0, 100, this.getExposureRelDef(), this.getExposureRel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBrightness(int value) {
        block10: {
            if (this.isConnected() && this.checkSupportFlag(-2147483647L)) {
                this.readLock();
                try {
                    float range = this.mBrightnessMax - this.mBrightnessMin;
                    if (!(range > 0.0f)) break block10;
                    int brightness = (int)((float)value / 100.0f * range + (float)this.mBrightnessMin);
                    if (brightness < this.mBrightnessMin) {
                        brightness = this.mBrightnessMin;
                    } else if (brightness > this.mBrightnessMax) {
                        brightness = this.mBrightnessMax;
                    }
                    this.mParams.set("brightness", brightness);
                    try {
                        Camera camera = (Camera)this.getCamera();
                        if (camera != null) {
                            camera.setParameters(this.mParams);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        return this.getBrightness();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBrightness(int brightness) {
        if (this.isConnected() && this.checkSupportFlag(-2147483647L)) {
            this.readLock();
            try {
                float range = this.mBrightnessMax - this.mBrightnessMin;
                if (range > 0.0f) {
                    int n = (int)((float)(brightness - this.mBrightnessMin) * 100.0f / range);
                    return n;
                }
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getBrightness() {
        if (this.isConnected() && this.checkSupportFlag(-2147483647L)) {
            this.readLock();
            try {
                int n = this.getBrightness(BuiltInCamera.as((Object)this.mParams.get("brightness"), this.mBrightnessDef));
                return n;
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getBrightnessDef() {
        this.readLock();
        try {
            int n = this.getBrightness(this.mBrightnessDef);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public FuncMaxMinDef getBrightnessInfo() {
        return new FuncMaxMinDef(0, 100, this.getBrightnessDef(), this.getBrightness());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setContrast(int value) {
        block10: {
            if (this.isConnected() && this.checkSupportFlag(-2147483646L)) {
                this.readLock();
                try {
                    float range = this.mContrastMax - this.mContrastMin;
                    if (!(range > 0.0f)) break block10;
                    int contrast = (int)((float)value / 100.0f * range + (float)this.mContrastMin);
                    if (contrast < this.mContrastMin) {
                        contrast = this.mContrastMin;
                    } else if (contrast > this.mContrastMax) {
                        contrast = this.mContrastMax;
                    }
                    this.mParams.set("contrast", contrast);
                    try {
                        Camera camera = (Camera)this.getCamera();
                        if (camera != null) {
                            camera.setParameters(this.mParams);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        return this.getContrast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContrast(int contrast) {
        if (this.isConnected() && this.checkSupportFlag(-2147483646L)) {
            this.readLock();
            try {
                float range = this.mContrastMax - this.mContrastMin;
                if (range > 0.0f) {
                    int n = (int)((float)(contrast - this.mContrastMin) * 100.0f / range);
                    return n;
                }
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getContrast() {
        if (this.isConnected() && this.checkSupportFlag(-2147483646L)) {
            this.readLock();
            try {
                int n = this.getContrast(BuiltInCamera.as((Object)this.mParams.get("contrast"), this.mContrastDef));
                return n;
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getContrastDef() {
        this.readLock();
        try {
            int n = this.getContrast(this.mContrastDef);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public FuncMaxMinDef getContrastInfo() {
        return new FuncMaxMinDef(0, 100, this.getContrastDef(), this.getContrast());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSharpness(int value) {
        block10: {
            if (this.isConnected() && this.checkSupportFlag(-2147483632L)) {
                this.readLock();
                try {
                    float range = this.mSharpnessMax - this.mSharpnessMin;
                    if (!(range > 0.0f)) break block10;
                    int sharpness = (int)((float)value / 100.0f * range + (float)this.mSharpnessMin);
                    if (sharpness < this.mSharpnessMin) {
                        sharpness = this.mSharpnessMin;
                    } else if (sharpness > this.mSharpnessMax) {
                        sharpness = this.mSharpnessMax;
                    }
                    this.mParams.set("sharpness", sharpness);
                    try {
                        Camera camera = (Camera)this.getCamera();
                        if (camera != null) {
                            camera.setParameters(this.mParams);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        return this.getSharpness();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSharpness(int sharpness) {
        if (this.isConnected() && this.checkSupportFlag(-2147483632L)) {
            this.readLock();
            try {
                float range = this.mSharpnessMax - this.mSharpnessMin;
                if (range > 0.0f) {
                    int n = (int)((float)(sharpness - this.mSharpnessMin) * 100.0f / range);
                    return n;
                }
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getSharpness() {
        if (this.isConnected() && this.checkSupportFlag(-2147483632L)) {
            this.readLock();
            try {
                int n = this.getContrast(BuiltInCamera.as((Object)this.mParams.get("sharpness"), this.mSharpnessDef));
                return n;
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getSharpnessDef() {
        this.readLock();
        try {
            int n = this.getContrast(this.mSharpnessDef);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public FuncMaxMinDef getSharpnessInfo() {
        return new FuncMaxMinDef(0, 100, this.getSharpnessDef(), this.getSharpness());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setSaturation(int value) {
        block10: {
            if (this.isConnected() && this.checkSupportFlag(-2147483640L)) {
                this.readLock();
                try {
                    float range = this.mSaturationMax - this.mSaturationMin;
                    if (!(range > 0.0f)) break block10;
                    int saturation = (int)((float)value / 100.0f * range + (float)this.mSaturationMin);
                    if (saturation < this.mSaturationMin) {
                        saturation = this.mSaturationMin;
                    } else if (saturation > this.mSaturationMax) {
                        saturation = this.mSaturationMax;
                    }
                    this.mParams.set("saturation", saturation);
                    try {
                        Camera camera = (Camera)this.getCamera();
                        if (camera != null) {
                            camera.setParameters(this.mParams);
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
                finally {
                    this.readUnlock();
                }
            }
        }
        return this.getSaturation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSaturation(int saturation) {
        if (this.isConnected() && this.checkSupportFlag(-2147483640L)) {
            this.readLock();
            try {
                float range = this.mSaturationMax - this.mSaturationMin;
                if (range > 0.0f) {
                    int n = (int)((float)(saturation - this.mSaturationMin) * 100.0f / range);
                    return n;
                }
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getSaturation() {
        if (this.isConnected() && this.checkSupportFlag(-2147483640L)) {
            this.readLock();
            try {
                int n = this.getSaturation(BuiltInCamera.as((Object)this.mParams.get("saturation"), this.mSaturationDef));
                return n;
            }
            finally {
                this.readUnlock();
            }
        }
        return 0;
    }

    @Override
    public int getSaturationDef() {
        this.readLock();
        try {
            int n = this.getSaturation(this.mSaturationDef);
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public FuncMaxMinDef getSaturationInfo() {
        return new FuncMaxMinDef(0, 100, this.getSaturationDef(), this.getSaturation());
    }

    @NonNull
    public String toString() {
        return this.mParams != null ? "BuiltInCamera:(" + this.mParams.flatten() + ")" : super.toString();
    }
}

