/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb.uvc;

import androidx.annotation.Keep;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.usb.NativeLibLoader;
import com.serenegiant.usb.uvc.IPipeline;
import com.serenegiant.usb.uvc.IPipelineSource;
import java.nio.ByteBuffer;

@Keep
public class PipelineSource
implements IPipelineSource {
    private static final String TAG = PipelineSource.class.getSimpleName();
    protected long mNativePtr = this.nativeCreate();

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void release() {
        this.stop();
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    @Override
    public void start() throws IllegalStateException {
    }

    @Override
    public void stop() {
    }

    @Override
    public synchronized boolean isRunning() {
        return this.mNativePtr != 0L;
    }

    @Override
    public synchronized void setPipeline(IPipeline next_pipeline) throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException("already released");
        }
        this.nativeSetPipeline(this.mNativePtr, next_pipeline);
    }

    public synchronized void queueFrame(ByteBuffer frame, int size, int width, int height, long presentationTimeUs, RawFrameType raw_frame_type, int flags) throws IllegalStateException {
        int result = PipelineSource.nativeQueueFrame(this.mNativePtr, frame, size, width, height, presentationTimeUs, raw_frame_type.getValue(), flags);
        if (result != 0) {
            throw new IllegalStateException("failed to call nativeQueueFrame:err=" + result);
        }
    }

    private final native long nativeCreate();

    private final native void nativeDestroy(long var1);

    private final native int nativeSetPipeline(long var1, IPipeline var3);

    private static final native int nativeQueueFrame(long var0, ByteBuffer var2, int var3, int var4, int var5, long var6, int var8, int var9);

    static {
        NativeLibLoader.loadNative();
    }
}

