/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.BufferHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class PreviewDecoder
implements Runnable {
    private static final boolean DEBUG = false;
    private static final String TAG = PreviewDecoder.class.getSimpleName();
    private static final long TIMEOUT_USEC = 10000L;

    public static PreviewDecoder createDecoder(@Nullable Surface surface) {
        PreviewDecoder decoder = BuildCheck.isLollipop() ? new H264DecoderV21(surface) : new H264Decoder(surface);
        return decoder;
    }

    public abstract void release();

    public abstract void onFrame(ByteBuffer var1, int var2, int var3, long var4, int var6, int var7);

    public abstract void stop();

    protected static MediaFormat createOutputFormat(@NonNull String mime, ByteBuffer frame, int width, int height) {
        MediaFormat outFormat = null;
        int n = frame != null ? frame.capacity() : 0;
        try {
            if (n > 4) {
                byte[] tmp = new byte[n];
                frame.clear();
                frame.get(tmp, 0, n);
                frame.clear();
                int ix0 = BufferHelper.findAnnexB((byte[])tmp, (int)0);
                int ix1 = BufferHelper.findAnnexB((byte[])tmp, (int)(ix0 + 1));
                int ix2 = BufferHelper.findAnnexB((byte[])tmp, (int)(ix1 + 1));
                if (ix0 >= 0) {
                    outFormat = MediaFormat.createVideoFormat((String)mime, (int)width, (int)height);
                    ByteBuffer csd0 = ByteBuffer.allocateDirect(ix1 - ix0).order(ByteOrder.nativeOrder());
                    csd0.put(tmp, ix0, ix1 - ix0);
                    csd0.flip();
                    outFormat.setByteBuffer("csd-0", csd0);
                    if (ix1 > ix0) {
                        int sz = ix2 >= 0 ? ix2 - ix1 : n - ix1;
                        ByteBuffer csd1 = ByteBuffer.allocateDirect(sz).order(ByteOrder.nativeOrder());
                        csd1.put(tmp, ix1, sz);
                        csd1.flip();
                        outFormat.setByteBuffer("csd-1", csd1);
                    }
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return outFormat;
    }

    @TargetApi(value=21)
    private static class H264DecoderV21
    extends PreviewDecoder {
        private static final long VSYNC2 = 33330000L;
        private final String TAG = H264DecoderV21.class.getSimpleName();
        private final Object mSync = new Object();
        private volatile boolean mIsRunning;
        @Nullable
        private final Surface mSurface;
        private MediaCodec decoder;
        private long mOffsetPtsNs = -1L;
        private long mOffsetSysTimeNs = -1L;

        private H264DecoderV21(@Nullable Surface surface) {
            this.mSurface = surface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.decoder != null) {
                    try {
                        this.decoder.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.decoder = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            this.mIsRunning = false;
            Object object = this.mSync;
            synchronized (object) {
                this.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(ByteBuffer frame, int width, int height, long presentationTimeUs, int frame_format, int flags) {
            int sz = frame.capacity();
            Object object = this.mSync;
            synchronized (object) {
                if (this.decoder == null && this.mSurface != null) {
                    try {
                        MediaFormat format;
                        RawFrameType rawFrameType = RawFrameType.from(frame_format);
                        String mime = null;
                        switch (rawFrameType) {
                            case RAW_FRAME_H264: 
                            case RAW_FRAME_FRAME_H264: {
                                mime = "video/avc";
                                format = H264DecoderV21.createOutputFormat(mime, frame, width, height);
                                break;
                            }
                            case RAW_FRAME_VP8: 
                            case RAW_FRAME_FRAME_VP8: {
                                mime = "video/x-vnd.on2.vp8";
                                format = H264DecoderV21.createOutputFormat(mime, frame, width, height);
                                break;
                            }
                            default: {
                                format = null;
                            }
                        }
                        if (format != null) {
                            this.decoder = MediaCodec.createDecoderByType((String)mime);
                            this.decoder.configure(format, this.mSurface, null, 0);
                            this.decoder.start();
                            this.mIsRunning = true;
                            new Thread((Runnable)this, this.TAG).start();
                        }
                    }
                    catch (Exception e) {
                        this.decoder = null;
                    }
                }
                if (this.decoder != null && this.mSurface != null) {
                    try {
                        int inputBufIndex = this.decoder.dequeueInputBuffer(10000L);
                        if (inputBufIndex == -1) {
                            // empty if block
                        }
                        if (inputBufIndex >= 0) {
                            ByteBuffer in = this.decoder.getInputBuffer(inputBufIndex);
                            in.clear();
                            frame.clear();
                            in.put(frame);
                            this.decoder.queueInputBuffer(inputBufIndex, 0, sz, presentationTimeUs, 0);
                            this.mSync.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)this.TAG, (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MediaCodec.BufferInfo videoBufferInfo = new MediaCodec.BufferInfo();
            while (this.mIsRunning) {
                try {
                    Object object = this.mSync;
                    synchronized (object) {
                        if (this.decoder == null) {
                            try {
                                this.mSync.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        int decoderStatus = this.decoder.dequeueOutputBuffer(videoBufferInfo, 10000L);
                        if (decoderStatus == -1) {
                            try {
                                this.mSync.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (decoderStatus != -3) {
                            if (decoderStatus == -2) {
                                MediaFormat mediaFormat = this.decoder.getOutputFormat();
                            } else {
                                if (decoderStatus < 0) {
                                    throw new RuntimeException("unexpected result from video decoder.dequeueOutputBuffer: " + decoderStatus);
                                }
                                this.decoder.releaseOutputBuffer(decoderStatus, this.adjustPresentationTimeNs(videoBufferInfo.presentationTimeUs));
                                if ((videoBufferInfo.flags & 4) != 0) {
                                    this.mIsRunning = false;
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.w((String)this.TAG, (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long adjustPresentationTimeNs(long presentationTimeUs) {
            long presentationTimeNs = presentationTimeUs * 1000L;
            if (this.mOffsetSysTimeNs <= 0L) {
                this.mOffsetSysTimeNs = System.nanoTime();
                this.mOffsetPtsNs = presentationTimeNs;
            } else {
                long base = presentationTimeNs - this.mOffsetPtsNs + this.mOffsetSysTimeNs - 33330000L;
                long t = base - System.nanoTime();
                while (this.mIsRunning && t > 0L) {
                    if (t > 20000000L) {
                        t >>= 1;
                    }
                    Object object = this.mSync;
                    synchronized (object) {
                        try {
                            this.mSync.wait(t / 1000000L, (int)(t % 1000000L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    t = base - System.nanoTime();
                }
            }
            return System.nanoTime() + 33330000L;
        }
    }

    private static class H264Decoder
    extends PreviewDecoder {
        private final String TAG = H264Decoder.class.getSimpleName();
        private final Object mSync = new Object();
        private volatile boolean mIsRunning;
        @Nullable
        private final Surface mSurface;
        private MediaCodec decoder;
        private ByteBuffer[] mVideoInputBuffers;
        private ByteBuffer[] mVideoOutputBuffers;
        private long mOffsetPtsNs = -1L;
        private long mOffsetSysTimeNs = -1L;

        private H264Decoder(@Nullable Surface surface) {
            this.mSurface = surface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.decoder != null) {
                    try {
                        this.decoder.release();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.decoder = null;
                }
                this.mVideoInputBuffers = null;
                this.mVideoOutputBuffers = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            this.mIsRunning = false;
            Object object = this.mSync;
            synchronized (object) {
                this.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(ByteBuffer frame, int width, int height, long presentationTimeUs, int frame_format, int flags) {
            int sz = frame.capacity();
            Object object = this.mSync;
            synchronized (object) {
                if (this.decoder == null && this.mSurface != null) {
                    try {
                        MediaFormat format;
                        String mime = null;
                        RawFrameType rawFrameType = RawFrameType.from(frame_format);
                        switch (rawFrameType) {
                            case RAW_FRAME_H264: 
                            case RAW_FRAME_FRAME_H264: {
                                mime = "video/avc";
                                format = H264Decoder.createOutputFormat(mime, frame, width, height);
                                break;
                            }
                            case RAW_FRAME_VP8: 
                            case RAW_FRAME_FRAME_VP8: {
                                mime = "video/x-vnd.on2.vp8";
                                format = H264Decoder.createOutputFormat(mime, frame, width, height);
                                break;
                            }
                            default: {
                                format = null;
                            }
                        }
                        if (format != null) {
                            this.decoder = MediaCodec.createDecoderByType((String)mime);
                            this.decoder.configure(format, this.mSurface, null, 0);
                            this.decoder.start();
                            this.mVideoInputBuffers = this.decoder.getInputBuffers();
                            this.mVideoOutputBuffers = this.decoder.getOutputBuffers();
                            this.mIsRunning = true;
                            new Thread((Runnable)this, this.TAG).start();
                        }
                    }
                    catch (Exception e) {
                        this.decoder = null;
                    }
                }
                if (this.decoder != null && this.mSurface != null) {
                    try {
                        int inputBufIndex = this.decoder.dequeueInputBuffer(10000L);
                        if (inputBufIndex == -1) {
                            // empty if block
                        }
                        if (inputBufIndex >= 0) {
                            ByteBuffer in = this.mVideoInputBuffers[inputBufIndex];
                            in.clear();
                            frame.clear();
                            in.put(frame);
                            this.decoder.queueInputBuffer(inputBufIndex, 0, sz, presentationTimeUs, 0);
                            this.mSync.notifyAll();
                        }
                    }
                    catch (Exception e) {
                        Log.w((String)this.TAG, (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MediaCodec.BufferInfo videoBufferInfo = new MediaCodec.BufferInfo();
            while (this.mIsRunning) {
                try {
                    Object object = this.mSync;
                    synchronized (object) {
                        if (this.decoder == null) {
                            try {
                                this.mSync.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        int decoderStatus = this.decoder.dequeueOutputBuffer(videoBufferInfo, 10000L);
                        if (decoderStatus == -1) {
                            try {
                                this.mSync.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (decoderStatus == -3) {
                            this.mVideoOutputBuffers = this.decoder.getOutputBuffers();
                        } else if (decoderStatus == -2) {
                            MediaFormat e = this.decoder.getOutputFormat();
                        } else {
                            boolean doRender;
                            if (decoderStatus < 0) {
                                throw new RuntimeException("unexpected result from video decoder.dequeueOutputBuffer: " + decoderStatus);
                            }
                            boolean bl = doRender = videoBufferInfo.size > 0;
                            if (doRender) {
                                this.adjustPresentationTime(videoBufferInfo.presentationTimeUs);
                            }
                            this.decoder.releaseOutputBuffer(decoderStatus, doRender);
                            if ((videoBufferInfo.flags & 4) != 0) {
                                this.mIsRunning = false;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Log.w((String)this.TAG, (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustPresentationTime(long presentationTimeUs) {
            long presentationTimeNs = presentationTimeUs * 1000L;
            if (this.mOffsetSysTimeNs <= 0L) {
                this.mOffsetSysTimeNs = System.nanoTime();
                this.mOffsetPtsNs = presentationTimeNs;
            } else {
                long base = presentationTimeNs - this.mOffsetPtsNs + this.mOffsetSysTimeNs;
                long t = base - System.nanoTime();
                while (this.mIsRunning && t > 0L) {
                    if (t > 20000000L) {
                        t >>= 1;
                    }
                    Object object = this.mSync;
                    synchronized (object) {
                        try {
                            this.mSync.wait(t / 1000000L, (int)(t % 1000000L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    t = base - System.nanoTime();
                }
            }
        }
    }
}

