/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.camera.IFrameCallback;
import com.serenegiant.camera.RawFrameType;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.FakeVideoEncoder;
import com.serenegiant.media.IRecorder;
import com.serenegiant.usb.uvc.FrameCallbackPipeline;
import com.serenegiant.usb.uvc.IPipeline;
import java.nio.ByteBuffer;

public class FakePipelineVideoEncoder
extends FakeVideoEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = FakePipelineVideoEncoder.class.getSimpleName();
    private FrameCallbackPipeline mPipeline;
    private final RawFrameType mRawFrameType;
    private final int mRawFrameTypeValue;
    private long startTimeNs = -1L;
    private int cnt = 0;
    private final IFrameCallback mFrameCallback = new IFrameCallback(){

        @Override
        public void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int raw_frame_t, int flags) {
            if (FakePipelineVideoEncoder.this.mRawFrameTypeValue == raw_frame_t) {
                FakePipelineVideoEncoder.this.onFrame(frame, width, height, presentationTimeUs, raw_frame_t, flags);
            }
        }
    };

    public FakePipelineVideoEncoder(IRecorder recorder, EncoderListener listener, RawFrameType rawFrameType) {
        this(recorder, listener, 2048, rawFrameType, 16, 14);
    }

    public FakePipelineVideoEncoder(IRecorder recorder, EncoderListener listener, RawFrameType rawFrameType, int maxPoolSz, int maxQueueSz) {
        this(recorder, listener, 2048, rawFrameType, maxPoolSz, maxQueueSz);
    }

    public FakePipelineVideoEncoder(IRecorder recorder, EncoderListener listener, int defaultFrameSz, RawFrameType rawFrameType, int maxPoolSz, int maxQueueSz) {
        super("video/avc", recorder, listener, defaultFrameSz);
        this.mPipeline = new FrameCallbackPipeline();
        this.mRawFrameType = rawFrameType;
        this.mRawFrameTypeValue = rawFrameType.getValue();
    }

    public void release() {
        try {
            if (this.mPipeline != null) {
                this.stop();
                this.mPipeline.release();
                this.mPipeline = null;
            }
        }
        finally {
            super.release();
        }
    }

    public void start() {
        if (this.mPipeline == null) {
            throw new IllegalStateException("already released");
        }
        super.start();
        this.mPipeline.setFrameCallback(this.mFrameCallback, this.mRawFrameType);
        this.mPipeline.start();
    }

    public void stop() {
        if (this.mPipeline != null) {
            try {
                if (this.mPipeline.isRunning()) {
                    this.mPipeline.stop();
                }
                this.mPipeline.setFrameCallback(null, RawFrameType.RAW_FRAME_UNKNOWN);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        super.stop();
    }

    public boolean queueFrame(@Nullable ByteBuffer buffer, int offset, int size, long presentationTimeUs, int flags) throws IllegalStateException {
        this.getInputPTSUs();
        return super.queueFrame(buffer, offset, size, presentationTimeUs, flags);
    }

    protected void onFrame(@NonNull ByteBuffer frame, int width, int height, long presentationTimeUs, int raw_frame_type, int flags) {
        this.queueFrame(frame, 0, frame.limit(), presentationTimeUs, flags);
        this.frameAvailableSoon();
    }

    public IPipeline getPipeline() {
        return this.mPipeline;
    }
}

