/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import androidx.recyclerview.widget.RecyclerView;
import com.serenegiant.common.R;
import com.serenegiant.system.SAFUtils;
import com.serenegiant.utils.HandlerThreadHandler;
import com.serenegiant.view.ViewUtils;
import com.serenegiant.widget.Dividable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

@TargetApi(value=21)
public class DocumentTreeRecyclerAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final boolean DEBUG = false;
    private static final String TAG = DocumentTreeRecyclerAdapter.class.getSimpleName();
    private static final long DELAY_MILLIS = 100L;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final Context mContext;
    private final int mLayoutRes;
    @NonNull
    private final DocumentFile mRoot;
    @NonNull
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    @NonNull
    private final List<FileInfo> mItems = new ArrayList<FileInfo>();
    @NonNull
    private final List<FileInfo> mWork = new ArrayList<FileInfo>();
    @Nullable
    private LayoutInflater mLayoutInflater;
    @Nullable
    private RecyclerView mRecycleView;
    @Nullable
    private DocumentTreeRecyclerAdapterListener mListener;
    @Nullable
    private Handler mAsyncHandler;
    @Nullable
    private DocumentFile mCurrentDir;
    @Nullable
    private String[] mExtFilter = null;
    private final SAFUtils.FileFilter mFileFilter = new SAFUtils.FileFilter(){

        @Override
        public boolean accept(@NonNull DocumentFile file) {
            if (DocumentTreeRecyclerAdapter.this.mExtFilter == null) {
                return true;
            }
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase(Locale.getDefault());
            for (String ext : DocumentTreeRecyclerAdapter.this.mExtFilter) {
                if (!name.endsWith("." + ext)) continue;
                return true;
            }
            return false;
        }
    };
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(final View v) {
            if (DocumentTreeRecyclerAdapter.this.mRecycleView != null && DocumentTreeRecyclerAdapter.this.mRecycleView.isEnabled()) {
                Object pos;
                if (v instanceof Checkable) {
                    ((Checkable)v).setChecked(true);
                    DocumentTreeRecyclerAdapter.this.mRecycleView.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            ((Checkable)v).setChecked(false);
                        }
                    }, 100L);
                }
                if (DocumentTreeRecyclerAdapter.this.mListener != null && (pos = v.getTag(R.id.position)) instanceof Integer) {
                    try {
                        DocumentTreeRecyclerAdapter.this.mListener.onItemClick(DocumentTreeRecyclerAdapter.this, v, DocumentTreeRecyclerAdapter.this.getItem((Integer)pos));
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            } else {
                Log.w((String)TAG, (String)("onClick:mRecycleView=" + DocumentTreeRecyclerAdapter.this.mRecycleView));
            }
        }
    };
    private final View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            Object pos;
            if (DocumentTreeRecyclerAdapter.this.mRecycleView != null && DocumentTreeRecyclerAdapter.this.mRecycleView.isEnabled() && DocumentTreeRecyclerAdapter.this.mListener != null && (pos = v.getTag(R.id.position)) instanceof Integer) {
                try {
                    return DocumentTreeRecyclerAdapter.this.mListener.onItemLongClick(DocumentTreeRecyclerAdapter.this, v, DocumentTreeRecyclerAdapter.this.getItem((Integer)pos));
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
            }
            return false;
        }
    };

    public DocumentTreeRecyclerAdapter(@NonNull Context context, @LayoutRes int layoutResId, @NonNull DocumentFile root) {
        if (root == null || !root.isDirectory()) {
            throw new IllegalArgumentException("root should be a directory!");
        }
        this.mContext = context;
        this.mLayoutRes = layoutResId;
        this.mRoot = root;
        this.mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        this.internalChangeDir(root);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecycleView = recyclerView;
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mRecycleView = null;
        super.onDetachedFromRecyclerView(recyclerView);
    }

    @NonNull
    public final ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = LayoutInflater.from((Context)this.mContext);
        }
        View view = this.mLayoutInflater.inflate(this.mLayoutRes, parent, false);
        view.setOnClickListener(this.mOnClickListener);
        view.setOnLongClickListener(this.mOnLongClickListener);
        return this.onCreateViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        holder.setItem(position, this.getFileInfo(position));
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public DocumentFile getItem(int position) throws IndexOutOfBoundsException {
        return this.getFileInfo(position).getFile();
    }

    public void setListener(@Nullable DocumentTreeRecyclerAdapterListener listener) {
        this.mListener = listener;
    }

    public void changeDir(@NonNull DocumentFile newDir) throws IOException {
        if (!newDir.isDirectory()) {
            throw new IOException(String.format(Locale.US, "%s is not a directory/could not read", newDir.getUri()));
        }
        this.internalChangeDir(newDir);
        this.notifyDataSetChanged();
    }

    public void setExtFilter(@Nullable String extString) {
        if (!TextUtils.isEmpty((CharSequence)extString)) {
            Pattern p = Pattern.compile("[;\\s]+");
            this.mExtFilter = p.split(extString.toLowerCase(Locale.getDefault()));
        } else {
            this.mExtFilter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.mItems;
        synchronized (object) {
            this.mItems.clear();
        }
        this.mWork.clear();
        object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler != null) {
                this.mAsyncHandler.removeCallbacksAndMessages(null);
                try {
                    this.mAsyncHandler.getLooper().quit();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mAsyncHandler = null;
            }
        }
    }

    protected ViewHolder onCreateViewHolder(View itemView) {
        return new ViewHolder(itemView);
    }

    @NonNull
    protected FileInfo getFileInfo(int position) throws IndexOutOfBoundsException {
        return this.mItems.get(position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalChangeDir(@NonNull DocumentFile newDir) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mAsyncHandler == null) {
                throw new IllegalStateException("already released");
            }
            this.mAsyncHandler.post((Runnable)new ChangeDirTask(newDir));
        }
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder
    implements Dividable {
        TextView mTitleTv;
        private FileInfo mItem;

        public ViewHolder(View view) {
            super(view);
            this.mTitleTv = ViewUtils.findTitleView(view);
            if (this.mTitleTv == null) {
                throw new IllegalArgumentException("TextView not found");
            }
        }

        @SuppressLint(value={"SetTextI18n"})
        private void setItem(int position, FileInfo item) {
            this.mItem = item;
            this.itemView.setTag(R.id.position, (Object)position);
            if (this.mTitleTv != null) {
                if (item.isDirectory() && !item.isUpNavigation()) {
                    this.mTitleTv.setText((CharSequence)(item.getName() + "/"));
                } else {
                    this.mTitleTv.setText((CharSequence)item.getName());
                }
            }
        }

        @Nullable
        public FileInfo getItem() {
            return this.mItem;
        }

        public void setEnable(boolean enable) {
            this.itemView.setEnabled(enable);
        }

        @Override
        public void hasDivider(boolean hasDivider) {
            if (this.itemView instanceof Dividable) {
                ((Dividable)this.itemView).hasDivider(hasDivider);
            } else {
                this.itemView.setTag(R.id.has_divider, (Object)hasDivider);
            }
        }

        @Override
        public boolean hasDivider() {
            if (this.itemView instanceof Dividable) {
                return ((Dividable)this.itemView).hasDivider();
            }
            Boolean b = (Boolean)this.itemView.getTag(R.id.has_divider);
            return b != null && b != false;
        }
    }

    protected static class FileInfo
    implements Comparable<FileInfo> {
        private final Locale mLocale = Locale.getDefault();
        @NonNull
        private final DocumentFile mFile;
        private final boolean mIsUpNavigation;
        private boolean isSelected = false;

        public FileInfo(@NonNull DocumentFile file, boolean upNavigation) {
            this.mFile = file;
            this.mIsUpNavigation = upNavigation;
        }

        @NonNull
        public DocumentFile getFile() {
            return this.mFile;
        }

        @NonNull
        public Uri getUri() {
            return this.mFile.getUri();
        }

        @NonNull
        public String getName() {
            String name = this.mFile.getName();
            return this.mIsUpNavigation ? ".." : (TextUtils.isEmpty((CharSequence)name) ? "" : name);
        }

        public boolean isDirectory() {
            return this.mFile.isDirectory();
        }

        public boolean canRead() {
            return this.mFile.canRead();
        }

        public boolean canWrite() {
            return this.mFile.canWrite();
        }

        public boolean isUpNavigation() {
            return this.mIsUpNavigation;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void select(boolean select) {
            this.isSelected = select;
        }

        @Override
        public int compareTo(@NonNull FileInfo other) {
            if (this.mFile.isDirectory() && !other.getFile().isDirectory()) {
                return -1;
            }
            if (!this.mFile.isDirectory() && other.getFile().isDirectory()) {
                return 1;
            }
            return this.mFile.getName().toLowerCase(this.mLocale).compareTo(other.getName().toLowerCase(this.mLocale));
        }

        @NonNull
        public String toString() {
            return "FileInfo{file=" + this.mFile.getUri() + ",mIsUpNavigation=" + this.mIsUpNavigation + ",isSelected=" + this.isSelected + '}';
        }
    }

    private class ChangeDirTask
    implements Runnable {
        private final DocumentFile newDir;

        public ChangeDirTask(DocumentFile newDir) {
            this.newDir = newDir;
        }

        @Override
        public void run() {
            DocumentFile parent;
            DocumentTreeRecyclerAdapter.this.mWork.clear();
            List<DocumentFile> fileList = SAFUtils.listFiles(this.newDir, DocumentTreeRecyclerAdapter.this.mFileFilter);
            for (DocumentFile file : fileList) {
                DocumentTreeRecyclerAdapter.this.mWork.add(new FileInfo(file, false));
            }
            Collections.sort(DocumentTreeRecyclerAdapter.this.mWork);
            if (!DocumentTreeRecyclerAdapter.this.mRoot.equals(this.newDir) && (parent = this.newDir.getParentFile()) != null) {
                DocumentTreeRecyclerAdapter.this.mWork.add(0, new FileInfo(parent, true));
            }
            DocumentTreeRecyclerAdapter.this.mUIHandler.postDelayed(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List list = DocumentTreeRecyclerAdapter.this.mItems;
                    synchronized (list) {
                        DocumentTreeRecyclerAdapter.this.mCurrentDir = ChangeDirTask.this.newDir;
                        DocumentTreeRecyclerAdapter.this.mItems.clear();
                        DocumentTreeRecyclerAdapter.this.mItems.addAll(DocumentTreeRecyclerAdapter.this.mWork);
                    }
                    DocumentTreeRecyclerAdapter.this.mWork.clear();
                    DocumentTreeRecyclerAdapter.this.notifyDataSetChanged();
                }
            }, 100L);
        }
    }

    public static interface DocumentTreeRecyclerAdapterListener {
        public void onItemClick(@NonNull RecyclerView.Adapter<?> var1, @NonNull View var2, @NonNull DocumentFile var3);

        public boolean onItemLongClick(@NonNull RecyclerView.Adapter<?> var1, @NonNull View var2, @NonNull DocumentFile var3);
    }
}

