/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.view;

import android.graphics.Matrix;
import android.graphics.PointF;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.graphics.MatrixUtils;
import com.serenegiant.view.IViewTransformer;

public abstract class ViewTransformer
implements IViewTransformer {
    private static final boolean DEBUG = false;
    private static final String TAG = ViewTransformer.class.getSimpleName();
    @NonNull
    private final View mTargetView;
    @NonNull
    protected final Matrix mDefaultTransform = new Matrix();
    @NonNull
    protected final Matrix mTransform = new Matrix();
    private final Matrix mWork = new Matrix();
    private final float[] workArray = new float[9];
    private float mCurrentTransX;
    private float mCurrentTransY;
    private float mCurrentScaleX;
    private float mCurrentScaleY;
    private float mCurrentRotate;

    public ViewTransformer(@NonNull View view) {
        this.mTargetView = view;
        this.updateTransform(true);
    }

    @NonNull
    public View getTargetView() {
        return this.mTargetView;
    }

    @Override
    @NonNull
    public ViewTransformer setTransform(@Nullable Matrix transform) {
        if (this.mTransform != transform) {
            this.mTransform.set(transform);
        }
        this.internalSetTransform(this.mTransform);
        this.calcValues(this.mTransform);
        return this;
    }

    @Override
    @NonNull
    public Matrix getTransform(@Nullable Matrix transform) {
        if (transform != null) {
            transform.set(this.mTransform);
            return transform;
        }
        return new Matrix(this.mTransform);
    }

    @Override
    @NonNull
    public ViewTransformer updateTransform(boolean saveAsDefault) {
        this.internalGetTransform(this.mTransform);
        if (saveAsDefault) {
            this.setDefault(this.mTransform);
            this.resetValues();
        } else {
            this.calcValues(this.mTransform);
        }
        return this;
    }

    @Override
    @NonNull
    public ViewTransformer setDefault(@Nullable Matrix transform) {
        if (this.mDefaultTransform != transform) {
            this.mDefaultTransform.set(transform);
        }
        return this;
    }

    @Override
    @NonNull
    public ViewTransformer reset() {
        this.setTransform(this.mDefaultTransform);
        return this;
    }

    public ViewTransformer setTranslate(float x, float y) {
        return this.setTransform(x, y, this.mCurrentScaleX, this.mCurrentScaleY, this.mCurrentRotate);
    }

    public ViewTransformer translate(float dx, float dy) {
        return this.setTransform(this.mCurrentTransX + dx, this.mCurrentTransY + dy, this.mCurrentScaleX, this.mCurrentScaleY, this.mCurrentRotate);
    }

    public PointF getTranslate(@Nullable PointF tr) {
        if (tr != null) {
            tr.set(this.mCurrentTransX, this.mCurrentTransY);
            return tr;
        }
        return new PointF(this.mCurrentTransX, this.mCurrentTransY);
    }

    public float getTranslateX() {
        return this.mCurrentTransX;
    }

    public float getTranslateY() {
        return this.mCurrentTransY;
    }

    public ViewTransformer setScale(float scaleX, float scaleY) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, scaleX, scaleY, this.mCurrentRotate);
    }

    public ViewTransformer setScale(float scale) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, scale, scale, this.mCurrentRotate);
    }

    public ViewTransformer scale(float scaleX, float scaleY) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX * scaleX, this.mCurrentScaleY * scaleY, this.mCurrentRotate);
    }

    public ViewTransformer scale(float scale) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX * scale, this.mCurrentScaleY * scale, this.mCurrentRotate);
    }

    public ViewTransformer scale(float scaleX, float scaleY, float pivotX, float pivotY) {
        this.mTransform.postScale(scaleX, scaleY, pivotX, pivotY);
        this.internalSetTransform(this.mTransform);
        this.calcValues(this.mTransform);
        return this;
    }

    public float getScaleX() {
        return this.mCurrentScaleX;
    }

    public float getScaleY() {
        return this.mCurrentScaleY;
    }

    public float getScale() {
        return Math.min(this.mCurrentScaleX, this.mCurrentScaleY);
    }

    public ViewTransformer setRotate(float degrees) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX, this.mCurrentScaleY, degrees);
    }

    public ViewTransformer rotate(float degrees) {
        return this.setTransform(this.mCurrentTransX, this.mCurrentTransY, this.mCurrentScaleX, this.mCurrentScaleY, this.mCurrentRotate + degrees);
    }

    public ViewTransformer rotate(float degrees, float pivotX, float pivotY) {
        this.mTransform.postRotate(degrees, pivotX, pivotY);
        this.internalSetTransform(this.mTransform);
        this.calcValues(this.mTransform);
        return this;
    }

    public float getRotation() {
        return this.mCurrentRotate;
    }

    public void mapPoints(@NonNull float[] points) {
        this.mTransform.mapPoints(points);
    }

    public void mapPoints(@NonNull float[] dst, @NonNull float[] src) {
        this.mTransform.mapPoints(dst, src);
    }

    private void internalSetTransform(@Nullable Matrix transform) {
        this.setTransform(this.mTargetView, transform);
    }

    protected abstract void setTransform(@NonNull View var1, @Nullable Matrix var2);

    @NonNull
    private Matrix internalGetTransform(@Nullable Matrix transform) {
        Matrix result = this.getTransform(this.mTargetView, transform);
        if (result != transform && transform != null) {
            transform.set(result);
        }
        return result;
    }

    @NonNull
    protected abstract Matrix getTransform(@NonNull View var1, @Nullable Matrix var2);

    protected ViewTransformer setTransform(float transX, float transY, float scaleX, float scaleY, float degrees) {
        if (this.mCurrentTransX != transX || this.mCurrentTransY != transY || this.mCurrentScaleX != scaleX || this.mCurrentScaleY != scaleY || this.mCurrentRotate != degrees) {
            this.mCurrentScaleX = scaleX;
            this.mCurrentScaleY = scaleY;
            this.mCurrentTransX = transX;
            this.mCurrentTransY = transY;
            this.mCurrentRotate = degrees;
            if (degrees != Float.MAX_VALUE) {
                while (this.mCurrentRotate > 360.0f) {
                    this.mCurrentRotate -= 360.0f;
                }
                while (this.mCurrentRotate < -360.0f) {
                    this.mCurrentRotate += 360.0f;
                }
            }
            int w2 = this.mTargetView.getWidth() >> 1;
            int h2 = this.mTargetView.getHeight() >> 1;
            this.mTransform.set(this.mDefaultTransform);
            this.mTransform.postTranslate(transX, transY);
            this.mTransform.postScale(scaleX, scaleY, (float)w2, (float)h2);
            if (degrees != Float.MAX_VALUE) {
                this.mTransform.postRotate(this.mCurrentRotate, (float)w2, (float)h2);
            }
            this.internalSetTransform(this.mTransform);
        }
        return this;
    }

    protected void calcValues(@NonNull Matrix transform) {
        this.mTransform.getValues(this.workArray);
        this.mCurrentTransX = this.workArray[2];
        this.mCurrentTransY = this.workArray[5];
        this.mCurrentScaleX = this.workArray[0];
        this.mCurrentScaleY = MatrixUtils.getScale(this.workArray);
        this.mCurrentRotate = MatrixUtils.getRotate(this.workArray);
    }

    protected void resetValues() {
        this.mCurrentTransY = 0.0f;
        this.mCurrentTransX = 0.0f;
        this.mCurrentScaleY = 1.0f;
        this.mCurrentScaleX = 1.0f;
        this.mCurrentRotate = 0.0f;
    }
}

