/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.SAFUtils;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;

public class FileUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = FileUtils.class.getSimpleName();
    public static String DIR_NAME;
    private static final SimpleDateFormat sDateTimeFormat;
    private static final SimpleDateFormat sTimeFormat;
    public static float FREE_RATIO;
    public static float FREE_SIZE_OFFSET;
    public static float FREE_SIZE;
    public static float FREE_SIZE_MINUTE;
    public static long CHECK_INTERVAL;

    private FileUtils() {
    }

    @NonNull
    public static String getDirName() {
        return TextUtils.isEmpty((CharSequence)DIR_NAME) ? "Serenegiant" : DIR_NAME;
    }

    @Deprecated
    @Nullable
    public static final File getCaptureFile(@NonNull Context context, String type, String ext, int saveTreeId) {
        return FileUtils.getCaptureFile(context, type, null, ext, saveTreeId);
    }

    @Nullable
    public static final File getCaptureFile(@NonNull Context context, String type, String ext) {
        return FileUtils.getCaptureFile(context, type, null, ext);
    }

    @Deprecated
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final File getCaptureFile(@NonNull Context context, String type, String prefix, String ext, int saveTreeId) {
        File dir;
        File result = null;
        String file_name = (TextUtils.isEmpty((CharSequence)prefix) ? FileUtils.getDateTimeString() : prefix + FileUtils.getDateTimeString()) + ext;
        if (BuildCheck.isAPI21() && saveTreeId > 0 && SAFUtils.hasPermission(context, saveTreeId)) {
            try {
                dir = SAFUtils.getDir(context, saveTreeId, null);
                String pathString = UriHelper.getPath(context, dir.getUri());
                if (!TextUtils.isEmpty((CharSequence)pathString)) {
                    result = new File(pathString);
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            if (result == null || !result.canWrite()) {
                Log.w((String)TAG, (String)"\u306a\u3093\u3067\u304b\u66f8\u304d\u8fbc\u3081\u3093");
                result = null;
            }
            if (result != null) {
                result = new File(result, FileUtils.getDirName());
            }
        }
        if (result == null && (dir = FileUtils.getCaptureDir(context, type)) != null) {
            dir.mkdirs();
            if (dir.canWrite()) {
                result = dir;
            }
        }
        if (result != null) {
            result = new File(result, file_name);
        }
        return result;
    }

    @Nullable
    public static final File getCaptureFile(@NonNull Context context, String type, String prefix, String ext) {
        File result = null;
        String file_name = (TextUtils.isEmpty((CharSequence)prefix) ? FileUtils.getDateTimeString() : prefix + FileUtils.getDateTimeString()) + ext;
        File dir = FileUtils.getCaptureDir(context, type);
        if (dir != null) {
            dir.mkdirs();
            if (dir.canWrite()) {
                result = dir;
            }
        }
        if (result != null) {
            result = new File(result, file_name);
        }
        return result;
    }

    @Deprecated
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static final File getCaptureDir(@NonNull Context context, @NonNull String type, int saveTreeId) {
        Object dir;
        File result = null;
        if (BuildCheck.isAPI21() && saveTreeId != 0 && SAFUtils.hasPermission(context, saveTreeId)) {
            try {
                dir = SAFUtils.getDir(context, saveTreeId, null);
                String pathString = UriHelper.getPath(context, dir.getUri());
                if (!TextUtils.isEmpty((CharSequence)pathString)) {
                    result = new File(pathString);
                }
            }
            catch (IOException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        if (!UriHelper.isStandardDirectory(type)) {
            throw new IllegalArgumentException(type + " is not a standard directory name!");
        }
        dir = result != null ? new File(result, FileUtils.getDirName()) : new File(Environment.getExternalStoragePublicDirectory((String)type), FileUtils.getDirName());
        ((File)dir).mkdirs();
        if (((File)dir).canWrite()) {
            return dir;
        }
        return null;
    }

    @Nullable
    public static File getCaptureDir(@NonNull Context context, @NonNull String type) {
        if (!UriHelper.isStandardDirectory(type)) {
            throw new IllegalArgumentException(type + " is not a standard directory name!");
        }
        String dirName = FileUtils.getDirName();
        File dir = Environment.getExternalStoragePublicDirectory((String)type);
        if (dir.canWrite()) {
            dir.mkdirs();
        }
        if (!TextUtils.isEmpty((CharSequence)dirName)) {
            boolean canWrite = dir.canWrite();
            dir = new File(dir, dirName);
            if (canWrite) {
                dir.mkdirs();
            }
        }
        return dir;
    }

    public static final String getDateTimeString() {
        GregorianCalendar now = new GregorianCalendar();
        return sDateTimeFormat.format(now.getTime());
    }

    public static final String getTimeString() {
        GregorianCalendar now = new GregorianCalendar();
        return sTimeFormat.format(now.getTime());
    }

    @Deprecated
    public static final boolean checkFreeSpace(Context context, long max_duration, long startTime, int saveTreeId) {
        if (context == null) {
            return false;
        }
        return FileUtils.checkFreeSpace(context, FREE_RATIO, max_duration > 0L ? (float)(max_duration - (System.currentTimeMillis() - startTime)) / 60000.0f * FREE_SIZE_MINUTE + FREE_SIZE_OFFSET : FREE_SIZE, saveTreeId);
    }

    @Deprecated
    public static final boolean checkFreeSpace(Context context, float ratio, float minFree, int saveTreeId) {
        if (context == null) {
            return false;
        }
        boolean result = false;
        try {
            File dir = FileUtils.getCaptureDir(context, Environment.DIRECTORY_DCIM, saveTreeId);
            if (dir != null) {
                float freeSpace;
                float f = freeSpace = dir.canWrite() ? (float)dir.getUsableSpace() : 0.0f;
                if (dir.getTotalSpace() > 0L) {
                    result = freeSpace / (float)dir.getTotalSpace() > ratio || freeSpace > minFree;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)"checkFreeSpace:", (Throwable)e);
        }
        return result;
    }

    @Deprecated
    @SuppressLint(value={"UsableSpace"})
    public static final long getAvailableFreeSpace(Context context, String type, int saveTreeId) {
        File dir;
        long result = 0L;
        if (context != null && (dir = FileUtils.getCaptureDir(context, type, saveTreeId)) != null) {
            result = dir.canWrite() ? dir.getUsableSpace() : 0L;
        }
        return result;
    }

    @Deprecated
    public static final float getFreeRatio(Context context, String type, int saveTreeId) {
        File dir;
        if (context != null && (dir = FileUtils.getCaptureDir(context, type, saveTreeId)) != null) {
            float freeSpace;
            float f = freeSpace = dir.canWrite() ? (float)dir.getUsableSpace() : 0.0f;
            if (dir.getTotalSpace() > 0L) {
                return freeSpace / (float)dir.getTotalSpace();
            }
        }
        return 0.0f;
    }

    public static final String removeFileExtension(String path) {
        int ix;
        int n = ix = !TextUtils.isEmpty((CharSequence)path) ? path.lastIndexOf(".") : -1;
        if (ix > 0) {
            return path.substring(0, ix);
        }
        return path;
    }

    public static final String replaceFileExtension(String path, @NonNull String newExt) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            int ix = path.lastIndexOf(".");
            if (ix > 0) {
                return path.substring(0, ix) + newExt;
            }
            return path + newExt;
        }
        return path;
    }

    @NonNull
    public static String getExt(@NonNull String path) {
        int ix;
        if (!TextUtils.isEmpty((CharSequence)path) && (ix = path.lastIndexOf(".")) > 0) {
            return path.substring(ix + 1);
        }
        return "";
    }

    public static boolean hasExt(@NonNull String path) {
        String ext = FileUtils.getExt(path);
        return !TextUtils.isEmpty((CharSequence)ext);
    }

    public static String getDisplayName(@NonNull String path) {
        File file = new File(path);
        return FileUtils.removeFileExtension(file.getName());
    }

    public static void deleteAll(@NonNull File path) throws IOException {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (files == null) {
                throw new IllegalArgumentException("not a directory:" + path);
            }
            if (files.length > 0) {
                for (File file : files) {
                    FileUtils.deleteAll(file);
                }
            }
            if (!path.delete()) {
                throw new IOException("failed to delete directory:" + path);
            }
        } else if (!path.delete()) {
            throw new IOException("failed to delete file:" + path);
        }
    }

    static {
        sDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.US);
        sTimeFormat = new SimpleDateFormat("HH-mm-ss", Locale.US);
        FREE_RATIO = 0.03f;
        FREE_SIZE_OFFSET = 2.097152E7f;
        FREE_SIZE = 3.145728E8f;
        FREE_SIZE_MINUTE = 4.194304E7f;
        CHECK_INTERVAL = 45000L;
    }
}

