/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class BufferHelper {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int BUF_LEN = 256;
    public static final byte[] ANNEXB_START_MARK = new byte[]{0, 0, 0, 1};
    public static final int SIZEOF_FLOAT_BYTES = 4;

    private BufferHelper() {
    }

    public static final void dump(String tag, ByteBuffer buffer, int offset, int size) {
        BufferHelper.dump(tag, buffer, offset, size, false);
    }

    public static final void dump(String tag, ByteBuffer _buffer, int offset, int _size, boolean findAnnexB) {
        byte[] dump = new byte[256];
        if (_buffer == null) {
            return;
        }
        ByteBuffer buffer = _buffer.duplicate();
        int n = buffer.limit();
        int pos = buffer.position();
        int size = _size;
        if (size > n) {
            size = n;
        }
        buffer.position(offset);
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < size; i += 256) {
            int sz = i + 256 < size ? 256 : size - i;
            buffer.get(dump, 0, sz);
            for (int j = 0; j < sz; ++j) {
                sb.append(String.format("%02x", dump[j]));
            }
            if (!findAnnexB) continue;
            int index = -1;
            do {
                if ((index = BufferHelper.byteComp(dump, index + 1, ANNEXB_START_MARK, ANNEXB_START_MARK.length)) < 0) continue;
                Log.i((String)tag, (String)("found ANNEXB: start index=" + index));
            } while (index >= 0);
        }
        Log.i((String)tag, (String)("dump:" + sb.toString()));
    }

    public static final void dump(String tag, byte[] buffer, int offset, int _size, boolean findAnnexB) {
        int n;
        int n2 = n = buffer != null ? buffer.length : 0;
        if (n == 0) {
            return;
        }
        int size = _size;
        if (size > n) {
            size = n;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = offset; i < size; ++i) {
            sb.append(String.format("%02x", buffer[i]));
        }
        if (findAnnexB) {
            int index = -1;
            do {
                if ((index = BufferHelper.byteComp(buffer, index + 1, ANNEXB_START_MARK, ANNEXB_START_MARK.length)) < 0) continue;
                Log.i((String)tag, (String)("found ANNEXB: start index=" + index));
            } while (index >= 0);
        }
        Log.i((String)tag, (String)("dump:" + sb.toString()));
    }

    public static final int byteComp(@NonNull byte[] array, int offset, @NonNull byte[] search, int len) {
        int index = -1;
        int n0 = array.length;
        int ns = search.length;
        if (n0 >= offset + len && ns >= len) {
            for (int i = offset; i < n0 - len; ++i) {
                int j;
                for (j = len - 1; j >= 0 && array[i + j] == search[j]; --j) {
                }
                if (j >= 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static final int findAnnexB(byte[] data, int offset) {
        if (data != null) {
            int len5 = data.length - 5;
            for (int i = offset; i < len5; ++i) {
                if (data[i] != 0 || data[i + 1] != 0 || data[i + 2] != 0 || data[i + 3] != 1) continue;
                return i;
            }
            int len4 = data.length - 4;
            for (int i = offset; i < len4; ++i) {
                if (data[i] != 0 || data[i + 1] != 0 || data[i + 2] != 1) continue;
                return i;
            }
        }
        return -1;
    }

    public static FloatBuffer createFloatBuffer(@NonNull float[] coords) {
        FloatBuffer result = ByteBuffer.allocateDirect(coords.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        result.put(coords).flip();
        return result;
    }

    public static ByteBuffer from(String hexString) throws NumberFormatException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int n = !TextUtils.isEmpty((CharSequence)hexString) ? hexString.length() : 0;
        for (int i = 0; i < n; i += 2) {
            int b = Integer.parseInt(hexString.substring(i, i + 2), 16);
            out.write(b);
        }
        return ByteBuffer.wrap(out.toByteArray());
    }

    public static String toHexString(@NonNull byte[] bytes) {
        return BufferHelper.toHexString(bytes, 0, bytes.length);
    }

    public static String toHexString(byte[] bytes, int offset, int len) {
        int n = bytes != null ? bytes.length : 0;
        int m = Math.min(n, offset + len);
        StringBuilder sb = new StringBuilder(n * 2 + 2);
        for (int i = offset; i < m; ++i) {
            byte b = bytes[i];
            sb.append(HEX[(0xF0 & b) >>> 4]);
            sb.append(HEX[0xF & b]);
        }
        return sb.toString();
    }

    public static String toHexString(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        ByteBuffer _buffer = buffer.duplicate();
        int n = _buffer.remaining();
        StringBuilder sb = new StringBuilder(n * 2 + 2);
        for (int i = 0; i < n; ++i) {
            byte b = _buffer.get();
            sb.append(HEX[(0xF0 & b) >>> 4]);
            sb.append(HEX[0xF & b]);
        }
        return sb.toString();
    }

    @NonNull
    public static byte[] resize(@Nullable byte[] buffer, int newSize) {
        byte[] result = buffer;
        if (result == null || result.length < newSize) {
            result = new byte[newSize];
        }
        return result;
    }

    @NonNull
    public static ByteBuffer resize(@Nullable ByteBuffer buffer, int newSize) {
        ByteBuffer result = buffer;
        if (result == null || result.capacity() < newSize) {
            result = ByteBuffer.allocate(newSize);
        }
        result.clear();
        return result;
    }

    @NonNull
    public static ByteBuffer resizeDirect(@Nullable ByteBuffer buffer, int newSize) {
        ByteBuffer result = buffer;
        if (result == null || result.capacity() < newSize) {
            result = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
        }
        result.clear();
        return result;
    }
}

