/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.text.Editable;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.XmlRes;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.widget.Keyboard;
import com.serenegiant.widget.KeyboardView;
import java.lang.reflect.Method;

public abstract class KeyboardDelegater
implements KeyboardView.OnKeyboardActionListener {
    private static final boolean DEBUG = false;
    private static final String TAG = KeyboardDelegater.class.getSimpleName();
    @NonNull
    private final EditText mEditText;
    @NonNull
    private final KeyboardView mKeyboardView;
    @XmlRes
    private final int mKeyboardLayoutRes;
    @Nullable
    private Keyboard mKeyboard;

    public KeyboardDelegater(@NonNull EditText editText, @NonNull KeyboardView keyboardView, @XmlRes int keyboardLayoutRes) {
        this.mEditText = editText;
        this.mKeyboardView = keyboardView;
        this.mKeyboardLayoutRes = keyboardLayoutRes;
    }

    public void showKeyboard() {
        this.hideSystemSoftKeyboard();
        if (this.mKeyboard == null) {
            this.mKeyboard = new Keyboard(this.mEditText.getContext(), this.mKeyboardLayoutRes);
            this.mKeyboardView.setKeyboard(this.mKeyboard);
        }
        this.mKeyboardView.setEnabled(true);
        this.mKeyboardView.setPreviewEnabled(false);
        this.mKeyboardView.setOnKeyboardActionListener(this);
        int visibility = this.mKeyboardView.getVisibility();
        if (visibility == 8 || visibility == 4) {
            this.mKeyboardView.setVisibility(0);
        }
    }

    public void hideKeyboard() {
        int visibility = this.mKeyboardView.getVisibility();
        if (visibility == 0) {
            this.mKeyboardView.setVisibility(8);
        }
    }

    public void hideSystemSoftKeyboard() {
        try {
            Class<EditText> cls = EditText.class;
            Method setShowSoftInputOnFocus = cls.getMethod("setShowSoftInputOnFocus", Boolean.TYPE);
            setShowSoftInputOnFocus.setAccessible(true);
            setShowSoftInputOnFocus.invoke((Object)this.mEditText, false);
        }
        catch (SecurityException cls) {
        }
        catch (NoSuchMethodException cls) {
        }
        catch (Exception cls) {
            // empty catch block
        }
        InputMethodManager imm = ContextUtils.requireSystemService(this.mEditText.getContext(), InputMethodManager.class);
        imm.hideSoftInputFromWindow(this.mEditText.getWindowToken(), 0);
    }

    protected abstract void onOkClick();

    protected abstract void onCancelClick();

    @Override
    public void onPress(int primaryCode) {
    }

    @Override
    public void onRelease(int primaryCode) {
    }

    @Override
    public void onKey(int primaryCode, int[] keyCodes) {
        Editable editable = this.mEditText.getText();
        int start = this.mEditText.getSelectionStart();
        if (primaryCode == -5) {
            if (editable != null && editable.length() > 0 && start > 0) {
                editable.delete(start - 1, start);
            }
        } else if (primaryCode == -3) {
            this.hideKeyboard();
            this.onCancelClick();
        } else if (primaryCode == -4) {
            this.hideKeyboard();
            this.onOkClick();
        } else {
            editable.insert(start, (CharSequence)Character.toString((char)primaryCode));
        }
    }

    @Override
    public void onText(CharSequence text) {
    }

    @Override
    public void swipeLeft() {
    }

    @Override
    public void swipeRight() {
    }

    @Override
    public void swipeDown() {
    }

    @Override
    public void swipeUp() {
    }
}

