/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.FileUtils;
import com.serenegiant.utils.UriHelper;

@TargetApi(value=16)
public class MediaStoreUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreUtils.class.getSimpleName();
    public static final int MEDIA_ALL = 0;
    public static final int MEDIA_IMAGE = 1;
    public static final int MEDIA_VIDEO = 2;
    protected static final int MEDIA_TYPE_NUM = 3;
    protected static final String[] PROJ_MEDIA = new String[]{"_id", "title", "mime_type", "_data", "_display_name", "width", "height", "media_type"};
    protected static final String[] PROJ_MEDIA_IMAGE = new String[]{"_id", "title", "mime_type", "_data", "_display_name", "width", "height"};
    protected static final String[] PROJ_MEDIA_VIDEO = new String[]{"_id", "title", "mime_type", "_data", "_display_name", "width", "height"};
    protected static final String SELECTION_MEDIA_ALL = "media_type=1 OR media_type=3";
    protected static final String SELECTION_MEDIA_IMAGE = "media_type=1";
    protected static final String SELECTION_MEDIA_VIDEO = "media_type=3";
    protected static final String[] SELECTIONS = new String[]{"media_type=1 OR media_type=3", "media_type=1", "media_type=3"};
    protected static final int PROJ_INDEX_ID = 0;
    protected static final int PROJ_INDEX_TITLE = 1;
    protected static final int PROJ_INDEX_MIME_TYPE = 2;
    protected static final int PROJ_INDEX_DATA = 3;
    protected static final int PROJ_INDEX_DISPLAY_NAME = 4;
    protected static final int PROJ_INDEX_WIDTH = 5;
    protected static final int PROJ_INDEX_HEIGHT = 6;
    protected static final int PROJ_INDEX_MEDIA_TYPE = 7;
    @SuppressLint(value={"InlinedApi"})
    public static final Uri QUERY_URI_FILES = Build.VERSION.SDK_INT >= 29 ? MediaStore.Files.getContentUri((String)"external_primary") : MediaStore.Files.getContentUri((String)"external");
    @SuppressLint(value={"InlinedApi"})
    public static final Uri QUERY_URI_IMAGES = Build.VERSION.SDK_INT >= 29 ? MediaStore.Images.Media.getContentUri((String)"external_primary") : MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    @SuppressLint(value={"InlinedApi"})
    public static final Uri QUERY_URI_VIDEO = Build.VERSION.SDK_INT >= 29 ? MediaStore.Video.Media.getContentUri((String)"external_primary") : MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
    @SuppressLint(value={"InlinedApi"})
    public static final Uri QUERY_URI_AUDIO = Build.VERSION.SDK_INT >= 29 ? MediaStore.Audio.Media.getContentUri((String)"external_primary") : MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;

    private MediaStoreUtils() {
    }

    @TargetApi(value=19)
    public static DocumentFile getContentDocument(@NonNull Context context, @Nullable String mimeType, @Nullable String relativePath, @NonNull String nameWithExt, @Nullable String dataPath) {
        return DocumentFile.fromSingleUri((Context)context, (Uri)MediaStoreUtils.getContentUri(context, mimeType, relativePath, nameWithExt, dataPath));
    }

    public static Uri getContentUri(@NonNull Context context, @Nullable String mimeType, @Nullable String relativePath, @NonNull String nameWithExt, @Nullable String dataPath) {
        return MediaStoreUtils.getContentUri(context.getContentResolver(), mimeType, relativePath, nameWithExt, dataPath);
    }

    public static Uri getContentUri(@NonNull ContentResolver cr, @Nullable String mimeType, @Nullable String relativePath, @NonNull String nameWithExt, @Nullable String dataPath) {
        Uri queryUri;
        ContentValues cv = new ContentValues();
        String _mimeType = mimeType != null ? mimeType.toLowerCase() : "";
        String ext = FileUtils.getExt(nameWithExt).toLowerCase();
        if (_mimeType.startsWith("*/") && dataPath != null) {
            cv.put("_display_name", nameWithExt);
            cv.put("mime_type", _mimeType);
            queryUri = QUERY_URI_FILES;
        } else if (_mimeType.startsWith("image/") || ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("jpg") || ext.equalsIgnoreCase("jpeg") || ext.equalsIgnoreCase("webp")) {
            if (TextUtils.isEmpty((CharSequence)_mimeType)) {
                _mimeType = "image/" + (TextUtils.isEmpty((CharSequence)ext) ? "*" : ext);
            }
            cv.put("_display_name", nameWithExt);
            cv.put("mime_type", _mimeType);
            queryUri = QUERY_URI_IMAGES;
        } else if (_mimeType.startsWith("video/") || ext.equalsIgnoreCase("mp4") || ext.equalsIgnoreCase("3gp") || ext.equalsIgnoreCase("h264") || ext.equalsIgnoreCase("mjpeg")) {
            if (TextUtils.isEmpty((CharSequence)_mimeType)) {
                _mimeType = "video/" + (TextUtils.isEmpty((CharSequence)ext) ? "*" : ext);
            }
            cv.put("_display_name", nameWithExt);
            cv.put("mime_type", _mimeType);
            queryUri = QUERY_URI_VIDEO;
        } else if (_mimeType.startsWith("audio/") || ext.equalsIgnoreCase("m4a")) {
            if (TextUtils.isEmpty((CharSequence)_mimeType)) {
                _mimeType = "audio/" + (TextUtils.isEmpty((CharSequence)ext) ? "*" : ext);
            }
            cv.put("_display_name", nameWithExt);
            cv.put("mime_type", _mimeType);
            queryUri = QUERY_URI_AUDIO;
        } else {
            throw new IllegalArgumentException("unknown mimeType/file type," + mimeType + ",name=" + nameWithExt);
        }
        if (dataPath != null) {
            cv.put("_data", dataPath);
        }
        cv.put("title", FileUtils.removeFileExtension(nameWithExt));
        if (Build.VERSION.SDK_INT >= 29) {
            if (!TextUtils.isEmpty((CharSequence)relativePath)) {
                cv.put("relative_path", relativePath);
            }
            cv.put("is_pending", Integer.valueOf(1));
        }
        Uri result = cr.insert(queryUri, cv);
        return result;
    }

    public static void updateContentUri(@NonNull Context context, @NonNull DocumentFile file) {
        if (!file.isDirectory() && BuildCheck.isAPI29()) {
            MediaStoreUtils.updateContentUri(context.getContentResolver(), file.getUri());
        }
    }

    public static void updateContentUri(@NonNull Context context, @NonNull Uri uri) {
        MediaStoreUtils.updateContentUri(context.getContentResolver(), uri);
    }

    @SuppressLint(value={"InlinedApi"})
    public static void updateContentUri(@NonNull ContentResolver cr, @NonNull Uri uri) {
        if (BuildCheck.isAPI29() && UriHelper.isContentUri(uri)) {
            ContentValues cv = new ContentValues();
            cv.put("is_pending", Integer.valueOf(0));
            try {
                cr.update(uri, cv, null, null);
            }
            catch (Exception e) {
                Log.d((String)TAG, (String)"updateContentUri:", (Throwable)e);
            }
        }
    }

    @Nullable
    public static Uri getUri(int mediaType, long id2) {
        switch (mediaType) {
            case 0: {
                return ContentUris.withAppendedId((Uri)MediaStore.Files.getContentUri((String)"external"), (long)id2);
            }
            case 1: {
                return ContentUris.withAppendedId((Uri)MediaStore.Images.Media.EXTERNAL_CONTENT_URI, (long)id2);
            }
            case 2: {
                return ContentUris.withAppendedId((Uri)MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, (long)id2);
            }
            case 3: {
                return ContentUris.withAppendedId((Uri)MediaStore.Video.Media.EXTERNAL_CONTENT_URI, (long)id2);
            }
        }
        return null;
    }

    @Deprecated
    public static Uri registerImage(@NonNull Context context, @NonNull String mime, @NonNull String path) {
        ContentValues cv = new ContentValues();
        cv.put("mime_type", mime);
        cv.put("_data", path);
        return context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, cv);
    }

    @Deprecated
    public static Uri registerVideo(@NonNull Context context, @NonNull String mime, @NonNull String path) {
        ContentValues cv = new ContentValues();
        cv.put("mime_type", mime);
        cv.put("_data", path);
        return context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, cv);
    }
}

