/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.documentfile.provider.DocumentFile;
import com.serenegiant.media.IMuxer;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.Recorder;
import com.serenegiant.media.VideoConfig;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.SAFUtils;
import com.serenegiant.system.StorageInfo;
import com.serenegiant.system.StorageUtils;
import com.serenegiant.utils.FileUtils;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.IOException;

@SuppressLint(value={"NewApi"})
public class MediaAVRecorder
extends Recorder {
    private static final String TAG = MediaAVRecorder.class.getSimpleName();
    protected final int mSaveTreeId;
    protected String mOutputPath;
    protected DocumentFile mOutputFile;

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, String ext, int saveTreeId) throws IOException {
        this(context, callback, null, null, null, ext, saveTreeId);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable IMuxer.IMuxerFactory factory, String ext, int saveTreeId) throws IOException {
        this(context, callback, null, null, ext, saveTreeId);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, String prefix, String _ext, int saveTreeId) throws IOException {
        this(context, callback, null, null, prefix, _ext, saveTreeId);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable IMuxer.IMuxerFactory factory, String prefix, String _ext, int saveTreeId) throws IOException {
        this(context, callback, null, factory, prefix, _ext, saveTreeId);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, int saveTreeId, @Nullable String dirs, @NonNull String fileName) throws IOException {
        this(context, callback, null, null, saveTreeId, dirs, fileName);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable IMuxer.IMuxerFactory factory, int saveTreeId, @Nullable String dirs, @NonNull String fileName) throws IOException {
        this(context, callback, null, factory, saveTreeId, dirs, fileName);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @NonNull String outputPath) throws IOException {
        this(context, callback, null, null, outputPath);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable IMuxer.IMuxerFactory factory, @NonNull String outputPath) throws IOException {
        this(context, callback, null, factory, outputPath);
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable VideoConfig config, @Nullable IMuxer.IMuxerFactory factory, String prefix, String _ext, int saveTreeId) throws IOException {
        super(context, callback, config, factory);
        this.mSaveTreeId = saveTreeId;
        String ext = _ext;
        if (TextUtils.isEmpty((CharSequence)ext)) {
            ext = ".mp4";
        }
        String fileName = (TextUtils.isEmpty((CharSequence)prefix) ? FileUtils.getDateTimeString() : prefix + FileUtils.getDateTimeString()) + ext;
        if (BuildCheck.isAPI21() && saveTreeId != 0 && SAFUtils.hasPermission(context, saveTreeId)) {
            DocumentFile output = SAFUtils.getFile(context, saveTreeId, null, "video/*", fileName);
            this.setupMuxer(context, output);
        } else {
            try {
                this.mOutputPath = FileUtils.getCaptureFile(context, Environment.DIRECTORY_MOVIES, prefix, ext).toString();
                if (this.mOutputPath == null) {
                    throw new IOException("This app has no permission of writing external storage");
                }
            }
            catch (Exception e) {
                throw new IOException("This app has no permission of writing external storage");
            }
            DocumentFile output = DocumentFile.fromFile((File)new File(this.mOutputPath));
            this.setupMuxer(context, output);
        }
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable VideoConfig config, @Nullable IMuxer.IMuxerFactory factory, int saveTreeId, @Nullable String dirs, @NonNull String fileName) throws IOException {
        super(context, callback, config, factory);
        DocumentFile output;
        this.mSaveTreeId = saveTreeId;
        if (saveTreeId > 0 && SAFUtils.hasPermission(context, saveTreeId) && (output = SAFUtils.getFile(context, saveTreeId, dirs, "*/*", fileName)) != null) {
            this.mOutputPath = UriHelper.getPath(context, output.getUri());
            this.setupMuxer(context, output);
        }
        throw new IOException("path not found/can't write");
    }

    @Deprecated
    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable VideoConfig config, @Nullable IMuxer.IMuxerFactory factory, @NonNull String outputPath) throws IOException {
        super(context, callback, config, factory);
        this.mSaveTreeId = 0;
        this.mOutputPath = outputPath;
        if (TextUtils.isEmpty((CharSequence)outputPath)) {
            try {
                this.mOutputPath = FileUtils.getCaptureFile(context, Environment.DIRECTORY_MOVIES, null, ".mp4").toString();
            }
            catch (Exception e) {
                throw new IOException("This app has no permission of writing external storage");
            }
        }
        this.setupMuxer(context, DocumentFile.fromFile((File)new File(this.mOutputPath)));
    }

    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @NonNull DocumentFile output) throws IOException {
        this(context, callback, null, null, output);
    }

    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable IMuxer.IMuxerFactory factory, @NonNull DocumentFile output) throws IOException {
        this(context, callback, null, factory, output);
    }

    public MediaAVRecorder(@NonNull Context context, @Nullable IRecorder.RecorderCallback callback, @Nullable VideoConfig config, @Nullable IMuxer.IMuxerFactory factory, @NonNull DocumentFile output) throws IOException {
        super(context, callback, config, factory);
        this.mSaveTreeId = 0;
        this.mOutputFile = output;
        this.mOutputPath = UriHelper.getPath(context, output.getUri());
        this.setupMuxer(context, output);
    }

    @Override
    @Deprecated
    @Nullable
    public String getOutputPath() {
        return this.mOutputPath;
    }

    @Override
    @Nullable
    public DocumentFile getOutputFile() {
        return this.mOutputFile;
    }

    @Override
    protected boolean check() {
        Context context = this.requireContext();
        try {
            StorageInfo info;
            StorageInfo storageInfo = info = this.mOutputFile != null ? StorageUtils.getStorageInfo(context, this.mOutputFile) : null;
            if (info != null && info.totalBytes != 0L) {
                return (float)info.freeBytes / (float)info.totalBytes < FileUtils.FREE_RATIO || (float)info.freeBytes < FileUtils.FREE_SIZE;
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return context == null || this.mOutputFile == null && !FileUtils.checkFreeSpace(context, this.getConfig().maxDuration(), this.mStartTime, this.mSaveTreeId);
    }

    @Deprecated
    protected void setupMuxer(int fd) throws IOException {
        throw new IOException("Failed to create muxer");
    }

    @Deprecated
    protected void setupMuxer(@NonNull String output) throws IOException {
        throw new IOException("Failed to create muxer");
    }

    protected void setupMuxer(@NonNull Context context, @NonNull DocumentFile output) throws IOException {
        this.setMuxer(this.getMuxerFactory().createMuxer(context, this.getConfig().useMediaMuxer(), output));
    }
}

