/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import androidx.annotation.NonNull;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IAudioEncoder;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.MediaCodecUtils;
import com.serenegiant.media.MediaReaper;

@TargetApi(value=16)
public abstract class AbstractAudioEncoder
extends AbstractEncoder
implements IAudioEncoder {
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BIT_RATE = 64000;
    public static final int SAMPLES_PER_FRAME = 1024;
    public static final int FRAMES_PER_BUFFER = 25;
    protected int mAudioSource;
    protected int mChannelCount;
    protected int mSampleRate;
    protected int mBitRate;

    @Deprecated
    public AbstractAudioEncoder(@NonNull IRecorder recorder, @NonNull EncoderListener listener, int audio_source, int audio_channels) {
        this(recorder, listener, audio_source, audio_channels, 44100, 64000);
    }

    public AbstractAudioEncoder(@NonNull IRecorder recorder, @NonNull EncoderListener listener, int audio_source, int audio_channels, int sample_rate, int bit_rate) {
        super("audio/mp4a-latm", recorder, listener);
        this.mAudioSource = audio_source;
        this.mChannelCount = audio_channels;
        this.mSampleRate = sample_rate;
        this.mBitRate = bit_rate;
    }

    @Override
    protected boolean internalPrepare(@NonNull MediaReaper.ReaperListener listener) throws Exception {
        this.mTrackIndex = -1;
        MediaCodecInfo audioCodecInfo = MediaCodecUtils.selectAudioEncoder(this.MIME_TYPE);
        if (audioCodecInfo == null) {
            return true;
        }
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", this.mChannelCount == 1 ? 16 : 12);
        audioFormat.setInteger("bitrate", this.mBitRate);
        audioFormat.setInteger("channel-count", this.mChannelCount);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)this.MIME_TYPE);
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        this.mReaper = new MediaReaper.AudioReaper(this.mMediaCodec, listener, this.mSampleRate, this.mChannelCount);
        return false;
    }

    @Override
    public final boolean isAudio() {
        return true;
    }
}

