/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.graphics;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import java.util.HashMap;
import java.util.Map;

public class MatrixUtils {
    private static final Map<ImageView.ScaleType, ScaleType> sScaleTypeMap = new HashMap<ImageView.ScaleType, ScaleType>();

    private MatrixUtils() {
    }

    public static float getRotate(@NonNull Matrix matrix) {
        float[] mat = new float[9];
        matrix.getValues(mat);
        return MatrixUtils.getRotate(mat);
    }

    public static float getRotate(@NonNull @Size(min=9L) float[] mat) {
        return Math.round(Math.atan2(mat[1], mat[0]) * 57.29577951308232);
    }

    public static float getScale(@NonNull Matrix matrix) {
        float[] mat = new float[9];
        matrix.getValues(mat);
        return MatrixUtils.getScale(mat);
    }

    public static float getScale(@NonNull @Size(min=9L) float[] mat) {
        float scaleX = mat[0];
        float skewY = mat[3];
        return (float)Math.sqrt(scaleX * scaleX + skewY * skewY);
    }

    @NonNull
    @Size(min=16L)
    public static float[] toGLMatrix(@NonNull Matrix transform, @NonNull @Size(min=16L) float[] result, @NonNull @Size(min=9L) float[] aMatrix) {
        transform.getValues(aMatrix);
        result[0] = aMatrix[0];
        result[1] = aMatrix[3];
        result[2] = 0.0f;
        result[3] = aMatrix[6];
        result[4] = aMatrix[1];
        result[5] = aMatrix[4];
        result[6] = 0.0f;
        result[7] = aMatrix[7];
        result[8] = 0.0f;
        result[9] = 0.0f;
        result[10] = 1.0f;
        result[11] = 0.0f;
        result[12] = aMatrix[2];
        result[13] = aMatrix[5];
        result[14] = 0.0f;
        result[15] = aMatrix[8];
        return result;
    }

    public static Matrix toAndroidMatrix(@NonNull @Size(min=16L) float[] transform, @NonNull Matrix result, @NonNull @Size(min=9L) float[] aMatrix) {
        aMatrix[0] = transform[0];
        aMatrix[3] = transform[1];
        aMatrix[6] = transform[3];
        aMatrix[1] = transform[4];
        aMatrix[4] = transform[5];
        aMatrix[7] = transform[7];
        aMatrix[2] = transform[12];
        aMatrix[5] = transform[13];
        aMatrix[8] = transform[15];
        result.setValues(aMatrix);
        return result;
    }

    public static String toGLMatrixString(@NonNull @Size(min=16L) float[] transform) {
        return "GLMatrix[" + transform[0] + ", " + transform[1] + ", " + transform[2] + ", " + transform[3] + "][" + transform[4] + ", " + transform[5] + ", " + transform[6] + ", " + transform[7] + "][" + transform[8] + ", " + transform[9] + ", " + transform[10] + ", " + transform[11] + "][" + transform[12] + ", " + transform[13] + ", " + transform[14] + ", " + transform[15] + ']';
    }

    @NonNull
    public static ImageView.ScaleType toImageViewScaleType(@NonNull ScaleType scaleType) {
        for (Map.Entry<ImageView.ScaleType, ScaleType> entry : sScaleTypeMap.entrySet()) {
            if (entry.getValue() != scaleType) continue;
            return entry.getKey();
        }
        return ImageView.ScaleType.CENTER_CROP;
    }

    @NonNull
    public static ScaleType fromImageViewScaleType(@NonNull ImageView.ScaleType scaleType) {
        if (sScaleTypeMap.containsKey(scaleType)) {
            return sScaleTypeMap.get(scaleType);
        }
        return ScaleType.CENTER_CROP;
    }

    public static void updateDrawMatrix(@NonNull ImageView.ScaleType scaleType, @NonNull Matrix drawMatrix, @NonNull Rect bounds, float dwidth, float dheight) {
        MatrixUtils.updateDrawMatrix(MatrixUtils.fromImageViewScaleType(scaleType), drawMatrix, bounds.width(), bounds.height(), dwidth, dheight);
    }

    public static void updateDrawMatrix(@NonNull ScaleType scaleType, @NonNull Matrix drawMatrix, float vwidth, float vheight, float dwidth, float dheight) {
        if (dwidth <= 0.0f || dheight <= 0.0f || vwidth <= 0.0f || vheight <= 0.0f) {
            drawMatrix.reset();
            return;
        }
        if (scaleType == ScaleType.CENTER_CROP) {
            float scale;
            float dx = 0.0f;
            float dy = 0.0f;
            if (dwidth * vheight > vwidth * dheight) {
                scale = vheight / dheight;
                dx = (vwidth - dwidth * scale) * 0.5f;
            } else {
                scale = vwidth / dwidth;
                dy = (vheight - dheight * scale) * 0.5f;
            }
            drawMatrix.setScale(scale, scale);
            drawMatrix.postTranslate((float)Math.round(dx), (float)Math.round(dy));
        } else if (scaleType == ScaleType.CENTER_INSIDE) {
            float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min(vwidth / dwidth, vheight / dheight);
            float dx = Math.round((vwidth - dwidth * scale) * 0.5f);
            float dy = Math.round((vheight - dheight * scale) * 0.5f);
            drawMatrix.setScale(scale, scale);
            drawMatrix.postTranslate(dx, dy);
        } else if (scaleType == ScaleType.CENTER) {
            drawMatrix.setTranslate((float)Math.round((vwidth - dwidth) * 0.5f), (float)Math.round((vheight - dheight) * 0.5f));
        } else {
            RectF dstBounds = new RectF(0.0f, 0.0f, vwidth, vheight);
            RectF srcBounds = new RectF(0.0f, 0.0f, dwidth, dheight);
            switch (scaleType) {
                case FIT_XY: {
                    drawMatrix.setRectToRect(srcBounds, dstBounds, Matrix.ScaleToFit.FILL);
                    break;
                }
                case FIT_START: {
                    drawMatrix.setRectToRect(srcBounds, dstBounds, Matrix.ScaleToFit.START);
                    break;
                }
                case FIT_CENTER: {
                    drawMatrix.setRectToRect(srcBounds, dstBounds, Matrix.ScaleToFit.CENTER);
                    break;
                }
                case FIT_END: {
                    drawMatrix.setRectToRect(srcBounds, dstBounds, Matrix.ScaleToFit.END);
                    break;
                }
            }
        }
    }

    static {
        sScaleTypeMap.put(ImageView.ScaleType.MATRIX, ScaleType.MATRIX);
        sScaleTypeMap.put(ImageView.ScaleType.FIT_XY, ScaleType.FIT_XY);
        sScaleTypeMap.put(ImageView.ScaleType.FIT_START, ScaleType.FIT_START);
        sScaleTypeMap.put(ImageView.ScaleType.FIT_CENTER, ScaleType.FIT_CENTER);
        sScaleTypeMap.put(ImageView.ScaleType.FIT_END, ScaleType.FIT_END);
        sScaleTypeMap.put(ImageView.ScaleType.CENTER, ScaleType.CENTER);
        sScaleTypeMap.put(ImageView.ScaleType.CENTER_CROP, ScaleType.CENTER_CROP);
        sScaleTypeMap.put(ImageView.ScaleType.CENTER_INSIDE, ScaleType.CENTER_INSIDE);
    }

    public static enum ScaleType {
        MATRIX(0),
        FIT_XY(1),
        FIT_START(2),
        FIT_CENTER(3),
        FIT_END(4),
        CENTER(5),
        CENTER_CROP(6),
        CENTER_INSIDE(7);

        final int id;

        private ScaleType(int id2) {
            this.id = id2;
        }
    }
}

