/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.graphics.SurfaceTexture;
import android.view.Surface;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public interface IRendererHolder
extends IMirror {
    public static final int DEFAULT_CAPTURE_COMPRESSION = 80;
    public static final int OUTPUT_FORMAT_JPEG = 0;
    public static final int OUTPUT_FORMAT_PNG = 1;
    public static final int OUTPUT_FORMAT_WEBP = 2;

    public boolean isRunning();

    public void release();

    @Nullable
    public EGLBase.IContext<?> getContext();

    public Surface getSurface();

    public SurfaceTexture getSurfaceTexture();

    public void reset();

    public void resize(int var1, int var2) throws IllegalStateException;

    public void addSurface(int var1, Object var2, boolean var3) throws IllegalStateException, IllegalArgumentException;

    public void addSurface(int var1, Object var2, boolean var3, @Nullable Fraction var4) throws IllegalStateException, IllegalArgumentException;

    public void removeSurface(int var1);

    public void removeSurfaceAll();

    public void clearSurface(int var1, int var2);

    public void clearSurfaceAll(int var1);

    public void setMvpMatrix(int var1, int var2, @NonNull @Size(min=16L) float[] var3);

    public boolean isEnabled(int var1);

    public void setEnabled(int var1, boolean var2);

    public void requestFrame();

    public int getCount();

    public void captureStill(@NonNull String var1, @Nullable OnCapturedListener var2) throws FileNotFoundException, IllegalStateException;

    public void captureStill(@NonNull String var1, @IntRange(from=1L, to=99L) int var2, @Nullable OnCapturedListener var3) throws FileNotFoundException, IllegalStateException;

    public void captureStill(@NonNull OutputStream var1, int var2, @IntRange(from=1L, to=99L) int var3, @Nullable OnCapturedListener var4) throws IllegalStateException;

    public void queueEvent(@NonNull Runnable var1);

    public static interface OnCapturedListener {
        public void onCaptured(@NonNull IRendererHolder var1, boolean var2);
    }

    public static interface RenderHolderCallback {
        public void onCreate(Surface var1);

        public void onFrameAvailable();

        public void onDestroy();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StillCaptureFormat {
    }
}

