/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.opengl.GLES20;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLContext;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;
import com.serenegiant.utils.ThreadUtils;

public abstract class AbstractDistributeTask
implements IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractDistributeTask.class.getSimpleName();
    private static final int REQUEST_DRAW = 1;
    private static final int REQUEST_UPDATE_SIZE = 2;
    private static final int REQUEST_ADD_SURFACE = 3;
    private static final int REQUEST_REMOVE_SURFACE = 4;
    private static final int REQUEST_REMOVE_SURFACE_ALL = 12;
    private static final int REQUEST_RECREATE_MASTER_SURFACE = 5;
    private static final int REQUEST_MIRROR = 6;
    private static final int REQUEST_ROTATE = 7;
    private static final int REQUEST_CLEAR = 8;
    private static final int REQUEST_CLEAR_ALL = 9;
    private static final int REQUEST_SET_MVP = 10;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final SparseArray<RendererTarget> mTargets = new SparseArray();
    @NonNull
    private final GLDrawer2D.DrawerFactory mDrawerFactory;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mMirror = 0;
    private int mRotation = 0;
    private volatile boolean mIsFirstFrameRendered;
    private volatile boolean mHasNewFrame;
    private volatile boolean mReleased;
    private GLDrawer2D mDrawer;

    protected AbstractDistributeTask(int width, int height, @Nullable GLDrawer2D.DrawerFactory factory) {
        this.mVideoWidth = width > 0 ? width : 640;
        this.mVideoHeight = height > 0 ? height : 480;
        this.mDrawerFactory = factory != null ? factory : GLDrawer2D.DEFAULT_FACTORY;
        this.mReleased = false;
    }

    public synchronized void release() {
        if (!this.mReleased) {
            this.mReleased = true;
        }
    }

    public boolean isFirstFrameRendered() {
        return this.mIsFirstFrameRendered;
    }

    @AnyThread
    public void requestFrame(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        this.mIsFirstFrameRendered = true;
        this.mHasNewFrame = true;
        this.offer(1, texId, isOES ? 1 : 0, texMatrix);
    }

    @AnyThread
    public void requestRecreateMasterSurface() {
        this.offer(5);
    }

    @AnyThread
    public void addSurface(int id2, Object surface) throws IllegalStateException, IllegalArgumentException {
        this.addSurface(id2, surface, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void addSurface(int id2, Object surface, @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        RendererTarget target;
        this.checkFinished();
        if (!GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
        }
        SparseArray<RendererTarget> sparseArray = this.mTargets;
        synchronized (sparseArray) {
            target = (RendererTarget)this.mTargets.get(id2);
        }
        if (target == null) {
            TargetSurface _surface = new TargetSurface(id2, surface, maxFps);
            while (this.isRunning() && !this.isFinished() && !this.offer(3, _surface)) {
                Object object = this.mSync;
                synchronized (object) {
                    try {
                        this.mSync.wait(5L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void removeSurface(int id2) {
        while (this.isRunning()) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.offer(4, id2)) {
                    try {
                        this.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    break;
                }
                try {
                    this.mSync.wait(5L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void removeSurfaceAll() {
        while (this.isRunning() && !this.isFinished()) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.offer(12)) {
                    try {
                        this.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    break;
                }
                try {
                    this.mSync.wait(5L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }

    @AnyThread
    public void clearSurface(int id2, int color) throws IllegalStateException {
        this.checkFinished();
        this.offer(8, id2, color);
    }

    @AnyThread
    public void clearSurfaceAll(int color) throws IllegalStateException {
        this.checkFinished();
        this.offer(9, color);
    }

    @AnyThread
    public void setMvpMatrix(int id2, int offset, @NonNull @Size(min=16L) float[] matrix) throws IllegalStateException, IllegalArgumentException {
        this.checkFinished();
        if (matrix.length < offset + 16) {
            throw new IllegalArgumentException("matrix is too small, should be longer than offset + 16");
        }
        this.offer(10, id2, offset, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public boolean isEnabled(int id2) {
        SparseArray<RendererTarget> sparseArray = this.mTargets;
        synchronized (sparseArray) {
            RendererTarget target = (RendererTarget)this.mTargets.get(id2);
            return target != null && target.isEnabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public void setEnabled(int id2, boolean enable) {
        SparseArray<RendererTarget> sparseArray = this.mTargets;
        synchronized (sparseArray) {
            RendererTarget target = (RendererTarget)this.mTargets.get(id2);
            if (target != null) {
                target.setEnabled(enable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AnyThread
    public int getCount() {
        SparseArray<RendererTarget> sparseArray = this.mTargets;
        synchronized (sparseArray) {
            return this.mTargets.size();
        }
    }

    @AnyThread
    public void resize(int width, int height) throws IllegalStateException {
        this.checkFinished();
        if (width > 0 && height > 0 && (this.mVideoWidth != width || this.mVideoHeight != height)) {
            this.offer(2, width, height);
        }
    }

    @Override
    @AnyThread
    public void setMirror(int mirror) throws IllegalStateException {
        this.checkFinished();
        if (this.mMirror != mirror) {
            this.offer(6, mirror);
        }
    }

    @Override
    public int getMirror() {
        return this.mMirror;
    }

    @AnyThread
    public int width() {
        return this.mVideoWidth;
    }

    @AnyThread
    public int height() {
        return this.mVideoHeight;
    }

    public void rotation(int degree) {
        this.checkFinished();
        if (this.mRotation != degree) {
            this.offer(7, degree);
        }
    }

    @AnyThread
    public int rotation() {
        return this.mRotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLDrawer2D getDrawer() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mDrawer;
        }
    }

    @WorkerThread
    protected final void handleOnStart() {
        this.internalOnStart();
        this.notifyParent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void internalOnStart() {
        Object object = this.mSync;
        synchronized (object) {
            this.mDrawer = this.mDrawerFactory.create(this.isGLES3(), true);
        }
        this.handleReCreateInputSurface();
    }

    @WorkerThread
    protected final void handleOnStop() {
        this.notifyParent(false);
        this.makeCurrent();
        this.internalOnStop();
        this.handleRemoveAll();
    }

    @WorkerThread
    protected void internalOnStop() {
        this.handleReleaseInputSurface();
        this.handleRemoveAll();
        if (this.mDrawer != null) {
            this.mDrawer.release();
            this.mDrawer = null;
        }
    }

    @WorkerThread
    protected boolean handleOnError(Exception e) {
        return false;
    }

    @WorkerThread
    protected Object handleRequest(int request, int arg1, int arg2, Object obj) {
        switch (request) {
            case 1: {
                this.handleDraw(arg2 != 0, arg1, (float[])obj);
                break;
            }
            case 2: {
                this.handleResize(arg1, arg2);
                break;
            }
            case 3: {
                if (!(obj instanceof TargetSurface)) break;
                this.handleAddSurface((TargetSurface)obj);
                break;
            }
            case 4: {
                this.handleRemoveSurface(arg1);
                break;
            }
            case 12: {
                this.handleRemoveAll();
                break;
            }
            case 5: {
                this.handleReCreateInputSurface();
                break;
            }
            case 6: {
                this.handleMirror(arg1);
                break;
            }
            case 7: {
                this.handleRotate(arg1, arg2);
                break;
            }
            case 8: {
                this.handleClear(arg1, arg2);
                break;
            }
            case 9: {
                this.handleClearAll(arg1);
                break;
            }
            case 10: {
                this.handleSetMvp(arg1, arg2, (float[])obj);
            }
        }
        return null;
    }

    @WorkerThread
    private void handleDraw(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        this.removeRequest(1);
        if (!this.isMasterSurfaceValid()) {
            Log.e((String)TAG, (String)"handleDraw:invalid master surface");
            this.offer(5);
            return;
        }
        if (this.mIsFirstFrameRendered) {
            try {
                this.makeCurrent();
                if (this.mHasNewFrame) {
                    this.mHasNewFrame = false;
                    this.handleUpdateTexture();
                    GLES20.glFlush();
                    ThreadUtils.NoThrowSleep(0L, 0);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("handleDraw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
                this.offer(5);
                return;
            }
            this.handleDrawTargets(isOES, texId, texMatrix);
        }
        this.makeCurrent();
        GLES20.glClear((int)16384);
        GLES20.glFlush();
        if (this.mIsFirstFrameRendered) {
            this.callOnFrameAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void handleDrawTargets(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        GLDrawer2D drawer;
        int n = this.mTargets.size();
        Object object = this.mSync;
        synchronized (object) {
            if (this.mDrawer == null || this.mDrawer.isOES() != isOES) {
                if (this.mDrawer != null) {
                    this.mDrawer.release();
                }
                this.mDrawer = this.mDrawerFactory.create(this.isGLES3(), isOES);
            }
            drawer = this.mDrawer;
        }
        for (int i = n - 1; i >= 0; --i) {
            RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
            if (target == null || !target.canDraw()) continue;
            try {
                target.draw(drawer, 33984, texId, texMatrix);
                continue;
            }
            catch (Exception e) {
                SparseArray<RendererTarget> sparseArray = this.mTargets;
                synchronized (sparseArray) {
                    this.mTargets.removeAt(i);
                }
                target.release();
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleResize(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void handleAddSurface(@NonNull TargetSurface ts) {
        SparseArray<RendererTarget> sparseArray;
        this.checkTarget();
        RendererTarget target = (RendererTarget)this.mTargets.get(ts.id);
        if (target == null) {
            try {
                target = this.createRendererTarget(this.getEgl(), ts.id, ts.surface, ts.maxFps);
                GLUtils.setMirror(target.getMvpMatrix(), this.mMirror);
                sparseArray = this.mTargets;
                synchronized (sparseArray) {
                    this.mTargets.append(ts.id, (Object)target);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("invalid surface: surface=" + ts), (Throwable)e);
            }
        } else {
            Log.w((String)TAG, (String)("surface is already added: id=" + ts.id));
        }
        sparseArray = this.mSync;
        synchronized (sparseArray) {
            this.mSync.notify();
        }
    }

    @WorkerThread
    @NonNull
    private RendererTarget createRendererTarget(@NonNull EGLBase egl, int id2, @NonNull Object surface, @Nullable Fraction maxFps) {
        return RendererTarget.newInstance(egl, surface, maxFps != null ? maxFps.asFloat() : -1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void handleRemoveSurface(int id2) {
        RendererTarget target = (RendererTarget)this.mTargets.get(id2);
        if (target != null) {
            this.mTargets.remove(id2);
            if (target.isValid()) {
                target.clear(0);
            }
            target.release();
        }
        this.checkTarget();
        Object object = this.mSync;
        synchronized (object) {
            this.mSync.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void handleRemoveAll() {
        Object object = this.mTargets;
        synchronized (object) {
            int n = this.mTargets.size();
            Log.i((String)TAG, (String)("handleRemoveAll:n=" + n));
            for (int i = 0; i < n; ++i) {
                RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
                if (target == null) continue;
                if (target.isValid()) {
                    target.clear(0);
                }
                target.release();
            }
            this.mTargets.clear();
        }
        object = this.mSync;
        synchronized (object) {
            this.mSync.notify();
        }
    }

    @WorkerThread
    private void checkTarget() {
        int n = this.mTargets.size();
        for (int i = 0; i < n; ++i) {
            RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
            if (target == null || target.isValid()) continue;
            int id2 = this.mTargets.keyAt(i);
            this.mTargets.remove(id2);
            target.release();
        }
    }

    @WorkerThread
    private void handleClear(int id2, int color) {
        RendererTarget target = (RendererTarget)this.mTargets.get(id2);
        if (target != null && target.isValid()) {
            target.clear(color);
        }
    }

    @WorkerThread
    private void handleClearAll(int color) {
        int n = this.mTargets.size();
        for (int i = 0; i < n; ++i) {
            RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
            if (target == null || !target.isValid()) continue;
            target.clear(color);
        }
    }

    @WorkerThread
    private void handleSetMvp(int id2, int offset, @NonNull @Size(min=16L) float[] mvp) {
        RendererTarget target = (RendererTarget)this.mTargets.get(id2);
        if (target != null && target.isValid()) {
            System.arraycopy(mvp, offset, target.getMvpMatrix(), 0, 16);
        }
    }

    @WorkerThread
    private void handleMirror(int mirror) {
        this.mMirror = mirror;
        int n = this.mTargets.size();
        for (int i = 0; i < n; ++i) {
            RendererTarget target = (RendererTarget)this.mTargets.valueAt(i);
            if (target == null) continue;
            GLUtils.setMirror(target.getMvpMatrix(), mirror);
        }
    }

    @WorkerThread
    private void handleRotate(int id2, int degree) {
        this.mRotation = degree;
        RendererTarget target = (RendererTarget)this.mTargets.get(id2);
        if (target != null) {
            GLUtils.setRotation(target.getMvpMatrix(), degree);
        }
    }

    protected void checkFinished() throws IllegalStateException {
        if (this.isFinished()) {
            throw new IllegalStateException("already finished");
        }
    }

    public abstract void start(String var1);

    public abstract boolean waitReady();

    public abstract boolean isRunning();

    public abstract boolean isFinished();

    public abstract boolean offer(int var1);

    public abstract boolean offer(int var1, Object var2);

    public abstract boolean offer(int var1, int var2);

    public abstract boolean offer(int var1, int var2, int var3);

    public abstract boolean offer(int var1, int var2, int var3, Object var4);

    public abstract void removeRequest(int var1);

    @NonNull
    public abstract EGLBase getEgl();

    @NonNull
    public abstract GLContext getGLContext();

    @NonNull
    public abstract EGLBase.IContext<?> getContext();

    public abstract int getGlVersion();

    public abstract void makeCurrent();

    public abstract boolean isGLES3();

    public abstract boolean isOES3Supported();

    public abstract boolean isMasterSurfaceValid();

    @WorkerThread
    protected abstract void handleReCreateInputSurface();

    @WorkerThread
    protected abstract void handleReleaseInputSurface();

    @WorkerThread
    protected abstract void handleUpdateTexture();

    public abstract void notifyParent(boolean var1);

    public abstract void callOnFrameAvailable();

    private static class TargetSurface {
        private final int id;
        @NonNull
        private final Object surface;
        @Nullable
        private final Fraction maxFps;

        private TargetSurface(int id2, @NonNull Object surface, int maxFps) {
            this(id2, surface, TargetSurface.makeFraction(maxFps));
        }

        private TargetSurface(int id2, @NonNull Object surface, @Nullable Fraction maxFps) {
            this.id = id2;
            this.surface = surface;
            this.maxFps = maxFps;
        }

        @NonNull
        public String toString() {
            return "TargetSurface{id=" + this.id + ", surface=" + this.surface + ", maxFps=" + this.maxFps + '}';
        }

        @Nullable
        private static Fraction makeFraction(int v) {
            if (v < 0) {
                return null;
            }
            if (v > 1000) {
                return new Fraction(v, 1000);
            }
            return new Fraction(v, 1);
        }
    }
}

