/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glpipeline;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glpipeline.GLSurfacePipeline;
import com.serenegiant.glpipeline.ProxyPipeline;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;

public class SurfaceRendererPipeline
extends ProxyPipeline
implements GLSurfacePipeline,
IMirror {
    private static final boolean DEBUG = false;
    private static final String TAG = SurfaceRendererPipeline.class.getSimpleName();
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final GLManager mManager;
    @Nullable
    private GLDrawer2D mDrawer;
    @Nullable
    private RendererTarget mRendererTarget;
    private int mMirror = 0;
    private int cnt;

    public SurfaceRendererPipeline(@NonNull GLManager manager) throws IllegalStateException, IllegalArgumentException {
        this(manager, null, null);
    }

    public SurfaceRendererPipeline(@NonNull GLManager manager, final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager = manager;
        manager.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                SurfaceRendererPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    @Override
    protected void internalRelease() {
        if (this.isValid()) {
            this.releaseTarget();
        }
        super.internalRelease();
    }

    @Override
    public void setSurface(@Nullable Object surface) throws IllegalStateException, IllegalArgumentException {
        this.setSurface(surface, null);
    }

    @Override
    public void setSurface(final @Nullable Object surface, final @Nullable Fraction maxFps) throws IllegalStateException, IllegalArgumentException {
        if (!this.isValid()) {
            throw new IllegalStateException("already released?");
        }
        if (surface != null && !GLUtils.isSupportedSurface(surface)) {
            throw new IllegalArgumentException("Unsupported surface type!," + surface);
        }
        this.mManager.runOnGLThread(new Runnable(){

            @Override
            public void run() {
                SurfaceRendererPipeline.this.createTargetOnGL(surface, maxFps);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.mManager.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getId() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mRendererTarget != null ? this.mRendererTarget.getId() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMirror(int mirror) {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mMirror != mirror) {
                this.mMirror = mirror;
                this.mManager.runOnGLThread(() -> {
                    if (this.mRendererTarget != null) {
                        this.mRendererTarget.setMirror(IMirror.flipVertical(mirror));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mMirror;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void onFrameAvailable(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
        super.onFrameAvailable(isOES, texId, texMatrix);
        if (this.isValid()) {
            RendererTarget target;
            GLDrawer2D drawer;
            Object object = this.mSync;
            synchronized (object) {
                if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
                    if (this.mDrawer != null) {
                        this.mDrawer.release();
                    }
                    this.mDrawer = GLDrawer2D.create(this.mManager.isGLES3(), isOES);
                }
                drawer = this.mDrawer;
                target = this.mRendererTarget;
            }
            if (target != null && target.canDraw()) {
                target.draw(drawer, 33984, texId, texMatrix);
            }
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isValid()) {
            this.mManager.runOnGLThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @WorkerThread
                public void run() {
                    GLDrawer2D drawer;
                    Object object = SurfaceRendererPipeline.this.mSync;
                    synchronized (object) {
                        drawer = SurfaceRendererPipeline.this.mDrawer;
                        SurfaceRendererPipeline.this.mDrawer = null;
                    }
                    if (drawer != null) {
                        drawer.release();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
        Object object = this.mSync;
        synchronized (object) {
            Object object2 = this.mSync;
            synchronized (object2) {
                if (this.mRendererTarget != null && this.mRendererTarget.getSurface() != surface) {
                    this.mRendererTarget.release();
                    this.mRendererTarget = null;
                }
                if (this.mRendererTarget == null && surface != null) {
                    this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                }
                if (this.mRendererTarget != null) {
                    this.mRendererTarget.setMirror(IMirror.flipVertical(this.mMirror));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void releaseTarget() {
        RendererTarget target;
        GLDrawer2D drawer;
        Object object = this.mSync;
        synchronized (object) {
            drawer = this.mDrawer;
            this.mDrawer = null;
            target = this.mRendererTarget;
            this.mRendererTarget = null;
        }
        if ((drawer != null || target != null) && this.mManager.isValid()) {
            try {
                this.mManager.runOnGLThread(new Runnable(){

                    @Override
                    @WorkerThread
                    public void run() {
                        if (drawer != null) {
                            drawer.release();
                        }
                        if (target != null) {
                            target.release();
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

