/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.androidutils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.serenegiant.androidutils.AndroidUtilsFragment;
import com.serenegiant.androidutils.IAndroidUtils;
import com.serenegiant.system.PermissionCheck;
import java.util.Random;

@Keep
public final class AndroidUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = AndroidUtils.class.getSimpleName();
    static final String EVENT_ON_START = "OnStartEvent";
    static final String EVENT_ON_RESUME = "OnResumeEvent";
    static final String EVENT_ON_PAUSE = "OnPauseEvent";
    static final String EVENT_ON_STOP = "OnStopEvent";
    static final String EVENT_ON_PERMISSION_GRANT = "OnPermissionGrant";
    static final String EVENT_ON_PERMISSION_DENY = "OnPermissionDeny";
    static final String EVENT_ON_PERMISSION_DENY_AND_NEVER_ASK_AGAIN = "OnPermissionDenyAndNeverAskAgain";
    static final String ARGS_KEY_CALLBACK_UNITY_OBJECT_NAME = "ARGS_KEY_CALLBACK_UNITY_OBJECT_NAME";
    static final int REQUEST_CODE = new Random().nextInt(65535);

    public static void initialize(@NonNull Activity activity, @NonNull String callbackUnityObjName) {
        FragmentManager fm = activity.getFragmentManager();
        Fragment utils = fm.findFragmentByTag(AndroidUtils.class.getName());
        if (!(utils instanceof IAndroidUtils)) {
            FragmentTransaction ft = fm.beginTransaction();
            if (utils != null) {
                ft.remove(utils);
            }
            utils = new AndroidUtilsFragment();
            Bundle args = new Bundle();
            args.putString(ARGS_KEY_CALLBACK_UNITY_OBJECT_NAME, callbackUnityObjName);
            utils.setArguments(args);
            ft.add(utils, AndroidUtils.class.getName()).commit();
        }
    }

    public static boolean hasPermission(@NonNull Activity activity, @NonNull String permission) throws IllegalStateException {
        IAndroidUtils utils = AndroidUtils.requireUtils(activity);
        return PermissionCheck.checkSelfPermission((Context)activity, (String)permission) == 0;
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Activity activity, @NonNull String permission) throws IllegalStateException {
        if (Build.VERSION.SDK_INT >= 23) {
            return activity.shouldShowRequestPermissionRationale(permission);
        }
        return true;
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermission(@NonNull Activity activity, @NonNull String permission) throws IllegalStateException {
        IAndroidUtils utils = AndroidUtils.requireUtils(activity);
        if (Build.VERSION.SDK_INT >= 23) {
            utils.requestPermission(permission, REQUEST_CODE);
        } else {
            utils.processPermission(permission, 0);
        }
    }

    public static void grantPermission(@NonNull Activity activity, @NonNull String permission) throws IllegalStateException {
        IAndroidUtils utils = AndroidUtils.requireUtils(activity);
        if (Build.VERSION.SDK_INT >= 23) {
            utils.grantPermission(permission, REQUEST_CODE);
        } else {
            utils.processPermission(permission, 0);
        }
    }

    public static void showAppSettings(@NonNull Activity activity) {
        String uriString = "package:" + activity.getPackageName();
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.parse((String)uriString));
        activity.startActivity(intent);
    }

    private static IAndroidUtils requireUtils(@NonNull Activity activity) throws IllegalStateException {
        FragmentManager fm = activity.getFragmentManager();
        Fragment utils = fm.findFragmentByTag(AndroidUtils.class.getName());
        if (!(utils instanceof IAndroidUtils)) {
            throw new IllegalStateException();
        }
        return (IAndroidUtils)utils;
    }
}

