/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.utils.BufferHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.MessageDigest;

public class HashUtils {
    private static final boolean DEBUG = false;
    private static final String TAG = HashUtils.class.getSimpleName();
    public static final String HASH_ALGORITHM_MD2 = "MD2";
    public static final String HASH_ALGORITHM_MD5 = "MD5";
    public static final String HASH_ALGORITHM_SHA1 = "SHA-1";
    public static final String HASH_ALGORITHM_SHA224 = "SHA-224";
    public static final String HASH_ALGORITHM_SHA256 = "SHA-256";
    public static final String HASH_ALGORITHM_SHA384 = "SHA-384";
    public static final String HASH_ALGORITHM_SHA512_224 = "SHA-512/224";
    public static final String HASH_ALGORITHM_SHA512_256 = "SHA-512/256";
    public static final String HASH_ALGORITHM_SHA3_224 = "SHA3-224";
    public static final String HASH_ALGORITHM_SHA3_256 = "SHA3-256";
    public static final String HASH_ALGORITHM_SHA3_384 = "SHA3-384";
    public static final String HASH_ALGORITHM_SHA3_512 = "SHA3-512";

    private HashUtils() {
    }

    @Nullable
    public static byte[] getDigest(@NonNull String algorithm, @NonNull byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            return digest.digest(data);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public static String getDigestString(@NonNull String algorithm, @NonNull byte[] data) {
        try {
            return BufferHelper.toHexString(HashUtils.getDigest(algorithm, data));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HashAlgorithm {
    }
}

