/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.TextUtils;
import com.serenegiant.system.BuildCheck;
import java.io.BufferedReader;
import java.io.FileReader;
import org.json.JSONException;
import org.json.JSONObject;

public final class DeviceInfo {
    private DeviceInfo() {
    }

    @SuppressLint(value={"NewApi"})
    public static JSONObject get() throws JSONException {
        JSONObject result = new JSONObject();
        try {
            result.put("BUILD", (Object)Build.ID);
        }
        catch (Exception e) {
            result.put("BUILD", (Object)e.getMessage());
        }
        try {
            result.put("DISPLAY", (Object)Build.DISPLAY);
        }
        catch (Exception e) {
            result.put("DISPLAY", (Object)e.getMessage());
        }
        try {
            result.put("PRODUCT", (Object)Build.PRODUCT);
        }
        catch (Exception e) {
            result.put("PRODUCT", (Object)e.getMessage());
        }
        try {
            result.put("DEVICE", (Object)Build.DEVICE);
        }
        catch (Exception e) {
            result.put("DEVICE", (Object)e.getMessage());
        }
        try {
            result.put("BOARD", (Object)Build.BOARD);
        }
        catch (Exception e) {
            result.put("BOARD", (Object)e.getMessage());
        }
        try {
            result.put("MANUFACTURER", (Object)Build.MANUFACTURER);
        }
        catch (Exception e) {
            result.put("MANUFACTURER", (Object)e.getMessage());
        }
        try {
            result.put("BRAND", (Object)Build.BRAND);
        }
        catch (Exception e) {
            result.put("BRAND", (Object)e.getMessage());
        }
        try {
            result.put("MODEL", (Object)Build.MODEL);
        }
        catch (Exception e) {
            result.put("MODEL", (Object)e.getMessage());
        }
        try {
            result.put("BOOTLOADER", (Object)Build.BOOTLOADER);
        }
        catch (Exception e) {
            result.put("BOOTLOADER", (Object)e.getMessage());
        }
        try {
            result.put("HARDWARE", (Object)Build.HARDWARE);
        }
        catch (Exception e) {
            result.put("HARDWARE", (Object)e.getMessage());
        }
        if (BuildCheck.isAndroid5()) {
            int i;
            int n;
            JSONObject temp;
            try {
                String[] supported_abis = Build.SUPPORTED_ABIS;
                if (supported_abis != null && supported_abis.length > 0) {
                    temp = new JSONObject();
                    n = supported_abis.length;
                    for (i = 0; i < n; ++i) {
                        temp.put(Integer.toString(i), (Object)supported_abis[i]);
                    }
                    result.put("SUPPORTED_ABIS", (Object)temp);
                }
            }
            catch (Exception e) {
                result.put("SUPPORTED_ABIS", (Object)e.getMessage());
            }
            try {
                String[] supported_abis32 = Build.SUPPORTED_32_BIT_ABIS;
                if (supported_abis32 != null && supported_abis32.length > 0) {
                    temp = new JSONObject();
                    n = supported_abis32.length;
                    for (i = 0; i < n; ++i) {
                        temp.put(Integer.toString(i), (Object)supported_abis32[i]);
                    }
                    result.put("SUPPORTED_32_BIT_ABIS", (Object)temp);
                }
            }
            catch (Exception e) {
                result.put("SUPPORTED_32_BIT_ABIS", (Object)e.getMessage());
            }
            try {
                String[] supported_abis64 = Build.SUPPORTED_64_BIT_ABIS;
                if (supported_abis64 != null && supported_abis64.length > 0) {
                    temp = new JSONObject();
                    n = supported_abis64.length;
                    for (i = 0; i < n; ++i) {
                        temp.put(Integer.toString(i), (Object)supported_abis64[i]);
                    }
                    result.put("SUPPORTED_64_BIT_ABIS", (Object)temp);
                }
            }
            catch (Exception e) {
                result.put("SUPPORTED_64_BIT_ABIS", (Object)e.getMessage());
            }
        } else {
            try {
                JSONObject temp = new JSONObject();
                temp.put("0", (Object)Build.CPU_ABI);
                temp.put("1", (Object)Build.CPU_ABI2);
                result.put("SUPPORTED_ABIS", (Object)temp);
            }
            catch (Exception e) {
                result.put("SUPPORTED_ABIS", (Object)e.getMessage());
            }
        }
        try {
            result.put("RELEASE", (Object)Build.VERSION.RELEASE);
        }
        catch (Exception e) {
            result.put("RELEASE", (Object)e.getMessage());
        }
        try {
            result.put("API_LEVEL", Build.VERSION.SDK_INT);
        }
        catch (Exception e) {
            result.put("API_LEVEL", (Object)e.getMessage());
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader("/proc/version"), 512);
            String proc_version = reader.readLine();
            reader.close();
            result.put("PROC_VERSION", (Object)proc_version);
        }
        catch (Exception e) {
            result.put("PROC_VERSION", (Object)e.getMessage());
        }
        JSONObject cpu_info = new JSONObject();
        int i = 0;
        try {
            String proc_cpuinfo;
            BufferedReader reader = new BufferedReader(new FileReader("/proc/cpuinfo"), 512);
            while ((proc_cpuinfo = reader.readLine()) != null) {
                if (!TextUtils.isEmpty((CharSequence)proc_cpuinfo)) {
                    cpu_info.put(Integer.toString(i++), (Object)proc_cpuinfo);
                }
                if (proc_cpuinfo != null) continue;
            }
            reader.close();
            result.put("PROC_CPUINFO", (Object)cpu_info);
        }
        catch (Exception e) {
            result.put("PROC_CPUINFO", (Object)e.getMessage());
        }
        return result;
    }
}

