/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.system;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.preference.PreferenceManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.system.ContextUtils;
import com.serenegiant.utils.LogUtils;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class CrashExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashExceptionHandler.class.getSimpleName();
    static final String LOG_NAME = "crashrepo.txt";
    static final String MAIL_TO = "t_saki@serenegiant.com";
    private static final int REQUEST_RESTART_ACTIVITY = 2039;
    private final WeakReference<Context> mWeakContext;
    private final Thread.UncaughtExceptionHandler mHandler;

    public static void registerCrashHandler(@NonNull Context app_context) {
        Thread.setDefaultUncaughtExceptionHandler(new CrashExceptionHandler(app_context));
    }

    @Deprecated
    public static void setAutoRestart(final @NonNull Context context, final @NonNull PendingIntent restartIntent, final long delayMs) {
        final Thread.UncaughtExceptionHandler original = Thread.getDefaultUncaughtExceptionHandler();
        Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
                try {
                    AlarmManager am = ContextUtils.requireSystemService(context, AlarmManager.class);
                    am.set(0, System.currentTimeMillis() + delayMs, restartIntent);
                }
                finally {
                    original.uncaughtException(thread, throwable);
                }
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }

    @Deprecated
    @SuppressLint(value={"InlinedApi"})
    public static void setAutoRestart(@NonNull Context context, @NonNull Class<? extends Activity> activityClass, long delayMs) {
        int flags = 0x10000000;
        if (BuildCheck.isAPI31()) {
            flags |= 0x4000000;
        }
        PendingIntent intent = PendingIntent.getActivity((Context)context.getApplicationContext(), (int)2039, (Intent)Intent.makeMainActivity((ComponentName)new ComponentName(context, activityClass)), (int)flags);
        CrashExceptionHandler.setAutoRestart(context, intent, delayMs);
    }

    private CrashExceptionHandler(@NonNull Context context) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(@NonNull Thread thread, @NonNull Throwable throwable) {
        Context context = (Context)this.mWeakContext.get();
        if (context != null) {
            try (PrintWriter writer = null;){
                FileOutputStream out = context.openFileOutput(LOG_NAME, 0);
                writer = new PrintWriter(out);
                JSONObject json = new JSONObject();
                json.put("Build", (Object)CrashExceptionHandler.getBuildInfo());
                json.put("PackageInfo", (Object)CrashExceptionHandler.getPackageInfo(context));
                json.put("Exception", (Object)CrashExceptionHandler.getExceptionInfo(throwable));
                json.put("SharedPreferences", (Object)CrashExceptionHandler.getPreferencesInfo(context));
                writer.print(json.toString());
                writer.flush();
            }
        }
        try {
            if (this.mHandler != null) {
                this.mHandler.uncaughtException(thread, throwable);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    private static JSONObject getBuildInfo() throws JSONException {
        JSONObject buildJson = new JSONObject();
        buildJson.put("BRAND", (Object)Build.BRAND);
        buildJson.put("MODEL", (Object)Build.MODEL);
        buildJson.put("DEVICE", (Object)Build.DEVICE);
        buildJson.put("MANUFACTURER", (Object)Build.MANUFACTURER);
        buildJson.put("VERSION.SDK_INT", Build.VERSION.SDK_INT);
        buildJson.put("VERSION.RELEASE", (Object)Build.VERSION.RELEASE);
        return buildJson;
    }

    private static JSONObject getPackageInfo(@NonNull Context context) throws JSONException {
        JSONObject packageInfoJson = new JSONObject();
        try {
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            packageInfoJson.put("packageName", (Object)info.packageName);
            packageInfoJson.put("versionCode", info.versionCode);
            packageInfoJson.put("versionName", (Object)info.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfoJson.put("error", (Object)e);
        }
        return packageInfoJson;
    }

    private static JSONObject getExceptionInfo(Throwable throwable) throws JSONException {
        JSONObject exceptionJson = new JSONObject();
        exceptionJson.put("name", (Object)throwable.getClass().getName());
        exceptionJson.put("cause", (Object)throwable.getCause());
        exceptionJson.put("message", (Object)throwable.getMessage());
        JSONArray stackTrace = new JSONArray();
        for (StackTraceElement element : throwable.getStackTrace()) {
            stackTrace.put((Object)("at " + LogUtils.getMetaInfo(element)));
        }
        exceptionJson.put("stacktrace", (Object)stackTrace);
        return exceptionJson;
    }

    private static JSONObject getPreferencesInfo(@NonNull Context context) throws JSONException {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        JSONObject preferencesJson = new JSONObject();
        Map map = preferences.getAll();
        for (Map.Entry entry : map.entrySet()) {
            preferencesJson.put((String)entry.getKey(), entry.getValue());
        }
        return preferencesJson;
    }
}

