/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TimePicker;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.common.R;
import com.serenegiant.preference.DialogPreferenceV7;
import com.serenegiant.utils.TypedArrayUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimePickerPreferenceV7
extends DialogPreferenceV7 {
    private final Calendar calendar;
    private final long mDefaultValue;
    private TimePicker picker = null;

    public TimePickerPreferenceV7(@NonNull Context context) {
        this(context, null);
    }

    public TimePickerPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, TypedArrayUtils.getAttr(context, R.attr.dialogPreferenceStyle, 0x1010091));
    }

    public TimePickerPreferenceV7(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        this.mDefaultValue = (long)a.getFloat(R.styleable.TimePicker_TimePickerDefaultValue, -1.0f);
        a.recycle();
        this.setPositiveButtonText(17039370);
        this.setNegativeButtonText(0x1040000);
        this.calendar = new GregorianCalendar();
    }

    @Override
    protected View onCreateDialogView() {
        this.picker = new TimePicker(this.getContext());
        this.picker.setIs24HourView(Boolean.valueOf(true));
        return this.picker;
    }

    @Override
    protected void onBindDialogView(@NonNull View view) {
        super.onBindDialogView(view);
        this.picker.setCurrentHour(Integer.valueOf(this.calendar.get(11)));
        this.picker.setCurrentMinute(Integer.valueOf(this.calendar.get(12)));
    }

    @Override
    protected void onDialogClosed(boolean positiveResult) {
        super.onDialogClosed(positiveResult);
        if (positiveResult) {
            this.calendar.set(11, this.picker.getCurrentHour());
            this.calendar.set(12, this.picker.getCurrentMinute());
            this.setSummary(this.getSummary());
            if (this.callChangeListener(this.calendar.getTimeInMillis())) {
                this.persistLong(this.calendar.getTimeInMillis());
                this.notifyChanged();
            }
        }
    }

    protected Object onGetDefaultValue(TypedArray a, int index) {
        return a.getString(index);
    }

    protected void onSetInitialValue(@Nullable Object defaultValue) {
        long value;
        long l = value = this.mDefaultValue > 0L ? this.mDefaultValue : System.currentTimeMillis();
        if (defaultValue instanceof String) {
            value = Long.parseLong((String)defaultValue);
        } else if (defaultValue instanceof Long) {
            value = (Long)defaultValue;
        }
        this.calendar.setTimeInMillis(value);
        this.persistLong(this.calendar.getTimeInMillis());
        this.setSummary(this.getSummary());
    }

    public CharSequence getSummary() {
        if (this.calendar == null) {
            return super.getSummary();
        }
        return DateFormat.getTimeFormat((Context)this.getContext()).format(new Date(this.calendar.getTimeInMillis()));
    }
}

