/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.net;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Collections;
import java.util.Enumeration;

public class UdpSocket {
    private DatagramChannel channel;
    @NonNull
    private final InetSocketAddress broadcast;
    @NonNull
    private final String localAddress;
    private String remoteAddress;
    private int remotePort;

    public UdpSocket(int port) throws SocketException {
        try {
            InetAddress address = null;
            this.channel = DatagramChannel.open();
            this.channel.configureBlocking(false);
            DatagramSocket sock = this.channel.socket();
            sock.setBroadcast(true);
            sock.setReuseAddress(true);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface intf : Collections.list(interfaces)) {
                if (intf.isLoopback()) continue;
                Enumeration<InetAddress> inetAddresses = intf.getInetAddresses();
                for (InetAddress addr : Collections.list(inetAddresses)) {
                    if (!(addr instanceof Inet4Address)) continue;
                    address = addr;
                }
            }
            this.localAddress = address.getHostAddress();
            sock.bind(new InetSocketAddress(InetAddress.getByAddress(new byte[]{0, 0, 0, 0}), port));
            byte[] addr = address.getAddress();
            addr[3] = -1;
            InetAddress broadcast_addr = InetAddress.getByAddress(addr);
            this.broadcast = new InetSocketAddress(broadcast_addr, port);
        }
        catch (Exception e) {
            throw new SocketException("UdpSocket#constructor:" + e);
        }
    }

    public void release() {
        if (this.channel != null) {
            try {
                try {
                    this.setSoTimeout(200);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel = null;
    }

    public DatagramChannel channel() {
        return this.channel;
    }

    public DatagramSocket socket() {
        return this.channel.socket();
    }

    public void setReceiveBufferSize(int sz) throws SocketException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            socket.setReceiveBufferSize(sz);
        }
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            socket.setReuseAddress(reuse);
        }
    }

    public boolean getReuseAddress() throws SocketException, IllegalStateException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            return socket.getReuseAddress();
        }
        throw new IllegalStateException("already released");
    }

    public void setBroadcast(boolean broadcast) throws SocketException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            socket.setBroadcast(broadcast);
        }
    }

    public boolean getBroadcast() throws SocketException, IllegalStateException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            return socket.getBroadcast();
        }
        throw new IllegalStateException("already released");
    }

    public void setSoTimeout(int timeout) throws SocketException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            socket.setSoTimeout(timeout);
        }
    }

    public int getSoTimeout() throws SocketException, IllegalStateException {
        DatagramSocket socket;
        DatagramSocket datagramSocket = socket = this.channel != null ? this.channel.socket() : null;
        if (socket != null) {
            return socket.getSoTimeout();
        }
        throw new IllegalStateException("already released");
    }

    @NonNull
    public String local() {
        return this.localAddress;
    }

    @Nullable
    public String remote() {
        return this.remoteAddress;
    }

    public int remotePort() {
        return this.remotePort;
    }

    public void broadcast(@NonNull ByteBuffer buffer) throws IOException, IllegalStateException {
        if (this.channel == null) {
            throw new IllegalStateException("already released");
        }
        this.channel.send(buffer, this.broadcast);
    }

    public void broadcast(@NonNull byte[] bytes) throws IOException, IllegalStateException {
        this.broadcast(ByteBuffer.wrap(bytes));
    }

    public int receive(@NonNull ByteBuffer buffer) throws IOException, IllegalStateException {
        if (this.channel == null) {
            throw new IllegalStateException("already released");
        }
        int read = buffer.remaining();
        SocketAddress sender = this.channel.receive(buffer);
        if (sender == null) {
            return -1;
        }
        InetSocketAddress remote = (InetSocketAddress)sender;
        this.remoteAddress = remote.getAddress().getHostAddress();
        this.remotePort = remote.getPort();
        return read - buffer.remaining();
    }
}

