/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.mediastore;

import android.content.AsyncQueryHandler;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cursoradapter.widget.CursorAdapter;
import com.serenegiant.common.R;
import com.serenegiant.graphics.BitmapHelper;
import com.serenegiant.mediastore.MediaInfo;
import com.serenegiant.mediastore.MediaStoreUtils;
import com.serenegiant.mediastore.ThumbnailCache;
import com.serenegiant.mediastore.ThumbnailLoader;
import com.serenegiant.mediastore.ThumbnailLoaderDrawable;
import com.serenegiant.utils.ThreadPool;
import com.serenegiant.view.ViewUtils;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MediaStoreAdapter
extends CursorAdapter {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaStoreAdapter.class.getSimpleName();
    private int mThumbnailWidth = 200;
    private int mThumbnailHeight = 200;
    @NonNull
    private final Context mContext;
    @NonNull
    private final LayoutInflater mInflater;
    private final int mLayoutId;
    @NonNull
    private final MyAsyncQueryHandler mQueryHandler;
    @NonNull
    private final ThumbnailCache mThumbnailCache;
    private String mSelection;
    private String[] mSelectionArgs;
    private boolean mShowTitle = false;
    private int mMediaType = 0;
    @NonNull
    private final MediaInfo info = new MediaInfo();
    private boolean mNeedValidate;

    public MediaStoreAdapter(@NonNull Context context, @LayoutRes int id_layout) {
        this(context, id_layout, true);
    }

    public MediaStoreAdapter(@NonNull Context context, @LayoutRes int id_layout, boolean refreshNow) {
        super(context, null, 2);
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        this.mQueryHandler = new MyAsyncQueryHandler(context.getContentResolver(), this);
        this.mLayoutId = id_layout;
        this.mThumbnailCache = new ThumbnailCache(context);
        this.mNeedValidate = true;
        if (refreshNow) {
            this.refresh();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.changeCursor(null);
        }
        finally {
            super.finalize();
        }
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        View view = this.mInflater.inflate(this.mLayoutId, parent, false);
        this.getViewHolder(view);
        return view;
    }

    public void bindView(View view, Context context, Cursor cursor) {
        ViewHolder holder = this.getViewHolder(view);
        ImageView iv = holder.mImageView;
        TextView tv = holder.mTitleView;
        Drawable drawable2 = iv.getDrawable();
        if (!(drawable2 instanceof ThumbnailLoaderDrawable)) {
            drawable2 = this.createLoaderDrawable(this.mContext);
            iv.setImageDrawable(drawable2);
        }
        this.info.loadFromCursor(cursor);
        ((ThumbnailLoaderDrawable)drawable2).startLoad(this.info);
        if (tv != null) {
            tv.setVisibility(this.mShowTitle ? 0 : 8);
            if (this.mShowTitle) {
                tv.setText((CharSequence)cursor.getString(1));
            }
        }
    }

    protected ThumbnailLoaderDrawable createLoaderDrawable(@NonNull Context context) {
        return new MyThumbnailLoaderDrawable(context, this.mThumbnailWidth, this.mThumbnailHeight);
    }

    private ViewHolder getViewHolder(View view) {
        ViewHolder holder = (ViewHolder)view.getTag(R.id.mediastorephotoadapter);
        if (holder == null) {
            holder = new ViewHolder();
            holder.mImageView = ViewUtils.findIconView(view);
            holder.mTitleView = ViewUtils.findTitleView(view);
            view.setTag(R.id.mediastorephotoadapter, (Object)holder);
        }
        return holder;
    }

    protected void onContentChanged() {
        this.mQueryHandler.requery();
    }

    public void refresh() {
        ThreadPool.preStartAllCoreThreads();
        this.onContentChanged();
    }

    public void setValidateItems(boolean needValidate) {
        if (this.mNeedValidate != needValidate) {
            this.mNeedValidate = needValidate;
        }
    }

    public int getPositionFromId(long id2) {
        int result = -1;
        int n = this.getCount();
        MediaInfo info = new MediaInfo();
        for (int i = 0; i < n; ++i) {
            this.getMediaInfo(i, info);
            if (info.id != id2) continue;
            result = i;
            break;
        }
        return result;
    }

    public Bitmap getImage(int position, int width, int height) throws FileNotFoundException, IOException {
        return BitmapHelper.asBitmap(this.mContext.getContentResolver(), this.getItemId(position), width, height);
    }

    @NonNull
    public MediaInfo getMediaInfo(int position) {
        return this.getMediaInfo(position, null);
    }

    @NonNull
    public synchronized MediaInfo getMediaInfo(int position, @Nullable MediaInfo info) {
        MediaInfo _info = info != null ? info : new MediaInfo();
        Cursor cursor = (Cursor)super.getItem(position);
        if (cursor == null) {
            throw new IllegalStateException("Cursor is not ready!");
        }
        _info.loadFromCursor(cursor);
        return _info;
    }

    public void setThumbnailSize(int size) {
        if (this.mThumbnailWidth != size || this.mThumbnailHeight != size) {
            this.mThumbnailWidth = this.mThumbnailHeight = size;
            this.mThumbnailCache.clear();
            this.onContentChanged();
        }
    }

    public void setThumbnailSize(int width, int height) {
        if (this.mThumbnailWidth != width || this.mThumbnailHeight != height) {
            this.mThumbnailWidth = width;
            this.mThumbnailHeight = height;
            this.mThumbnailCache.clear();
            this.onContentChanged();
        }
    }

    public void setShowTitle(boolean showTitle) {
        if (this.mShowTitle != showTitle) {
            this.mShowTitle = showTitle;
            this.onContentChanged();
        }
    }

    public boolean getShowTitle() {
        return this.mShowTitle;
    }

    public int getMediaType() {
        return this.mMediaType % 3;
    }

    public void setMediaType(int media_type) {
        if (this.mMediaType != media_type % 3) {
            this.mMediaType = media_type % 3;
            this.onContentChanged();
        }
    }

    static /* synthetic */ String[] access$302(MediaStoreAdapter x0, String[] x1) {
        x0.mSelectionArgs = x1;
        return x1;
    }

    private class MyThumbnailLoader
    extends ThumbnailLoader {
        public MyThumbnailLoader(MyThumbnailLoaderDrawable parent) {
            super(parent);
        }

        @Override
        @Nullable
        protected Bitmap loadThumbnail(@NonNull Context context, @NonNull MediaInfo info, int requestWidth, int requestHeight) {
            Bitmap result = null;
            try {
                result = MediaStoreAdapter.this.mThumbnailCache.getThumbnail(context.getContentResolver(), info, requestWidth, requestHeight);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    }

    private class MyThumbnailLoaderDrawable
    extends ThumbnailLoaderDrawable {
        public MyThumbnailLoaderDrawable(Context context, int width, int height) {
            super(context, width, height);
        }

        @Override
        @NonNull
        protected ThumbnailLoader createLoader() {
            return new MyThumbnailLoader(this);
        }

        @Override
        protected Bitmap checkCache(long id2) {
            return MediaStoreAdapter.this.mThumbnailCache.get(id2);
        }

        @Override
        protected void setBitmap(@Nullable Bitmap bitmap) {
            Bitmap _bitmap = bitmap;
            if (_bitmap == null) {
                _bitmap = BitmapHelper.fromDrawable(this.getContext(), R.drawable.ic_error_outline_red_24dp);
            }
            super.setBitmap(_bitmap);
        }
    }

    private static final class ViewHolder {
        TextView mTitleView;
        ImageView mImageView;

        private ViewHolder() {
        }
    }

    private static final class MyAsyncQueryHandler
    extends AsyncQueryHandler {
        private final MediaStoreAdapter mAdapter;

        public MyAsyncQueryHandler(ContentResolver cr, MediaStoreAdapter adapter) {
            super(cr);
            this.mAdapter = adapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requery() {
            MediaStoreAdapter mediaStoreAdapter = this.mAdapter;
            synchronized (mediaStoreAdapter) {
                this.mAdapter.changeCursor(null);
                this.mAdapter.mSelection = MediaStoreUtils.SELECTIONS[this.mAdapter.mMediaType % 3];
                MediaStoreAdapter.access$302(this.mAdapter, null);
                this.startQuery(0, (Object)this.mAdapter, MediaStoreUtils.QUERY_URI_FILES, MediaStoreUtils.PROJ_MEDIA, this.mAdapter.mSelection, this.mAdapter.mSelectionArgs, null);
            }
        }

        protected void onQueryComplete(int token, Object cookie, Cursor cursor) {
            Cursor oldCursor = this.mAdapter.swapCursor(cursor);
            if (oldCursor != null && !oldCursor.isClosed()) {
                oldCursor.close();
            }
        }
    }
}

