/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.BufferHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaCodecUtils {
    private static final String TAG = MediaCodecUtils.class.getSimpleName();
    public static final String MIME_VIDEO_AVC = "video/avc";
    public static final String MIME_AUDIO_AAC = "audio/mp4a-latm";
    @SuppressLint(value={"InlinedApi"})
    public static final int BUFFER_FLAG_KEY_FRAME = BuildCheck.isLollipop() ? 1 : 1;
    public static final byte[] START_MARKER = BufferHelper.ANNEXB_START_MARK;
    public static final int OMX_COLOR_FormatUnused = 0;
    public static final int OMX_COLOR_FormatMonochrome = 1;
    public static final int OMX_COLOR_Format8bitRGB332 = 2;
    public static final int OMX_COLOR_Format12bitRGB444 = 3;
    public static final int OMX_COLOR_Format16bitARGB4444 = 4;
    public static final int OMX_COLOR_Format16bitARGB1555 = 5;
    public static final int OMX_COLOR_Format16bitRGB565 = 6;
    public static final int OMX_COLOR_Format16bitBGR565 = 7;
    public static final int OMX_COLOR_Format18bitRGB666 = 8;
    public static final int OMX_COLOR_Format18bitARGB1665 = 9;
    public static final int OMX_COLOR_Format19bitARGB1666 = 10;
    public static final int OMX_COLOR_Format24bitRGB888 = 11;
    public static final int OMX_COLOR_Format24bitBGR888 = 12;
    public static final int OMX_COLOR_Format24bitARGB1887 = 13;
    public static final int OMX_COLOR_Format25bitARGB1888 = 14;
    public static final int OMX_COLOR_Format32bitBGRA8888 = 15;
    public static final int OMX_COLOR_Format32bitARGB8888 = 16;
    public static final int OMX_COLOR_FormatYUV411Planar = 17;
    public static final int OMX_COLOR_FormatYUV411PackedPlanar = 18;
    public static final int OMX_COLOR_FormatYUV420Planar = 19;
    public static final int OMX_COLOR_FormatYUV420PackedPlanar = 20;
    public static final int OMX_COLOR_FormatYUV420SemiPlanar = 21;
    public static final int OMX_COLOR_FormatYUV422Planar = 22;
    public static final int OMX_COLOR_FormatYUV422PackedPlanar = 23;
    public static final int OMX_COLOR_FormatYUV422SemiPlanar = 24;
    public static final int OMX_COLOR_FormatYCbYCr = 25;
    public static final int OMX_COLOR_FormatYCrYCb = 26;
    public static final int OMX_COLOR_FormatCbYCrY = 27;
    public static final int OMX_COLOR_FormatCrYCbY = 28;
    public static final int OMX_COLOR_FormatYUV444Interleaved = 29;
    public static final int OMX_COLOR_FormatRawBayer8bit = 30;
    public static final int OMX_COLOR_FormatRawBayer10bit = 31;
    public static final int OMX_COLOR_FormatRawBayer8bitcompressed = 32;
    public static final int OMX_COLOR_FormatL2 = 33;
    public static final int OMX_COLOR_FormatL4 = 34;
    public static final int OMX_COLOR_FormatL8 = 35;
    public static final int OMX_COLOR_FormatL16 = 36;
    public static final int OMX_COLOR_FormatL24 = 37;
    public static final int OMX_COLOR_FormatL32 = 38;
    public static final int OMX_COLOR_FormatYUV420PackedSemiPlanar = 39;
    public static final int OMX_COLOR_FormatYUV422PackedSemiPlanar = 40;
    public static final int OMX_COLOR_Format18BitBGR666 = 41;
    public static final int OMX_COLOR_Format24BitARGB6666 = 42;
    public static final int OMX_COLOR_Format24BitABGR6666 = 43;
    public static final int OMX_COLOR_FormatKhronosExtensions = 0x6F000000;
    public static final int OMX_COLOR_FormatVendorStartUnused = 0x7F000000;
    public static final int OMX_COLOR_FormatAndroidOpaque = 2130708361;
    public static final int OMX_TI_COLOR_FormatYUV420PackedSemiPlanar = 2130706688;
    public static final int OMX_QCOM_COLOR_FormatYVU420SemiPlanar = 2141391872;
    public static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    public static final int OMX_SEC_COLOR_FormatNV12Tiled = 2143289346;
    public static final int OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar32m = 2141391876;
    public static final int OMX_COLOR_FormatMax = Integer.MAX_VALUE;
    private static final List<MediaCodecInfo> sCodecList = new ArrayList<MediaCodecInfo>();
    private static final HashMap<String, HashMap<MediaCodecInfo, MediaCodecInfo.CodecCapabilities>> sCapabilities = new HashMap();
    public static int[] recognizedFormats = new int[]{19, 21, 2141391872};

    private MediaCodecUtils() {
    }

    public static JSONObject get() throws JSONException {
        JSONObject result = new JSONObject();
        try {
            result.put("VIDEO", (Object)MediaCodecUtils.getVideo());
        }
        catch (Exception e) {
            result.put("VIDEO", (Object)e.getMessage());
        }
        try {
            result.put("AUDIO", (Object)MediaCodecUtils.getAudio());
        }
        catch (Exception e) {
            result.put("AUDIO", (Object)e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final JSONObject getVideo() throws JSONException {
        JSONObject result = new JSONObject();
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            JSONObject codec = new JSONObject();
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            boolean isvideo = false;
            for (int j = 0; j < n; ++j) {
                int k;
                int m;
                MediaCodecInfo.CodecCapabilities capabilities;
                if (!types[j].startsWith("video/")) continue;
                isvideo = true;
                codec.put(Integer.toString(j), (Object)types[j]);
                Thread.currentThread().setPriority(10);
                try {
                    capabilities = MediaCodecUtils.getCodecCapabilities(codecInfo, types[j]);
                }
                finally {
                    Thread.currentThread().setPriority(5);
                }
                try {
                    int[] colorFormats = capabilities.colorFormats;
                    int n2 = m = colorFormats != null ? colorFormats.length : 0;
                    if (m > 0) {
                        JSONObject caps = new JSONObject();
                        for (k = 0; k < m; ++k) {
                            caps.put(String.format(Locale.US, "COLOR_FORMAT(%d)", k), (Object)MediaCodecUtils.getColorFormatName(colorFormats[k]));
                        }
                        codec.put("COLOR_FORMATS", (Object)caps);
                    }
                }
                catch (Exception e) {
                    codec.put("COLOR_FORMATS", (Object)e.getMessage());
                }
                try {
                    MediaCodecInfo.CodecProfileLevel[] profileLevel = capabilities.profileLevels;
                    int n3 = m = profileLevel != null ? profileLevel.length : 0;
                    if (m <= 0) continue;
                    JSONObject profiles = new JSONObject();
                    for (k = 0; k < m; ++k) {
                        profiles.put(Integer.toString(k), (Object)MediaCodecUtils.getProfileLevelString(types[j], profileLevel[k]));
                    }
                    codec.put("PROFILES", (Object)profiles);
                    continue;
                }
                catch (Exception e) {
                    codec.put("PROFILES", (Object)e.getMessage());
                }
            }
            if (!isvideo) continue;
            result.put(codecInfo.getName(), (Object)codec);
        }
        return result;
    }

    private static final JSONObject getAudio() throws JSONException {
        JSONObject result = new JSONObject();
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            JSONObject codec = new JSONObject();
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            boolean isaudio = false;
            for (int j = 0; j < n; ++j) {
                if (!types[j].startsWith("audio/")) continue;
                isaudio = true;
                codec.put(Integer.toString(j), (Object)types[j]);
            }
            if (!isaudio) continue;
            result.put(codecInfo.getName(), (Object)codec);
        }
        return result;
    }

    public static final String getColorFormatName(int colorFormat) {
        switch (colorFormat) {
            case 3: {
                return "COLOR_Format12bitRGB444";
            }
            case 5: {
                return "COLOR_Format16bitARGB1555";
            }
            case 4: {
                return "COLOR_Format16bitARGB4444";
            }
            case 7: {
                return "COLOR_Format16bitBGR565";
            }
            case 6: {
                return "COLOR_Format16bitRGB565";
            }
            case 41: {
                return "COLOR_Format18BitBGR666";
            }
            case 9: {
                return "COLOR_Format18bitARGB1665";
            }
            case 8: {
                return "COLOR_Format18bitRGB666";
            }
            case 10: {
                return "COLOR_Format19bitARGB1666";
            }
            case 43: {
                return "COLOR_Format24BitABGR6666";
            }
            case 42: {
                return "COLOR_Format24BitARGB6666";
            }
            case 13: {
                return "COLOR_Format24bitARGB1887";
            }
            case 12: {
                return "COLOR_Format24bitBGR888";
            }
            case 11: {
                return "COLOR_Format24bitRGB888";
            }
            case 14: {
                return "COLOR_Format25bitARGB1888";
            }
            case 16: {
                return "COLOR_Format32bitARGB8888";
            }
            case 15: {
                return "COLOR_Format32bitBGRA8888";
            }
            case 2: {
                return "COLOR_Format8bitRGB332";
            }
            case 27: {
                return "COLOR_FormatCbYCrY";
            }
            case 28: {
                return "COLOR_FormatCrYCbY";
            }
            case 36: {
                return "COLOR_FormatL16";
            }
            case 33: {
                return "COLOR_FormatL2";
            }
            case 37: {
                return "COLOR_FormatL24";
            }
            case 38: {
                return "COLOR_FormatL32";
            }
            case 34: {
                return "COLOR_FormatL4";
            }
            case 35: {
                return "COLOR_FormatL8";
            }
            case 1: {
                return "COLOR_FormatMonochrome";
            }
            case 31: {
                return "COLOR_FormatRawBayer10bit";
            }
            case 30: {
                return "COLOR_FormatRawBayer8bit";
            }
            case 32: {
                return "COLOR_FormatRawBayer8bitcompressed";
            }
            case 2130708361: {
                return "COLOR_FormatSurface_COLOR_FormatAndroidOpaque";
            }
            case 25: {
                return "COLOR_FormatYCbYCr";
            }
            case 26: {
                return "COLOR_FormatYCrYCb";
            }
            case 18: {
                return "COLOR_FormatYUV411PackedPlanar";
            }
            case 17: {
                return "COLOR_FormatYUV411Planar";
            }
            case 20: {
                return "COLOR_FormatYUV420PackedPlanar";
            }
            case 39: {
                return "COLOR_FormatYUV420PackedSemiPlanar";
            }
            case 19: {
                return "COLOR_FormatYUV420Planar";
            }
            case 21: {
                return "COLOR_FormatYUV420SemiPlanar";
            }
            case 23: {
                return "COLOR_FormatYUV422PackedPlanar";
            }
            case 40: {
                return "COLOR_FormatYUV422PackedSemiPlanar";
            }
            case 22: {
                return "COLOR_FormatYUV422Planar";
            }
            case 24: {
                return "COLOR_FormatYUV422SemiPlanar";
            }
            case 29: {
                return "COLOR_FormatYUV444Interleaved";
            }
            case 2141391872: {
                return "COLOR_QCOM_FormatYUV420SemiPlanar";
            }
            case 2130706688: {
                return "COLOR_TI_FormatYUV420PackedSemiPlanar";
            }
            case 0x6F000000: {
                return "OMX_COLOR_FormatKhronosExtensions";
            }
            case 2135033992: {
                return "COLOR_FormatYUV420Flexible";
            }
            case 2141391875: {
                return "OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar64x32Tile2m8ka";
            }
            case 2143289346: {
                return "OMX_SEC_COLOR_FormatNV12Tiled";
            }
            case 2141391876: {
                return "OMX_QCOM_COLOR_FormatYUV420PackedSemiPlanar32m";
            }
        }
        return String.format(Locale.getDefault(), "COLOR_Format_Unknown(%d)", colorFormat);
    }

    public static String getProfileLevelString(String mimeType, MediaCodecInfo.CodecProfileLevel profileLevel) {
        String result;
        if (!TextUtils.isEmpty((CharSequence)mimeType)) {
            if (mimeType.equalsIgnoreCase(MIME_VIDEO_AVC)) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "AVCProfileBaseline";
                        break;
                    }
                    case 2: {
                        result = "AVCProfileMain";
                        break;
                    }
                    case 4: {
                        result = "AVCProfileExtended";
                        break;
                    }
                    case 8: {
                        result = "AVCProfileHigh";
                        break;
                    }
                    case 16: {
                        result = "AVCProfileHigh10";
                        break;
                    }
                    case 32: {
                        result = "AVCProfileHigh422";
                        break;
                    }
                    case 64: {
                        result = "AVCProfileHigh444";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".AVCLevel1";
                        break;
                    }
                    case 2: {
                        result = result + ".AVCLevel1b";
                        break;
                    }
                    case 4: {
                        result = result + ".AVCLevel11";
                        break;
                    }
                    case 8: {
                        result = result + ".AVCLevel12";
                        break;
                    }
                    case 16: {
                        result = result + ".AVCLevel13";
                        break;
                    }
                    case 32: {
                        result = result + ".AVCLevel2";
                        break;
                    }
                    case 64: {
                        result = result + ".AVCLevel21";
                        break;
                    }
                    case 128: {
                        result = result + ".AVCLevel22";
                        break;
                    }
                    case 256: {
                        result = result + ".AVCLevel3";
                        break;
                    }
                    case 512: {
                        result = result + ".AVCLevel31";
                        break;
                    }
                    case 1024: {
                        result = result + ".AVCLevel32";
                        break;
                    }
                    case 2048: {
                        result = result + ".AVCLevel4";
                        break;
                    }
                    case 4096: {
                        result = result + ".AVCLevel41";
                        break;
                    }
                    case 8192: {
                        result = result + ".AVCLevel42";
                        break;
                    }
                    case 16384: {
                        result = result + ".AVCLevel5";
                        break;
                    }
                    case 32768: {
                        result = result + ".AVCLevel51";
                        break;
                    }
                    default: {
                        result = result + ".unknown level " + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/h263")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "H263ProfileBaseline";
                        break;
                    }
                    case 2: {
                        result = "H263ProfileH320Coding";
                        break;
                    }
                    case 4: {
                        result = "H263ProfileBackwardCompatible";
                        break;
                    }
                    case 8: {
                        result = "H263ProfileISWV2";
                        break;
                    }
                    case 16: {
                        result = "H263ProfileISWV3";
                        break;
                    }
                    case 32: {
                        result = "H263ProfileHighCompression";
                        break;
                    }
                    case 64: {
                        result = "H263ProfileInternet";
                        break;
                    }
                    case 128: {
                        result = "H263ProfileInterlace";
                        break;
                    }
                    case 256: {
                        result = "H263ProfileHighLatency";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".H263Level10";
                        break;
                    }
                    case 2: {
                        result = result + ".H263Level20";
                        break;
                    }
                    case 4: {
                        result = result + ".H263Level30";
                        break;
                    }
                    case 8: {
                        result = result + ".H263Level40";
                        break;
                    }
                    case 16: {
                        result = result + ".H263Level45";
                        break;
                    }
                    case 32: {
                        result = result + ".H263Level50";
                        break;
                    }
                    case 64: {
                        result = result + ".H263Level60";
                        break;
                    }
                    case 128: {
                        result = result + ".H263Level70";
                        break;
                    }
                    default: {
                        result = result + ".unknown level " + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/mpeg4")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "MPEG4ProfileSimple";
                        break;
                    }
                    case 2: {
                        result = "MPEG4ProfileSimpleScalable";
                        break;
                    }
                    case 4: {
                        result = "MPEG4ProfileCore";
                        break;
                    }
                    case 8: {
                        result = "MPEG4ProfileMain";
                        break;
                    }
                    case 16: {
                        result = "MPEG4ProfileNbit";
                        break;
                    }
                    case 32: {
                        result = "MPEG4ProfileScalableTexture";
                        break;
                    }
                    case 64: {
                        result = "MPEG4ProfileSimpleFace";
                        break;
                    }
                    case 128: {
                        result = "MPEG4ProfileSimpleFBA";
                        break;
                    }
                    case 256: {
                        result = "MPEG4ProfileBasicAnimated";
                        break;
                    }
                    case 512: {
                        result = "MPEG4ProfileHybrid";
                        break;
                    }
                    case 1024: {
                        result = "MPEG4ProfileAdvancedRealTime";
                        break;
                    }
                    case 2048: {
                        result = "MPEG4ProfileCoreScalable";
                        break;
                    }
                    case 4096: {
                        result = "MPEG4ProfileAdvancedCoding";
                        break;
                    }
                    case 8192: {
                        result = "MPEG4ProfileAdvancedCore";
                        break;
                    }
                    case 16384: {
                        result = "MPEG4ProfileAdvancedScalable";
                        break;
                    }
                    case 32768: {
                        result = "MPEG4ProfileAdvancedSimple";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".MPEG4Level0";
                        break;
                    }
                    case 2: {
                        result = result + ".MPEG4Level0b";
                        break;
                    }
                    case 4: {
                        result = result + ".MPEG4Level1";
                        break;
                    }
                    case 8: {
                        result = result + ".MPEG4Level2";
                        break;
                    }
                    case 16: {
                        result = result + ".MPEG4Level3";
                        break;
                    }
                    case 32: {
                        result = result + ".MPEG4Level4";
                        break;
                    }
                    case 64: {
                        result = result + ".MPEG4Level4a";
                        break;
                    }
                    case 128: {
                        result = result + ".MPEG4Level5";
                        break;
                    }
                    default: {
                        result = result + ".unknown level " + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("ausio/aac")) {
                switch (profileLevel.level) {
                    case 1: {
                        result = "AACObjectMain";
                        break;
                    }
                    case 2: {
                        result = "AACObjectLC";
                        break;
                    }
                    case 3: {
                        result = "AACObjectSSR";
                        break;
                    }
                    case 4: {
                        result = "AACObjectLTP";
                        break;
                    }
                    case 5: {
                        result = "AACObjectHE";
                        break;
                    }
                    case 6: {
                        result = "AACObjectScalable";
                        break;
                    }
                    case 17: {
                        result = "AACObjectERLC";
                        break;
                    }
                    case 23: {
                        result = "AACObjectLD";
                        break;
                    }
                    case 29: {
                        result = "AACObjectHE_PS";
                        break;
                    }
                    case 39: {
                        result = "AACObjectELD";
                        break;
                    }
                    case 42: {
                        result = "AACObjectXHE";
                        break;
                    }
                    default: {
                        result = "profile:unknown " + profileLevel.profile;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/vp8")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "VP8ProfileMain";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".VP8Level_Version0";
                        break;
                    }
                    case 2: {
                        result = result + ".VP8Level_Version1";
                        break;
                    }
                    case 4: {
                        result = result + ".VP8Level_Version2";
                        break;
                    }
                    case 8: {
                        result = result + ".VP8Level_Version3";
                        break;
                    }
                    default: {
                        result = result + ".unknown level" + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/vp9")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "VP9Profile0";
                        break;
                    }
                    case 2: {
                        result = "VP9Profile1";
                        break;
                    }
                    case 4: {
                        result = "VP9Profile2";
                        break;
                    }
                    case 8: {
                        result = "VP9Profile3";
                        break;
                    }
                    case 4096: {
                        result = "VP9Profile2HDR";
                        break;
                    }
                    case 8192: {
                        result = "VP9Profile3HDR";
                        break;
                    }
                    case 16384: {
                        result = "VP9Profile2HDR10Plus";
                        break;
                    }
                    case 32768: {
                        result = "VP9Profile3HDR10Plus";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".VP9Level1";
                        break;
                    }
                    case 2: {
                        result = result + ".VP9Level11";
                        break;
                    }
                    case 4: {
                        result = result + ".VP9Level2";
                        break;
                    }
                    case 8: {
                        result = result + ".VP9Level21";
                        break;
                    }
                    case 16: {
                        result = result + ".VP9Level3";
                        break;
                    }
                    case 32: {
                        result = result + ".VP9Level31";
                        break;
                    }
                    case 64: {
                        result = result + ".VP9Level4";
                        break;
                    }
                    case 128: {
                        result = result + ".VP9Level41";
                        break;
                    }
                    case 256: {
                        result = result + ".VP9Level5";
                        break;
                    }
                    case 512: {
                        result = result + ".VP9Level51";
                        break;
                    }
                    case 1024: {
                        result = result + ".VP9Level52";
                        break;
                    }
                    case 2048: {
                        result = result + ".VP9Level6";
                        break;
                    }
                    case 4096: {
                        result = result + ".VP9Level61";
                        break;
                    }
                    case 8192: {
                        result = result + ".VP9Level62";
                        break;
                    }
                    default: {
                        result = result + ".unknown level" + profileLevel.level;
                        break;
                    }
                }
            } else if (mimeType.equalsIgnoreCase("video/hevc")) {
                switch (profileLevel.profile) {
                    case 1: {
                        result = "HEVCProfileMain";
                        break;
                    }
                    case 2: {
                        result = "HEVCProfileMain10";
                        break;
                    }
                    case 4: {
                        result = "HEVCProfileMainStill";
                        break;
                    }
                    case 4096: {
                        result = "HEVCProfileMain10HDR10";
                        break;
                    }
                    case 8192: {
                        result = "HEVCProfileMain10HDR10Plus";
                        break;
                    }
                    default: {
                        result = "unknown profile " + profileLevel.profile;
                    }
                }
                switch (profileLevel.level) {
                    case 1: {
                        result = result + ".HEVCMainTierLevel1";
                        break;
                    }
                    case 2: {
                        result = result + ".HEVCHighTierLevel1";
                        break;
                    }
                    case 4: {
                        result = result + ".HEVCMainTierLevel2";
                        break;
                    }
                    case 8: {
                        result = result + ".HEVCHighTierLevel2";
                        break;
                    }
                    case 16: {
                        result = result + ".HEVCMainTierLevel21";
                        break;
                    }
                    case 32: {
                        result = result + ".HEVCHighTierLevel21";
                        break;
                    }
                    case 64: {
                        result = result + ".HEVCMainTierLevel3";
                        break;
                    }
                    case 128: {
                        result = result + ".HEVCHighTierLevel3";
                        break;
                    }
                    case 256: {
                        result = result + ".HEVCMainTierLevel31";
                        break;
                    }
                    case 512: {
                        result = result + ".HEVCHighTierLevel31";
                        break;
                    }
                    case 1024: {
                        result = result + ".HEVCMainTierLevel4";
                        break;
                    }
                    case 2048: {
                        result = result + ".HEVCHighTierLevel4";
                        break;
                    }
                    case 4096: {
                        result = result + ".HEVCMainTierLevel41";
                        break;
                    }
                    case 8192: {
                        result = result + ".HEVCHighTierLevel41";
                        break;
                    }
                    case 16384: {
                        result = result + ".HEVCMainTierLevel5";
                        break;
                    }
                    case 32768: {
                        result = result + ".HEVCHighTierLevel5";
                        break;
                    }
                    case 65536: {
                        result = result + ".HEVCMainTierLevel51";
                        break;
                    }
                    case 131072: {
                        result = result + ".HEVCHighTierLevel51";
                        break;
                    }
                    case 262144: {
                        result = result + ".HEVCMainTierLevel52";
                        break;
                    }
                    case 524288: {
                        result = result + ".HEVCHighTierLevel52";
                        break;
                    }
                    case 0x100000: {
                        result = result + ".HEVCMainTierLevel6";
                        break;
                    }
                    case 0x200000: {
                        result = result + ".HEVCHighTierLevel6";
                        break;
                    }
                    case 0x400000: {
                        result = result + ".HEVCMainTierLevel61";
                        break;
                    }
                    case 0x800000: {
                        result = result + ".HEVCHighTierLevel61";
                        break;
                    }
                    case 0x1000000: {
                        result = result + ".HEVCMainTierLevel62";
                        break;
                    }
                    case 0x2000000: {
                        result = result + ".HEVCHighTierLevel62";
                        break;
                    }
                    default: {
                        result = result + ".unknown level" + profileLevel.level;
                        break;
                    }
                }
            } else {
                result = "unknown profile " + profileLevel.profile;
            }
        } else {
            result = "mime type is null";
        }
        return result;
    }

    private static final void updateCodecs() {
        if (sCodecList.size() == 0) {
            int n = MediaCodecList.getCodecCount();
            for (int i = 0; i < n; ++i) {
                sCodecList.add(MediaCodecList.getCodecInfoAt((int)i));
            }
        }
    }

    public static final int getCodecCount() {
        MediaCodecUtils.updateCodecs();
        return sCodecList.size();
    }

    public static final List<MediaCodecInfo> getCodecs() {
        MediaCodecUtils.updateCodecs();
        return sCodecList;
    }

    public static final MediaCodecInfo getCodecInfoAt(int ix) {
        MediaCodecUtils.updateCodecs();
        return sCodecList.get(ix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaCodecInfo.CodecCapabilities getCodecCapabilities(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities capabilities;
        HashMap<Object, Object> caps = sCapabilities.get(mimeType);
        if (caps == null) {
            caps = new HashMap();
            sCapabilities.put(mimeType, caps);
        }
        if ((capabilities = caps.get(codecInfo)) == null) {
            Thread.currentThread().setPriority(10);
            try {
                capabilities = codecInfo.getCapabilitiesForType(mimeType);
                caps.put(codecInfo, capabilities);
            }
            finally {
                Thread.currentThread().setPriority(5);
            }
        }
        return capabilities;
    }

    @Nullable
    public static MediaCodecInfo selectVideoEncoder(String mimeType) {
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            for (int j = 0; j < n; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = MediaCodecUtils.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                return codecInfo;
            }
        }
        return null;
    }

    @NonNull
    public static List<MediaCodecInfo> getVideoEncoderInfos(String mimeType) {
        ArrayList<MediaCodecInfo> result = new ArrayList<MediaCodecInfo>();
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            int n = types.length;
            for (int j = 0; j < n; ++j) {
                int format;
                if (!types[j].equalsIgnoreCase(mimeType) || (format = MediaCodecUtils.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                result.add(codecInfo);
            }
        }
        return result;
    }

    public static final boolean isRecognizedVideoFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }

    public static final int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        int result = 0;
        MediaCodecInfo.CodecCapabilities capabilities = MediaCodecUtils.getCodecCapabilities(codecInfo, mimeType);
        for (int colorFormat : capabilities.colorFormats) {
            if (!MediaCodecUtils.isRecognizedVideoFormat(colorFormat)) continue;
            result = colorFormat;
            break;
        }
        return result;
    }

    public static final void dumpEncoders() {
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                Log.i((String)TAG, (String)("codec:" + codecInfo.getName() + ",MIME:" + types[j]));
                MediaCodecUtils.selectColorFormat(codecInfo, types[j]);
            }
        }
    }

    public static final void dumpDecoders() {
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            if (codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                Log.i((String)TAG, (String)("codec:" + codecInfo.getName() + ",MIME:" + types[j]));
                MediaCodecUtils.selectColorFormat(codecInfo, types[j]);
            }
        }
    }

    public static final boolean isSemiPlanarYUV(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: {
                return false;
            }
            case 21: 
            case 39: 
            case 2130706688: 
            case 2141391872: {
                return true;
            }
        }
        throw new RuntimeException("unknown format " + colorFormat);
    }

    @Nullable
    public static final MediaCodecInfo selectAudioEncoder(String mimeType) {
        MediaCodecInfo result = null;
        int numCodecs = MediaCodecUtils.getCodecCount();
        block0: for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                result = codecInfo;
                break block0;
            }
        }
        return result;
    }

    @NonNull
    public static List<MediaCodecInfo> getAudioEncoderInfos(String mimeType) {
        ArrayList<MediaCodecInfo> result = new ArrayList<MediaCodecInfo>();
        int numCodecs = MediaCodecUtils.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecUtils.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                result.add(codecInfo);
            }
        }
        return result;
    }

    public static boolean checkProfileLevel(String mimeType, MediaCodecInfo info) {
        if (info != null && mimeType.equalsIgnoreCase(MIME_VIDEO_AVC)) {
            MediaCodecInfo.CodecCapabilities caps = MediaCodecUtils.getCodecCapabilities(info, mimeType);
            MediaCodecInfo.CodecProfileLevel[] profileLevel = caps.profileLevels;
            for (int j = 0; j < profileLevel.length; ++j) {
                if (profileLevel[j].level < 16384) continue;
                return false;
            }
        }
        return true;
    }

    public static final int findStartMarker(@NonNull byte[] array, int offset) {
        return BufferHelper.byteComp(array, offset, START_MARKER, START_MARKER.length);
    }
}

