/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.IVideoEncoder;
import com.serenegiant.system.BuildCheck;

@TargetApi(value=16)
public abstract class AbstractVideoEncoder
extends AbstractEncoder
implements IVideoEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = AbstractVideoEncoder.class.getSimpleName();
    protected int mWidth;
    protected int mHeight;
    protected int mBitRate = -1;
    protected int mFramerate = -1;
    protected int mIFrameIntervals = -1;
    public static boolean supportsAdaptiveStreaming = BuildCheck.isKitKat();

    public AbstractVideoEncoder(@NonNull String mime, @NonNull IRecorder recorder, @NonNull EncoderListener listener) {
        super(mime, recorder, listener);
    }

    @Override
    public void setVideoSize(int width, int height) throws IllegalArgumentException, IllegalStateException {
        this.mWidth = width;
        this.mHeight = height;
        this.mBitRate = this.getConfig().getBitrate(width, height);
    }

    @Override
    public void setVideoConfig(int bitRate, int frameRate, int iFrameIntervals) {
        this.mBitRate = bitRate;
        this.mFramerate = frameRate;
        this.mIFrameIntervals = iFrameIntervals;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public final boolean isAudio() {
        return false;
    }

    @TargetApi(value=19)
    public void adjustBitrate(int targetBitrate) {
        if (supportsAdaptiveStreaming && this.mMediaCodec != null) {
            Bundle bitrate = new Bundle();
            bitrate.putInt("video-bitrate", targetBitrate);
            this.mMediaCodec.setParameters(bitrate);
        } else if (!supportsAdaptiveStreaming) {
            Log.w((String)TAG, (String)"adjustBitrate: Ignoring adjustVideoBitrate call. This functionality is only available on Android API 19+");
        }
    }
}

