/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.math;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class Fraction
implements Parcelable {
    public static final Fraction ZERO = Fraction.unmodifiableFraction(0, 1);
    public static final Fraction ONE = Fraction.unmodifiableFraction(1, 1);
    public static final Fraction MINUS = Fraction.unmodifiableFraction(-1, 1);
    public static final Fraction TWO = Fraction.unmodifiableFraction(2, 1);
    public static final Fraction THREE = Fraction.unmodifiableFraction(3, 1);
    public static final Fraction FOUR = Fraction.unmodifiableFraction(4, 1);
    public static final Fraction FIVE = Fraction.unmodifiableFraction(5, 1);
    public static final Fraction TEN = Fraction.unmodifiableFraction(10, 1);
    public static final Fraction ONE_HALF = Fraction.unmodifiableFraction(1, 2);
    public static final Fraction ONE_THIRD = Fraction.unmodifiableFraction(1, 3);
    public static final Fraction ONE_QUARTER;
    public static final Fraction ONE_FOURTH;
    public static final Fraction ONE_FIFTH;
    public static final Fraction TWO_THIRD;
    public static final Fraction THREE_QUARTER;
    public static final Fraction THREE_FOURTH;
    private static final double DEFAULT_EPS = 1.0E-5;
    private int mNumerator;
    private int mDenominator;
    public static final Parcelable.Creator<Fraction> CREATOR;

    public Fraction() {
        this.mDenominator = 1;
    }

    public Fraction(int numerator) {
        this.mNumerator = numerator;
        this.mDenominator = 1;
    }

    public Fraction(double value) {
        this(value, 1.0E-5, Integer.MAX_VALUE, 100);
    }

    public Fraction(double value, double eps) {
        this(value, eps, Integer.MAX_VALUE, 100);
    }

    private Fraction(double value, double eps, int maxDenominator, int maxIterations) {
        long q2;
        long p2;
        long overflow = Integer.MAX_VALUE;
        double r0 = value;
        long a0 = (long)Math.floor(r0);
        if (Math.abs(a0) > overflow) {
            throw new IllegalArgumentException(String.format("Failed to create Fraction, v=%f,%d,%d)", value, a0, 1L));
        }
        if (Math.abs((double)a0 - value) < eps) {
            this.mNumerator = (int)a0;
            this.mDenominator = 1;
        }
        long p0 = 1L;
        long q0 = 0L;
        long p1 = a0;
        long q1 = 1L;
        int n = 0;
        boolean stop = false;
        do {
            ++n;
            double r1 = 1.0 / (r0 - (double)a0);
            long a1 = (long)Math.floor(r1);
            p2 = a1 * p1 + p0;
            q2 = a1 * q1 + q0;
            if (Math.abs(p2) > overflow || Math.abs(q2) > overflow) {
                if (eps == 0.0 && Math.abs(q1) < (long)maxDenominator) break;
                throw new IllegalArgumentException(String.format("Failed to create Fraction, v=%f,%d,%d)", value, p2, q2));
            }
            double convergent = (double)p2 / (double)q2;
            if (n < maxIterations && Math.abs(convergent - value) > eps && q2 < (long)maxDenominator) {
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                a0 = a1;
                r0 = r1;
                continue;
            }
            stop = true;
        } while (!stop);
        if (n >= maxIterations) {
            throw new IllegalArgumentException(String.format("Failed to create Fraction, v=%f,%d,%d)", value, p2, q2));
        }
        if (q2 < (long)maxDenominator) {
            this.mNumerator = (int)p2;
            this.mDenominator = (int)q2;
        } else {
            this.mNumerator = (int)p1;
            this.mDenominator = (int)q1;
        }
    }

    public Fraction(int numerator, int denominator) throws IllegalArgumentException {
        if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("numerator/denominator should not MIN_VALUE.");
        }
        if (denominator < 0) {
            this.mNumerator = -numerator;
            this.mDenominator = -denominator;
        } else if (denominator > 0) {
            this.mNumerator = numerator;
            this.mDenominator = denominator;
        } else {
            throw new IllegalArgumentException("denominator should not zero/MIN_VALUE.");
        }
    }

    public Fraction(@Nullable Fraction src) {
        if (src == null) {
            this.mNumerator = 0;
            this.mDenominator = 1;
        } else {
            this.mNumerator = src.mNumerator;
            this.mDenominator = src.mDenominator;
        }
    }

    protected Fraction(@NonNull Parcel in) {
        this.mNumerator = in.readInt();
        this.mDenominator = in.readInt();
    }

    public int numerator() {
        return this.mNumerator;
    }

    public int denominator() {
        return this.mDenominator;
    }

    public float asFloat() {
        return (float)this.mNumerator / (float)this.mDenominator;
    }

    public double asDouble() {
        return (double)this.mNumerator / (double)this.mDenominator;
    }

    public String asString() {
        return this.mNumerator + "/" + this.mDenominator;
    }

    public Fraction dup() {
        return new Fraction(this);
    }

    public int sign() throws IllegalArgumentException {
        return Integer.signum(this.mNumerator) * Integer.signum(this.mDenominator);
    }

    @NonNull
    public Fraction reset() {
        this.mNumerator = 0;
        this.mDenominator = 1;
        return this;
    }

    @NonNull
    public Fraction reduced() {
        int gcd = Fraction.gcd(this.mNumerator, this.mDenominator);
        this.mNumerator /= gcd;
        this.mDenominator /= gcd;
        if (this.mDenominator < 0) {
            this.mNumerator = -this.mNumerator;
            this.mDenominator = -this.mDenominator;
        }
        return this;
    }

    public Fraction abs() {
        this.mNumerator = Math.abs(this.mNumerator);
        this.mDenominator = Math.abs(this.mDenominator);
        return this.reduced();
    }

    public Fraction invert() {
        long v = (long)this.mNumerator * (long)this.mDenominator;
        this.mNumerator = v == 0L ? 0 : (v == 0L ? 0 : (v > 0L ? -Math.abs(this.mNumerator) : Math.abs(this.mNumerator)));
        this.mDenominator = Math.abs(this.mDenominator);
        return this.reduced();
    }

    @NonNull
    public Fraction add(@NonNull Fraction value) {
        this.mNumerator = value.mDenominator * this.mNumerator + value.mNumerator * this.mDenominator;
        this.mDenominator *= value.mDenominator;
        return this.reduced();
    }

    @NonNull
    public Fraction sub(@NonNull Fraction value) {
        this.mNumerator = value.mDenominator * this.mNumerator - value.mNumerator * this.mDenominator;
        this.mDenominator *= value.mDenominator;
        return this.reduced();
    }

    @NonNull
    public Fraction multiply(@NonNull Fraction value) {
        this.mNumerator *= value.mNumerator;
        this.mDenominator *= value.mDenominator;
        return this.reduced();
    }

    @NonNull
    public Fraction multiply(int value) {
        this.mNumerator *= value;
        return this.reduced();
    }

    @NonNull
    public Fraction div(@NonNull Fraction value) {
        this.mNumerator *= value.mDenominator;
        this.mDenominator *= value.mNumerator;
        return this.reduced();
    }

    @NonNull
    public Fraction div(int value) {
        this.mDenominator *= value;
        return this.reduced();
    }

    public Fraction absFraction() {
        return Fraction.reducedFraction(Math.abs(this.mNumerator), Math.abs(this.mDenominator));
    }

    public Fraction invertFraction() {
        long v = (long)this.mNumerator * (long)this.mDenominator;
        int numerator = v == 0L ? 0 : (v == 0L ? 0 : (v > 0L ? -Math.abs(this.mNumerator) : Math.abs(this.mNumerator)));
        return Fraction.reducedFraction(numerator, Math.abs(this.mDenominator));
    }

    @NonNull
    public Fraction reducedFraction() {
        return Fraction.reducedFraction(this.mNumerator, this.mDenominator);
    }

    @NonNull
    public Fraction addFraction(@NonNull Fraction value) {
        int numerator = value.mDenominator * this.mNumerator + value.mNumerator * this.mDenominator;
        int denominator = this.mDenominator * value.mDenominator;
        return Fraction.reducedFraction(numerator, denominator);
    }

    @NonNull
    public Fraction subFraction(@NonNull Fraction value) {
        int numerator = value.mDenominator * this.mNumerator - value.mNumerator * this.mDenominator;
        int denominator = this.mDenominator * value.mDenominator;
        return Fraction.reducedFraction(numerator, denominator);
    }

    @NonNull
    public Fraction multiplyFraction(@NonNull Fraction value) {
        return Fraction.reducedFraction(this.mNumerator * value.mNumerator, this.mDenominator * value.mDenominator);
    }

    @NonNull
    public Fraction multiplyFraction(int value) {
        return Fraction.reducedFraction(this.mNumerator * value, this.mDenominator);
    }

    @NonNull
    public Fraction divFraction(@NonNull Fraction value) {
        return Fraction.reducedFraction(this.mNumerator * value.mDenominator, this.mDenominator * value.mNumerator);
    }

    @NonNull
    public Fraction divFraction(int value) {
        return Fraction.reducedFraction(this.mNumerator, this.mDenominator * value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Fraction)) {
            return false;
        }
        Fraction fraction = (Fraction)o;
        return this.mNumerator == fraction.mNumerator && this.mDenominator == fraction.mDenominator;
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.hash(this.mNumerator, this.mDenominator);
        }
        return Arrays.hashCode(new int[]{this.mNumerator, this.mDenominator});
    }

    @NonNull
    public String toString() {
        return "Fraction{numerator=" + this.mNumerator + ", denominator=" + this.mDenominator + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNumerator);
        dest.writeInt(this.mDenominator);
    }

    public static Fraction unmodifiableFraction(@NonNull Fraction value) {
        return Fraction.unmodifiableFraction(value.mNumerator, value.mDenominator);
    }

    public static Fraction unmodifiableFraction(int numerator, int denominator) {
        return new Fraction(numerator, denominator){

            @Override
            @NonNull
            public Fraction reset() {
                throw new UnsupportedOperationException("Can't modify this Fraction instance.");
            }

            @Override
            public Fraction abs() {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #absFraction instead.");
            }

            @Override
            public Fraction invert() {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #invertFraction instead.");
            }

            @Override
            @NonNull
            public Fraction reduced() {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #reducedFraction instead.");
            }

            @Override
            @NonNull
            public Fraction add(@NonNull Fraction value) {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #addFraction instead.");
            }

            @Override
            @NonNull
            public Fraction sub(@NonNull Fraction value) {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #subFraction instead.");
            }

            @Override
            @NonNull
            public Fraction multiply(@NonNull Fraction value) {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #multiplyFraction instead.");
            }

            @Override
            @NonNull
            public Fraction multiply(int value) {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #multiplyFraction instead.");
            }

            @Override
            @NonNull
            public Fraction div(@NonNull Fraction value) {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #divFraction instead.");
            }

            @Override
            @NonNull
            public Fraction div(int value) {
                throw new UnsupportedOperationException("Can't modify this Fraction instance, use #divFraction instead.");
            }
        };
    }

    @NonNull
    private static Fraction reducedFraction(int numerator, int denominator) throws IllegalArgumentException {
        if (denominator == 0) {
            throw new IllegalArgumentException("denominator should not zero");
        }
        if (numerator == 0) {
            return new Fraction(ZERO);
        }
        int gcd = Fraction.gcd(numerator, denominator);
        return new Fraction(numerator / gcd, denominator / gcd);
    }

    private static int gcd(int numerator, int denominator) {
        int a = Math.abs(numerator);
        int b = Math.abs(denominator);
        while (b > 0) {
            int c = a;
            a = b;
            b = c % b;
        }
        return a;
    }

    static {
        ONE_FOURTH = ONE_QUARTER = Fraction.unmodifiableFraction(1, 4);
        ONE_FIFTH = Fraction.unmodifiableFraction(1, 5);
        TWO_THIRD = Fraction.unmodifiableFraction(2, 3);
        THREE_FOURTH = THREE_QUARTER = Fraction.unmodifiableFraction(3, 4);
        CREATOR = new Parcelable.Creator<Fraction>(){

            public Fraction createFromParcel(Parcel in) {
                return new Fraction(in);
            }

            public Fraction[] newArray(int size) {
                return new Fraction[size];
            }
        };
    }
}

