/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.graphics;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.egl.EglTask;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.MessageTask;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class SurfaceDrawable
extends Drawable {
    private static final boolean DEBUG = false;
    private static final String TAG = SurfaceDrawable.class.getSimpleName();
    private static final int REQUEST_DRAW = 1;
    private static final int REQUEST_UPDATE_SIZE = 2;
    private static final int REQUEST_RECREATE_MASTER_SURFACE = 5;
    @NonNull
    private final Object mSync = new Object();
    @NonNull
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private int mImageWidth;
    private int mImageHeight;
    @NonNull
    private final Callback mCallback;
    @NonNull
    private final EglTask mEglTask;
    @NonNull
    private final Bitmap mBitmap;
    @NonNull
    private final Matrix mTransform = new Matrix();
    @NonNull
    private final Paint mPaint = new Paint();
    @Size(min=16L)
    @NonNull
    final float[] mTexMatrix = new float[16];
    private ByteBuffer mWorkBuffer;
    private int mTexId;
    private SurfaceTexture mInputTexture;
    private Surface mInputSurface;
    private GLDrawer2D mDrawer;
    private int mWidth;
    private int mHeight;
    private int drawCnt;
    private final Runnable mInvalidateSelfOnUITask = new Runnable(){

        @Override
        public void run() {
            SurfaceDrawable.this.invalidateSelf();
        }
    };
    private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            SurfaceDrawable.this.mEglTask.offer(1);
        }
    };

    public SurfaceDrawable(int imageWidth, int imageHeight, @NonNull Callback callback) {
        this(imageWidth, imageHeight, GLUtils.getSupportedGLVersion(), callback);
    }

    public SurfaceDrawable(int imageWidth, int imageHeight, int maxClientVersion, @NonNull Callback callback) {
        this.mWidth = this.mImageWidth = imageWidth;
        this.mHeight = this.mImageHeight = imageHeight;
        this.mCallback = callback;
        this.mEglTask = new EglTask(maxClientVersion, null, 0, imageWidth, imageHeight){

            @Override
            protected void onStart() {
                SurfaceDrawable.this.handleOnStart();
            }

            @Override
            protected void onStop() {
                SurfaceDrawable.this.handleOnStop();
            }

            @Override
            protected Object processRequest(int request, int arg1, int arg2, Object obj) throws MessageTask.TaskBreak {
                return SurfaceDrawable.this.handleRequest(request, arg1, arg2, obj);
            }
        };
        this.mBitmap = Bitmap.createBitmap((int)imageWidth, (int)imageHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mWorkBuffer = ByteBuffer.allocateDirect(imageWidth * imageHeight * 4);
        new Thread((Runnable)this.mEglTask, TAG).start();
        this.mEglTask.offer(5);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public void release() {
        this.mEglTask.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas) {
        Bitmap bitmap = this.mBitmap;
        synchronized (bitmap) {
            canvas.drawBitmap(this.mBitmap, this.mTransform, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter filter) {
        this.mPaint.setColorFilter(filter);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mHeight;
    }

    public boolean isSurfaceValid() {
        return this.mInputSurface != null && this.mInputSurface.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface getSurface() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mInputSurface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceTexture getSurfaceTexture() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mInputTexture;
        }
    }

    public void resize(int width, int height) {
        if (width != this.mImageWidth || height != this.mImageHeight) {
            this.mEglTask.offer(2, width, height);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateTransformMatrix();
    }

    protected EGLBase getEgl() {
        return this.mEglTask.getEgl();
    }

    protected EGLBase.IContext<?> getContext() {
        return this.mEglTask.getContext();
    }

    protected boolean isGLES3() {
        return this.mEglTask.isGLES3();
    }

    protected boolean isOES3Supported() {
        return this.mEglTask.isOES3Supported();
    }

    protected int getTexId() {
        return this.mTexId;
    }

    @Size(min=16L)
    @NonNull
    protected float[] getTexMatrix() {
        return this.mTexMatrix;
    }

    @WorkerThread
    protected final void handleOnStart() {
        this.mDrawer = GLDrawer2D.create(this.isOES3Supported(), true);
    }

    @WorkerThread
    protected final void handleOnStop() {
        if (this.mDrawer != null) {
            this.mDrawer.release();
            this.mDrawer = null;
        }
        this.handleReleaseInputSurface();
    }

    @WorkerThread
    protected Object handleRequest(int request, int arg1, int arg2, Object obj) {
        switch (request) {
            case 1: {
                this.handleDraw();
                break;
            }
            case 2: {
                this.handleResize(arg1, arg2);
                break;
            }
            case 5: {
                this.handleReCreateInputSurface();
                break;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    protected void handleDraw() {
        this.mEglTask.removeRequest(1);
        try {
            this.mEglTask.makeCurrent();
            this.mInputTexture.updateTexImage();
            this.mInputTexture.getTransformMatrix(this.mTexMatrix);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("handleDraw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
            return;
        }
        this.mDrawer.draw(33984, this.mTexId, this.mTexMatrix, 0);
        this.mWorkBuffer.clear();
        GLES20.glReadPixels((int)0, (int)0, (int)this.mImageWidth, (int)this.mImageHeight, (int)6408, (int)5121, (Buffer)this.mWorkBuffer);
        this.mWorkBuffer.clear();
        Bitmap bitmap = this.mBitmap;
        synchronized (bitmap) {
            this.mBitmap.copyPixelsFromBuffer((Buffer)this.mWorkBuffer);
        }
        this.mUIHandler.removeCallbacks(this.mInvalidateSelfOnUITask);
        this.mUIHandler.post(this.mInvalidateSelfOnUITask);
    }

    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleResize(int width, int height) {
        if (this.mImageWidth != width || this.mImageHeight != height) {
            this.mBitmap.reconfigure(width, height, Bitmap.Config.ARGB_8888);
            this.mWorkBuffer = ByteBuffer.allocateDirect(width * height * 4);
            this.mImageWidth = width;
            this.mImageHeight = height;
            this.updateTransformMatrix();
            if (BuildCheck.isAndroid4_1() && this.mInputTexture != null) {
                this.mInputTexture.setDefaultBufferSize(this.getIntrinsicWidth(), this.getIntrinsicHeight());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleReCreateInputSurface() {
        Object object = this.mSync;
        synchronized (object) {
            this.mEglTask.makeCurrent();
            this.handleReleaseInputSurface();
            this.mEglTask.makeCurrent();
            this.mTexId = GLUtils.initTex(36197, 33984, 9728);
            this.mInputTexture = new SurfaceTexture(this.mTexId);
            this.mInputSurface = new Surface(this.mInputTexture);
            if (BuildCheck.isAndroid4_1()) {
                this.mInputTexture.setDefaultBufferSize(this.getIntrinsicWidth(), this.getIntrinsicHeight());
            }
            this.mInputTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
        }
        this.onCreateSurface(this.mInputSurface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @WorkerThread
    protected void handleReleaseInputSurface() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mInputSurface != null) {
                try {
                    this.mInputSurface.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mInputSurface = null;
                this.onDestroySurface();
            }
            if (this.mInputTexture != null) {
                try {
                    this.mInputTexture.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                this.mInputTexture = null;
            }
            if (this.mTexId != 0) {
                GLUtils.deleteTex(this.mTexId);
                this.mTexId = 0;
            }
        }
    }

    private void updateTransformMatrix() {
        Rect bounds = this.getBounds();
        this.mWidth = bounds.width();
        this.mHeight = bounds.height();
        float scaleX = (float)this.mWidth / (float)this.mBitmap.getWidth();
        float scaleY = (float)this.mHeight / (float)this.mBitmap.getHeight();
        this.mTransform.reset();
        this.mTransform.postScale(scaleX, scaleY);
    }

    private void onCreateSurface(@NonNull Surface surface) {
        this.mCallback.onCreateSurface(surface);
    }

    private void onDestroySurface() {
        this.mCallback.onDestroySurface();
    }

    public static interface Callback {
        public void onCreateSurface(@NonNull Surface var1);

        public void onDestroySurface();
    }
}

