/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.graphics.SurfaceTexture;
import android.media.Image;
import android.media.ImageReader;
import android.media.ImageWriter;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.gl.GLConst;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLManager;
import com.serenegiant.gl.RendererTarget;
import com.serenegiant.glutils.GLImageReceiver;
import com.serenegiant.glutils.IMirror;
import com.serenegiant.math.Fraction;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.HandlerThreadHandler;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public abstract class SurfaceProxy
implements GLConst,
IMirror {
    private static final String TAG = SurfaceProxy.class.getSimpleName();
    @NonNull
    protected final Object mSync = new Object();
    private volatile boolean mReleased = false;
    private int mWidth;
    private int mHeight;
    protected int mMirror = 0;

    public static SurfaceProxy newInstance(int width, int height, boolean preferReaderWriter) {
        if (preferReaderWriter && BuildCheck.isAPI23()) {
            return new SurfaceProxyReaderWriter(width, height);
        }
        return new SurfaceProxyGLES(width, height);
    }

    private SurfaceProxy(int width, int height) {
        this.mWidth = Math.max(width, 1);
        this.mHeight = Math.max(height, 1);
    }

    protected void finalize() throws Throwable {
        try {
            this.release();
        }
        finally {
            super.finalize();
        }
    }

    public final void release() {
        if (!this.mReleased) {
            this.mReleased = true;
            this.internalRelease();
        }
    }

    @CallSuper
    protected void internalRelease() {
        this.mReleased = true;
    }

    @CallSuper
    public boolean isValid() {
        return !this.mReleased;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMirror() {
        Object object = this.mSync;
        synchronized (object) {
            return this.mMirror;
        }
    }

    @CallSuper
    protected void resize(int width, int height) {
        this.mWidth = Math.max(width, 1);
        this.mHeight = Math.max(height, 1);
    }

    @NonNull
    public abstract Surface getInputSurface();

    public void setSurface(@Nullable Object surface) {
        this.setSurface(surface, null);
    }

    public abstract void setSurface(@Nullable Object var1, @Nullable Fraction var2);

    public static class SurfaceProxyGLES
    extends SurfaceProxy {
        private static final boolean DEBUG = false;
        private static final String TAG = SurfaceProxyGLES.class.getSimpleName();
        @NonNull
        private final GLImageReceiver mReceiver;
        @NonNull
        private final GLManager mManager;
        @Nullable
        private GLDrawer2D mDrawer = null;
        @Nullable
        private RendererTarget mRendererTarget = null;
        private int cnt = 0;

        private SurfaceProxyGLES(int width, int height) throws IllegalStateException {
            this(new GLManager(), width, height, false);
        }

        public SurfaceProxyGLES(@NonNull GLManager manager, int width, int height, boolean useSharedContext) throws IllegalStateException {
            super(width, height);
            final Semaphore sem = new Semaphore(0);
            this.mReceiver = new GLImageReceiver(manager, useSharedContext, width, height, new GLImageReceiver.Callback(){

                @Override
                public void onInitialize(@NonNull GLImageReceiver reader) {
                }

                @Override
                public void onRelease() {
                    this.releaseTargetOnGL();
                }

                @Override
                public void onCreateInputSurface(@NonNull GLImageReceiver reader) {
                    sem.release();
                }

                @Override
                public void onReleaseInputSurface(@NonNull GLImageReceiver reader) {
                }

                @Override
                public void onResize(int width, int height) {
                }

                @Override
                public void onFrameAvailable(@NonNull GLImageReceiver reader, boolean isOES, int texId, @NonNull float[] texMatrix) {
                    this.renderTargetOnGL(isOES, texId, texMatrix);
                }
            });
            try {
                if (!sem.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mManager = this.mReceiver.getGLManager();
            this.getInputSurface();
        }

        @Override
        @CallSuper
        protected void internalRelease() {
            if (this.isValid()) {
                this.mReceiver.release();
            }
            super.internalRelease();
        }

        @Override
        public void resize(int width, int height) throws IllegalStateException {
            super.resize(width, height);
            this.checkValid();
            this.mReceiver.resize(width, height);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMirror(int mirror) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mMirror != mirror) {
                    this.mMirror = mirror;
                    this.mManager.runOnGLThread(() -> {
                        if (this.mRendererTarget != null) {
                            this.mRendererTarget.setMirror(IMirror.flipVertical(mirror));
                        }
                    });
                }
            }
        }

        @Override
        public boolean isValid() {
            return super.isValid() && this.mReceiver.isValid();
        }

        @NonNull
        public SurfaceTexture getInputSurfaceTexture() throws IllegalStateException {
            this.checkValid();
            return this.mReceiver.getSurfaceTexture();
        }

        @Override
        @NonNull
        public Surface getInputSurface() throws IllegalStateException {
            this.checkValid();
            return this.mReceiver.getSurface();
        }

        public int getTexId() {
            this.checkValid();
            return this.mReceiver.getTexId();
        }

        @Size(min=16L)
        @NonNull
        public float[] getTexMatrix() {
            this.checkValid();
            return this.mReceiver.getTexMatrix();
        }

        @Override
        public void setSurface(@Nullable Object surface, @Nullable Fraction fps) throws IllegalStateException, IllegalArgumentException {
            this.checkValid();
            this.mManager.runOnGLThread(() -> this.createTargetOnGL(surface, fps));
        }

        @WorkerThread
        protected void makeDefault() {
            this.mManager.makeDefault();
        }

        protected void checkValid() throws IllegalStateException {
            if (!this.mReceiver.isValid()) {
                throw new IllegalStateException("Already released");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderTargetOnGL(boolean isOES, int texId, @NonNull @Size(min=16L) float[] texMatrix) {
            RendererTarget target;
            GLDrawer2D drawer;
            Object object = this.mSync;
            synchronized (object) {
                if (this.mDrawer == null || isOES != this.mDrawer.isOES()) {
                    if (this.mDrawer != null) {
                        this.mDrawer.release();
                    }
                    this.mDrawer = GLDrawer2D.create(this.mManager.isGLES3(), isOES);
                }
                drawer = this.mDrawer;
                target = this.mRendererTarget;
            }
            if (target != null && target.canDraw()) {
                target.draw(drawer, 33984, texId, texMatrix);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void createTargetOnGL(@Nullable Object surface, @Nullable Fraction maxFps) {
            Object object = this.mSync;
            synchronized (object) {
                Object object2 = this.mSync;
                synchronized (object2) {
                    if (this.mRendererTarget != null && this.mRendererTarget.getSurface() != surface) {
                        this.mRendererTarget.release();
                        this.mRendererTarget = null;
                    }
                    if (this.mRendererTarget == null && surface != null) {
                        this.mRendererTarget = RendererTarget.newInstance(this.mManager.getEgl(), surface, maxFps != null ? maxFps.asFloat() : 0.0f);
                    }
                    if (this.mRendererTarget != null) {
                        this.mRendererTarget.setMirror(IMirror.flipVertical(this.mMirror));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private void releaseTargetOnGL() {
            RendererTarget target;
            GLDrawer2D drawer;
            Object object = this.mSync;
            synchronized (object) {
                drawer = this.mDrawer;
                this.mDrawer = null;
                target = this.mRendererTarget;
                this.mRendererTarget = null;
            }
            if ((drawer != null || target != null) && this.mManager.isValid()) {
                try {
                    this.mManager.runOnGLThread(new Runnable(){

                        @Override
                        @WorkerThread
                        public void run() {
                            if (drawer != null) {
                                drawer.release();
                            }
                            if (target != null) {
                                target.release();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @RequiresApi(api=23)
    public static class SurfaceProxyReaderWriter
    extends SurfaceProxy {
        private static final boolean DEBUG = false;
        private static final String TAG = SurfaceProxyReaderWriter.class.getSimpleName();
        private static final int MAX_IMAGES = 2;
        private final Handler mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
        private ImageReader mImageReader = ImageReader.newInstance((int)this.getWidth(), (int)this.getHeight(), (int)1, (int)2);
        private ImageWriter mImageWriter;

        @SuppressLint(value={"WrongConstant"})
        private SurfaceProxyReaderWriter(int width, int height) {
            super(width, height);
            this.mImageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){
                private int cnt = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onImageAvailable(ImageReader reader) {
                    Image image = reader.acquireLatestImage();
                    if (image != null) {
                        Object object = mSync;
                        synchronized (object) {
                            if (mImageWriter != null) {
                                mImageWriter.queueInputImage(image);
                            } else {
                                image.close();
                            }
                        }
                    }
                }
            }, this.mAsyncHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void internalRelease() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mImageWriter != null) {
                    this.mImageWriter.close();
                    this.mImageWriter = null;
                }
                if (this.mImageReader != null) {
                    this.mImageReader.close();
                    this.mImageReader = null;
                }
            }
            try {
                this.mAsyncHandler.getLooper().quit();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            super.internalRelease();
        }

        @Override
        @NonNull
        public Surface getInputSurface() {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mImageReader != null && this.isValid()) {
                    return this.mImageReader.getSurface();
                }
                throw new IllegalStateException("already released?");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSurface(@Nullable Object surface, @Nullable Fraction fps) {
            Object object = this.mSync;
            synchronized (object) {
                if (this.mImageWriter != null) {
                    this.mImageWriter.close();
                    this.mImageWriter = null;
                }
                if (surface instanceof Surface) {
                    this.mImageWriter = ImageWriter.newInstance((Surface)((Surface)surface), (int)2);
                }
            }
        }

        @Override
        protected void resize(int width, int height) {
            super.resize(width, height);
            throw new UnsupportedOperationException("SurfaceProxyReaderWriter does not support #resize");
        }

        @Override
        public void setMirror(int mirror) {
            throw new UnsupportedOperationException("SurfaceProxyReaderWriter does not support #setMirror");
        }
    }
}

