/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLES30;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.serenegiant.egl.EGLBase;
import com.serenegiant.gl.GLDrawer2D;
import com.serenegiant.gl.GLUtils;
import com.serenegiant.glutils.AbstractRendererHolder;
import com.serenegiant.glutils.IRendererHolder;
import com.serenegiant.system.BuildCheck;
import com.serenegiant.utils.HandlerThreadHandler;

public class MixRendererHolder
extends AbstractRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = MixRendererHolder.class.getSimpleName();
    private static final int REQUEST_SET_MASK = 10;
    private static final String FRAGMENT_SHADER_BASE_ES2 = "#version 100\n%sprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform %s    sTexture2;\nuniform %s    sTexture3;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    highp float alpha = texture2D(sTexture3, vTextureCoord).a;\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * alpha), tex1.a);\n}\n";
    private static final String MY_FRAGMENT_SHADER_EXT_ES2 = String.format("#version 100\n%sprecision highp float;\nvarying       vec2 vTextureCoord;\nuniform %s    sTexture;\nuniform %s    sTexture2;\nuniform %s    sTexture3;\nvoid main() {\n    highp vec4 tex1 = texture2D(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture2D(sTexture2, vTextureCoord);\n    highp float alpha = texture2D(sTexture3, vTextureCoord).a;\n    gl_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * alpha), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "samplerExternalOES", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_BASE_ES3 = "#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nuniform %s sTexture3;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    highp float alpha = texture(sTexture3, vTextureCoord).a;\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * alpha), tex1.a);\n}\n";
    private static final String MY_FRAGMENT_SHADER_EXT_ES3 = String.format("#version 300 es\n%sprecision highp float;\nin vec2 vTextureCoord;\nuniform %s sTexture;\nuniform %s sTexture2;\nuniform %s sTexture3;\nlayout(location = 0) out vec4 o_FragColor;\nvoid main() {\n    highp vec4 tex1 = texture(sTexture, vTextureCoord);\n    highp vec4 tex2 = texture(sTexture2, vTextureCoord);\n    highp float alpha = texture(sTexture3, vTextureCoord).a;\n    o_FragColor = vec4(mix(tex1.rgb, tex2.rgb, tex2.a * alpha), tex1.a);\n}\n", "#extension GL_OES_EGL_image_external_essl3 : require\n", "samplerExternalOES", "samplerExternalOES", "samplerExternalOES");

    public MixRendererHolder(int width, int height, @Nullable IRendererHolder.RenderHolderCallback callback) {
        this(width, height, 3, null, 2, callback);
    }

    public MixRendererHolder(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags, @Nullable IRendererHolder.RenderHolderCallback callback) {
        super(width, height, maxClientVersion, sharedContext, flags, callback);
    }

    public Surface getSurface2() {
        return ((MixRendererTask)this.mRendererTask).getSurface2();
    }

    public SurfaceTexture getSurfaceTexture2() {
        return ((MixRendererTask)this.mRendererTask).getSurfaceTexture2();
    }

    public void setMask(@Nullable Bitmap bitmap) {
        ((MixRendererTask)this.mRendererTask).setMask(bitmap);
    }

    @Override
    @NonNull
    protected AbstractRendererHolder.BaseRendererTask createRendererTask(int width, int height, int maxClientVersion, @Nullable EGLBase.IContext<?> sharedContext, int flags) {
        return new MixRendererTask(this, width, height, maxClientVersion, sharedContext, flags, null);
    }

    private final class MixRendererTask
    extends AbstractRendererHolder.BaseRendererTask {
        @Size(min=16L)
        @NonNull
        private final float[] mTexMatrix2;
        private int mTexId2;
        private SurfaceTexture mMasterTexture2;
        private Surface mMasterSurface2;
        @Size(min=16L)
        @NonNull
        private final float[] mMaskTexMatrix;
        private int mMaskTexId;
        private SurfaceTexture mMaskTexture;
        private Surface mMaskSurface;
        private Handler mAsyncHandler;
        private int cnt;
        private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;

        public MixRendererTask(AbstractRendererHolder parent, int width, int height, @Nullable int maxClientVersion, EGLBase.IContext<?> sharedContext, @Nullable int flags, GLDrawer2D.DrawerFactory factory) {
            super(parent, width, height, maxClientVersion, sharedContext, flags, factory);
            this.mTexMatrix2 = new float[16];
            this.mMaskTexMatrix = new float[16];
            this.mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    MixRendererTask.this.requestFrame(true, MixRendererTask.this.getTexId(), MixRendererTask.this.getTexMatrix());
                }
            };
            if (BuildCheck.isAndroid5()) {
                this.mAsyncHandler = HandlerThreadHandler.createHandler("OnFrameAvailable");
            }
        }

        public Surface getSurface2() {
            this.checkMasterSurface();
            return this.mMasterSurface2;
        }

        public SurfaceTexture getSurfaceTexture2() {
            this.checkMasterSurface();
            return this.mMasterTexture2;
        }

        public void setMask(@Nullable Bitmap mask) {
            this.checkFinished();
            this.offer(10, 0, 0, mask);
        }

        @Override
        protected void internalOnStart() {
            super.internalOnStart();
            GLDrawer2D drawer = this.getDrawer();
            if (drawer != null) {
                if (this.isGLES3()) {
                    this.internalOnStartES3(drawer);
                } else {
                    this.internalOnStartES2(drawer);
                }
            }
        }

        @SuppressLint(value={"NewApi"})
        @WorkerThread
        private void internalOnStartES2(@NonNull GLDrawer2D drawer) {
            drawer.updateShader(MY_FRAGMENT_SHADER_EXT_ES2);
            int uTex1 = drawer.glGetUniformLocation("sTexture");
            GLES20.glUniform1i((int)uTex1, (int)0);
            int uTex2 = drawer.glGetUniformLocation("sTexture2");
            this.mTexId2 = GLUtils.initTex(36197, 33985, 9729, 9729, 33071);
            this.mMasterTexture2 = new SurfaceTexture(this.mTexId2);
            this.mMasterTexture2.setDefaultBufferSize(this.width(), this.height());
            this.mMasterSurface2 = new Surface(this.mMasterTexture2);
            if (BuildCheck.isAndroid5()) {
                this.mMasterTexture2.setOnFrameAvailableListener(this.mOnFrameAvailableListener, this.mAsyncHandler);
            } else {
                this.mMasterTexture2.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
            }
            GLES20.glActiveTexture((int)33985);
            GLES20.glBindTexture((int)36197, (int)this.mTexId2);
            GLES20.glUniform1i((int)uTex2, (int)1);
            int uTex3 = drawer.glGetUniformLocation("sTexture3");
            this.mMaskTexId = GLUtils.initTex(36197, 33986, 9729, 9729, 33071);
            this.mMaskTexture = new SurfaceTexture(this.mMaskTexId);
            this.mMaskTexture.setDefaultBufferSize(this.width(), this.height());
            this.mMaskSurface = new Surface(this.mMaskTexture);
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)36197, (int)this.mMaskTexId);
            GLES20.glUniform1i((int)uTex3, (int)2);
        }

        @SuppressLint(value={"NewApi"})
        @WorkerThread
        private void internalOnStartES3(@NonNull GLDrawer2D drawer) {
            drawer.updateShader(MY_FRAGMENT_SHADER_EXT_ES3);
            int uTex1 = drawer.glGetUniformLocation("sTexture");
            GLES30.glUniform1i((int)uTex1, (int)0);
            int uTex2 = drawer.glGetUniformLocation("sTexture2");
            this.mTexId2 = GLUtils.initTex(36197, 33985, 9729, 9729, 33071);
            this.mMasterTexture2 = new SurfaceTexture(this.mTexId2);
            this.mMasterTexture2.setDefaultBufferSize(this.width(), this.height());
            this.mMasterSurface2 = new Surface(this.mMasterTexture2);
            if (BuildCheck.isAndroid5()) {
                this.mMasterTexture2.setOnFrameAvailableListener(this.mOnFrameAvailableListener, this.mAsyncHandler);
            } else {
                this.mMasterTexture2.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
            }
            GLES30.glActiveTexture((int)33985);
            GLES30.glBindTexture((int)36197, (int)this.mTexId2);
            GLES30.glUniform1i((int)uTex2, (int)1);
            int uTex3 = drawer.glGetUniformLocation("sTexture3");
            this.mMaskTexId = GLUtils.initTex(36197, 33986, 9729, 9729, 33071);
            this.mMaskTexture = new SurfaceTexture(this.mMaskTexId);
            this.mMaskTexture.setDefaultBufferSize(this.width(), this.height());
            this.mMaskSurface = new Surface(this.mMaskTexture);
            GLES30.glActiveTexture((int)33986);
            GLES30.glBindTexture((int)36197, (int)this.mMaskTexId);
            GLES30.glUniform1i((int)uTex3, (int)2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void internalOnStop() {
            MixRendererHolder mixRendererHolder = MixRendererHolder.this;
            synchronized (mixRendererHolder) {
                if (this.mAsyncHandler != null) {
                    try {
                        this.mAsyncHandler.removeCallbacksAndMessages(null);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (Throwable)e);
                    }
                }
            }
            if (this.mMasterTexture2 != null) {
                this.mMasterTexture2.release();
                this.mMasterTexture2 = null;
            }
            this.mMasterSurface2 = null;
            if (this.mTexId2 >= 0) {
                GLUtils.deleteTex(this.mTexId2);
                this.mTexId2 = -1;
            }
            if (this.mMaskTexture != null) {
                this.mMaskTexture.release();
                this.mMaskTexture = null;
            }
            this.mMaskSurface = null;
            if (this.mMaskTexId >= 0) {
                GLUtils.deleteTex(this.mMaskTexId);
                this.mMaskTexId = -1;
            }
            if (this.mAsyncHandler != null) {
                try {
                    this.mAsyncHandler.getLooper().quit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mAsyncHandler = null;
            }
            super.internalOnStop();
        }

        @Override
        protected void handleUpdateTexture() {
            super.handleUpdateTexture();
            this.mMasterTexture2.updateTexImage();
            this.mMasterTexture2.getTransformMatrix(this.mTexMatrix2);
            this.mMaskTexture.updateTexImage();
            this.mMaskTexture.getTransformMatrix(this.mMaskTexMatrix);
        }

        @Override
        protected void handleResize(int width, int height) {
            super.handleResize(width, height);
            if (this.mMasterTexture2 != null) {
                this.mMasterTexture2.setDefaultBufferSize(this.width(), this.height());
            }
            if (this.mMaskTexture != null) {
                this.mMaskTexture.setDefaultBufferSize(this.width(), this.height());
            }
        }

        @Override
        protected Object handleRequest(int request, int arg1, int arg2, Object obj) {
            Object result = null;
            if (request == 10) {
                this.handleSetMask((Bitmap)obj);
            } else {
                result = super.handleRequest(request, arg1, arg2, obj);
            }
            return result;
        }

        protected void handleSetMask(@Nullable Bitmap mask) {
            GLES20.glActiveTexture((int)33986);
            GLES20.glBindTexture((int)36197, (int)this.mMaskTexId);
            try {
                Canvas canvas = this.mMaskSurface.lockCanvas(null);
                try {
                    if (mask != null) {
                        canvas.drawBitmap(mask, 0.0f, 0.0f, null);
                    } else {
                        canvas.drawColor(-16777216);
                    }
                }
                finally {
                    this.mMaskSurface.unlockCanvasAndPost(canvas);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.requestFrame(true, this.getTexId(), this.getTexMatrix());
        }
    }
}

